/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.debug;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.debug.CoroutineInfo;
import kotlinx.coroutines.debug.DebugProbes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001aJ\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u000e\b\u0004\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0080\b\u00a2\u0006\u0002\u0010\u0013\u001a\u0014\u0010\u0014\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a8\u0006\u0016"}, d2={"cancelIfNecessary", "", "cancelOnTimeout", "", "handleTimeout", "", "testThread", "Ljava/lang/Thread;", "methodName", "", "testTimeoutMs", "", "cancellationException", "", "runWithTimeoutDumpingCoroutines", "T", "initCancellationException", "Lkotlin/Function0;", "invocation", "(Ljava/lang/String;JZLkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "attachStacktraceFrom", "thread", "kotlinx-coroutines-debug"})
public final class CoroutinesTimeoutImplKt {
    public static final <T> T runWithTimeoutDumpingCoroutines(@NotNull String methodName, long testTimeoutMs, boolean cancelOnTimeout, @NotNull Function0<? extends Throwable> initCancellationException, @NotNull Function0<? extends T> invocation) {
        Thread thread;
        boolean $i$f$runWithTimeoutDumpingCoroutines = false;
        CountDownLatch testStartedLatch = new CountDownLatch(1);
        FutureTask testResult2 = new FutureTask(new Callable(testStartedLatch, invocation){
            final /* synthetic */ CountDownLatch $testStartedLatch;
            final /* synthetic */ Function0<T> $invocation;
            {
                this.$testStartedLatch = $testStartedLatch;
                this.$invocation = $invocation;
            }

            public final T call() {
                this.$testStartedLatch.countDown();
                return (T)this.$invocation.invoke();
            }
        });
        Thread $this$runWithTimeoutDumpingCoroutines_u24lambda_u2d0 = thread = new Thread((Runnable)testResult2, "Timeout test thread");
        boolean bl = false;
        $this$runWithTimeoutDumpingCoroutines_u24lambda_u2d0.setDaemon(true);
        Thread testThread = thread;
        try {
            testThread.start();
            testStartedLatch.await();
            return (T)testResult2.get(testTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            CoroutinesTimeoutImplKt.handleTimeout(testThread, methodName, testTimeoutMs, cancelOnTimeout, (Throwable)initCancellationException.invoke());
            throw new KotlinNothingValueException();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
    }

    private static final Void handleTimeout(Thread testThread, String methodName, long testTimeoutMs, boolean cancelOnTimeout, Throwable cancellationException) {
        String units = testTimeoutMs % (long)1000 == 0L ? testTimeoutMs / (long)1000 + " seconds" : testTimeoutMs + " milliseconds";
        System.err.println("\nTest " + methodName + " timed out after " + units + '\n');
        System.err.flush();
        DebugProbes.dumpCoroutines$default(DebugProbes.INSTANCE, null, 1, null);
        System.out.flush();
        CoroutinesTimeoutImplKt.attachStacktraceFrom(cancellationException, testThread);
        testThread.interrupt();
        CoroutinesTimeoutImplKt.cancelIfNecessary(cancelOnTimeout);
        throw cancellationException;
    }

    private static final void cancelIfNecessary(boolean cancelOnTimeout) {
        if (cancelOnTimeout) {
            Iterable $this$forEach$iv = DebugProbes.INSTANCE.dumpCoroutinesInfo();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CoroutineInfo it = (CoroutineInfo)element$iv;
                boolean bl = false;
                Job job = it.getJob();
                if (job == null) continue;
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
        }
    }

    private static final void attachStacktraceFrom(Throwable $this$attachStacktraceFrom, Thread thread) {
        StackTraceElement[] stackTrace = thread.getStackTrace();
        $this$attachStacktraceFrom.setStackTrace(stackTrace);
    }
}

