#include <err.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include "liblif.h"

static void usage(void);

extern char *__progname;

char *volname, *filename;

int
main(int argc, char *argv[])
{
	struct lifvol lv;
	struct lifdir ld;
	int fd, dir, offset, i;

	if (argc < 2)
		usage();

	for (i=0; i<argc-1; i++) {

		lif_parse_filename(argv[1], &volname, &filename);

		if (volname == NULL)
			usage();

		if (lif_checkname(filename))
			errx(1, "invalid source filename");

		if ((fd = lif_openvol(argv[1], O_RDWR)) < 0)
			errx(1, "cannot open LIF volume %s", argv[1]);

		if (read(fd, &lv, sizeof(struct lifvol)) !=
		    sizeof(struct lifvol))
			errx(1, "cannot read volume header");

		if (be16toh(lv.lv_magic) != VOL_MAGIC)
			errx(1, "%s not a LIF volume", volname);

		if ((dir = lif_lookup(fd, filename, &ld)) < 0)
			errx(1, "%s not found", filename);

		memset(&ld, 0, sizeof(struct lifdir));
		
	        offset = be32toh(lv.lv_dirstart) * SECTOR_SIZE +
		    sizeof(struct lifvol)*dir;

		lseek(fd, offset, SEEK_SET);
		if (write(fd, &ld, sizeof(struct lifdir)) !=
		    sizeof(struct lifdir))
			errx(1, "cannot write to directory");

		close(fd);
	}

	return (0);
}

static void
usage(void)
{

	fprintf(stderr, "Usage: %s file ...\n", __progname);

	exit(EXIT_FAILURE);
}
