/*	$NetBSD$	*/

#define SECTOR_SIZE	256
#define VOL_MAGIC		0x8000
#define VOL_OCT		4096
#define	DIR_TYPE	0xe942
#define DIR_FLAG	0x8001

struct liftoc {
	u_int8_t toc_month;
	u_int8_t toc_day;
	u_int8_t toc_year;
	u_int8_t toc_hour;
	u_int8_t toc_minute;
	u_int8_t toc_second;
} __attribute__((__packed__));

struct	lifvol {
	u_int16_t	lv_magic;		/* 0-1 */
	u_int8_t	lv_label[6];	/* 2-7 */
	u_int32_t	lv_dirstart;	/* 8-11 */
	u_int16_t	lv_oct;		/* 12-13 */
	u_int16_t	lv_pad1;	/* 14-15 */
	u_int32_t	lv_dirsize;	/* 16-19 */
	u_int16_t	lv_version;	/* 20-21 */
	u_int16_t	lv_zero;	/* 22-23 */
	u_int32_t	lv_pad2;	/* 24-27 */
	u_int32_t	lv_pad3;	/* 28-31 */
	u_int32_t	lv_length;	/* 32-35 */
	struct liftoc	lv_toc;		/* 36-41 */
} __attribute__((__packed__));

struct	lifdir {
	u_int8_t	ld_name[10];	/* 0-9 */
	u_int16_t	ld_type;	/* 10-11 */
	u_int32_t	ld_addr;	/* 12-15 */
	u_int32_t	ld_length;	/* 16-19 */
	struct liftoc	ld_toc;		/* 20-25 */
	u_int16_t	ld_flag;	/* 26-27 */
	u_int32_t	ld_exec;	/* 28-31 */
} __attribute__((__packed__));

struct lifloadhdr {
	u_int32_t 	llh_addr;
	u_int32_t	llh_count;
} __attribute__((__packed__));

struct lifislhdr {
	u_int32_t	lih_addr;
	u_int32_t	lih_size;
	u_int32_t	lih_entry;
} __attribute__((__packed__));


void lif_block_read(int fd, int block, u_int8_t *buf);
void lif_gettime(struct liftoc *toc, struct tm *tval);
void lif_puttime(struct liftoc *toc, struct tm *tval);
void lif_makename(char *str, char *lname);
int lif_checkname(const char *str);
void lif_parse_filename(char *str, char **volname, char **filename);
int lif_lookup(int fd, const char *filename, struct lifdir *ld);
int lif_openvol(char *volname, int flags);
