.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbSelectEventDetails __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbSelectEventDetails \-  Selects or deselects for a specific Xkb event and 
optionally places conditions on when events of that type are reported to your 
client 
.SH SYNOPSIS
.HP
.B Bool XkbSelectEventDetails
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "device_spec" "\^,"
.BI "unsigned int " "event_type" "\^,"
.BI "unsigned long int " "bits_to_change" "\^,"
.BI "unsigned long int " "values_for_bits" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
connection to the X server 
.TP
.I device_spec
device ID, or XkbUseCoreKbd
.TP
.I event_type
Xkb event type of interest
.TP
.I bits_to_change
determines events to be selected / deselected
.TP
.I values_for_bits
1=>select, 0->deselect; for events in bits_to_change
.SH DESCRIPTION
.LP
Xkb events are selected using an event mask, much the same as normal core X 
events are selected. However, unlike selecting core X events, where you must 
specify the selection status (on or off) for all possible event types whenever 
you wish to change the selection criteria for any one event, Xkb allows you to 
restrict the specification to only the event types you wish to change. This 
means that you do not need to remember the event selection values for all 
possible types each time you want to change one of them.

Many Xkb event types are generated under several different circumstances. When 
selecting to receive an Xkb event, you may specify either that you want it 
delivered under all circumstances, or that you want it delivered only for a 
subset of the possible circumstances.
 
You can also deselect an event type that was previously selected for, using the 
same granularity.

Xkb provides two functions to select and deselect delivery of Xkb events. 
.I XkbSelectEvents 
allows you to select or deselect delivery of more than one Xkb event type at 
once. Events selected using 
.I XkbSelectEvents 
are delivered to your program under all circumstances that generate the events. 
To restrict delivery of an event to a subset of the conditions under which it 
occurs, use 
.I XkbSelectEventDetails. XkbSelectEventDetails 
only allows you to change the selection conditions for a single event at a time, 
but it provides a means of fine-tuning the conditions under which the event is 
delivered.

To select or deselect for a specific Xkb event and optionally place conditions 
on when events of that type are reported to your client, use 
.I XkbSelectEventDetails. 
This allows you to exercise a finer granularity of 
control over delivery of Xkb events with 
.I XkbSelectEvents.

While 
.I XkbSelectEvents 
allows multiple events to be selected, 
.I XkbSelectEventDetails 
changes the selection criteria for a single type of Xkb 
event. The interpretation of the 
.I bits_to_change 
and 
.I values_for_bits 
masks depends on the event type in question.
 
.I XkbSelectEventDetails 
changes the Xkb event selection mask for the keyboard 
specified by 
.I device_spec 
and the Xkb event specified by 
.I event_type. 
To turn on event selection for an event detail, set the bit for the 
detail in the 
.I bits_to_change 
parameter and set the corresponding bit in the 
.I values_for_bits 
parameter. To turn off event detail selection for a detail, set 
the bit for the detail in the 
.I bits_to_change 
parameter and do not set the corresponding bit in the 
.I values_for_bits 
parameter.

If an invalid event type is specified, a BadValue protocol error results. If a 
bit is not set in the 
.I bits_to_change 
parameter, but the corresponding bit is set in the
.I values_for_bits 
parameter, a BadMatch protocol error results. If an undefined 
bit is set in either the 
.I bits_to_change 
or the 
.I values_for_bits 
parameter, a BadValue protocol error results.

For each type of Xkb event, the legal event details that you can specify in the 
.I XkbSelectEventDetails 
request are listed in the chapters that describe each event in detail.
.SH DIAGNOSTICS
.TP 15
.SM BadMatch
A compatible version of Xkb was not available in the server or an argument has 
correct type and range, but is otherwise invalid
.TP 15
.SM BadValue
An argument is out of range
.SH "SEE ALSO"
.BR XkbSelectEvents (__libmansuffix__),
.BR XkbUseCoreKbd (__libmansuffix__)
