/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.math.BigInteger;
import java.util.List;

/**
 * Type represeting a virtual machines pool.
 */
public interface VmPool extends Identified {
    boolean autoStorageSelect();
    
    boolean autoStorageSelectPresent();
    
    Display display();
    
    boolean displayPresent();
    
    BigInteger maxUserVms();
    Byte maxUserVmsAsByte();
    Short maxUserVmsAsShort();
    Integer maxUserVmsAsInteger();
    Long maxUserVmsAsLong();
    
    boolean maxUserVmsPresent();
    
    BigInteger prestartedVms();
    Byte prestartedVmsAsByte();
    Short prestartedVmsAsShort();
    Integer prestartedVmsAsInteger();
    Long prestartedVmsAsLong();
    
    boolean prestartedVmsPresent();
    
    RngDevice rngDevice();
    
    boolean rngDevicePresent();
    
    BigInteger size();
    Byte sizeAsByte();
    Short sizeAsShort();
    Integer sizeAsInteger();
    Long sizeAsLong();
    
    boolean sizePresent();
    
    boolean soundcardEnabled();
    
    boolean soundcardEnabledPresent();
    
    boolean stateful();
    
    boolean statefulPresent();
    
    boolean tpmEnabled();
    
    boolean tpmEnabledPresent();
    
    VmPoolType type();
    
    boolean typePresent();
    
    boolean useLatestTemplateVersion();
    
    boolean useLatestTemplateVersionPresent();
    
    Cluster cluster();
    
    boolean clusterPresent();
    
    InstanceType instanceType();
    
    boolean instanceTypePresent();
    
    List<Permission> permissions();
    
    boolean permissionsPresent();
    
    Template template();
    
    boolean templatePresent();
    
    Vm vm();
    
    boolean vmPresent();
    
}
