/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.AffinityLabelBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedAffinityLabelServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlAffinityLabelReader;
import org.ovirt.engine.sdk4.internal.xml.XmlAffinityLabelWriter;
import org.ovirt.engine.sdk4.services.AssignedAffinityLabelService;
import org.ovirt.engine.sdk4.services.AssignedAffinityLabelsService;
import org.ovirt.engine.sdk4.types.AffinityLabel;

public class AssignedAffinityLabelsServiceImpl
extends ServiceImpl
implements AssignedAffinityLabelsService {
    public AssignedAffinityLabelsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AssignedAffinityLabelsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public AssignedAffinityLabelsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public AssignedAffinityLabelService labelService(String id) {
        return new AssignedAffinityLabelServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.labelService(path);
        }
        return this.labelService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "AssignedAffinityLabelsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements AssignedAffinityLabelsService.ListResponse {
        private List<AffinityLabel> label;

        private ListResponseImpl() {
        }

        public void label(List<AffinityLabel> label) {
            this.label = label;
        }

        @Override
        public List<AffinityLabel> label() {
            return this.label;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<AssignedAffinityLabelsService.ListRequest, AssignedAffinityLabelsService.ListResponse>
    implements AssignedAffinityLabelsService.ListRequest {
        private String follow;

        private ListRequestImpl() {
        }

        @Override
        public AssignedAffinityLabelsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AssignedAffinityLabelsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AssignedAffinityLabelsServiceImpl.this.getConnection().getUrl() + AssignedAffinityLabelsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AssignedAffinityLabelsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.label(XmlAffinityLabelReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AssignedAffinityLabelsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements AssignedAffinityLabelsService.AddResponse {
        private AffinityLabel label;

        private AddResponseImpl() {
        }

        public void label(AffinityLabel label) {
            this.label = label;
        }

        @Override
        public AffinityLabel label() {
            return this.label;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<AssignedAffinityLabelsService.AddRequest, AssignedAffinityLabelsService.AddResponse>
    implements AssignedAffinityLabelsService.AddRequest {
        private AffinityLabel label;

        private AddRequestImpl() {
        }

        @Override
        public AssignedAffinityLabelsService.AddRequest label(AffinityLabel label) {
            this.label = label;
            return this;
        }

        @Override
        public AssignedAffinityLabelsService.AddRequest label(AffinityLabelBuilder label) {
            this.label = label.build();
            return this;
        }

        @Override
        public AssignedAffinityLabelsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AssignedAffinityLabelsServiceImpl.this.getConnection().getUrl() + AssignedAffinityLabelsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlAffinityLabelWriter.writeOne(this.label, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AssignedAffinityLabelsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.label(XmlAffinityLabelReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AssignedAffinityLabelsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

