/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.TicketContainer;
import org.ovirt.engine.sdk4.types.Ticket;

public class TicketBuilder {
    private BigInteger expiry;
    private String value;
    
    public TicketBuilder expiry(int newExpiry) {
        expiry = BigInteger.valueOf((long) newExpiry);
        return this;
    }
    
    public TicketBuilder expiry(Integer newExpiry) {
        if (newExpiry == null) {
            expiry = null;
        }
        else {
            expiry = BigInteger.valueOf(newExpiry.longValue());
        }
        return this;
    }
    
    public TicketBuilder expiry(long newExpiry) {
        expiry = BigInteger.valueOf(newExpiry);
        return this;
    }
    
    public TicketBuilder expiry(Long newExpiry) {
        if (newExpiry == null) {
            expiry = null;
        }
        else {
            expiry = BigInteger.valueOf(newExpiry.longValue());
        }
        return this;
    }
    
    public TicketBuilder expiry(BigInteger newExpiry) {
        expiry = newExpiry;
        return this;
    }
    
    
    public TicketBuilder value(String newValue) {
        value = newValue;
        return this;
    }
    
    
    public Ticket build() {
        TicketContainer container = new TicketContainer();
        container.expiry(expiry);
        container.value(value);
        return container;
    }
}
