/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.CpuTypeContainer;
import org.ovirt.engine.sdk4.types.Architecture;
import org.ovirt.engine.sdk4.types.CpuType;

public class CpuTypeBuilder {
    private Architecture architecture;
    private BigInteger level;
    private String name;
    
    public CpuTypeBuilder architecture(Architecture newArchitecture) {
        architecture = newArchitecture;
        return this;
    }
    
    
    public CpuTypeBuilder level(int newLevel) {
        level = BigInteger.valueOf((long) newLevel);
        return this;
    }
    
    public CpuTypeBuilder level(Integer newLevel) {
        if (newLevel == null) {
            level = null;
        }
        else {
            level = BigInteger.valueOf(newLevel.longValue());
        }
        return this;
    }
    
    public CpuTypeBuilder level(long newLevel) {
        level = BigInteger.valueOf(newLevel);
        return this;
    }
    
    public CpuTypeBuilder level(Long newLevel) {
        if (newLevel == null) {
            level = null;
        }
        else {
            level = BigInteger.valueOf(newLevel.longValue());
        }
        return this;
    }
    
    public CpuTypeBuilder level(BigInteger newLevel) {
        level = newLevel;
        return this;
    }
    
    
    public CpuTypeBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public CpuType build() {
        CpuTypeContainer container = new CpuTypeContainer();
        container.architecture(architecture);
        container.level(level);
        container.name(name);
        return container;
    }
}
