/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.RegistrationConfigurationBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.builders.VnicProfileMappingBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StorageDomainContentDisksServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StorageDomainVmDiskAttachmentsServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.services.StorageDomainContentDisksService;
import org.ovirt.engine.sdk4.services.StorageDomainVmDiskAttachmentsService;
import org.ovirt.engine.sdk4.services.StorageDomainVmService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.RegistrationConfiguration;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Vm;
import org.ovirt.engine.sdk4.types.VnicProfileMapping;

public class StorageDomainVmServiceImpl
extends ServiceImpl
implements StorageDomainVmService {
    public StorageDomainVmServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public StorageDomainVmService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public StorageDomainVmService.ImportRequest import_() {
        return new ImportRequestImpl();
    }

    @Override
    public StorageDomainVmService.RegisterRequest register() {
        return new RegisterRequestImpl();
    }

    @Override
    public StorageDomainVmService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public StorageDomainVmDiskAttachmentsService diskAttachmentsService() {
        return new StorageDomainVmDiskAttachmentsServiceImpl(this.getConnection(), this.getPath() + "/diskattachments");
    }

    @Override
    public StorageDomainContentDisksService disksService() {
        return new StorageDomainContentDisksServiceImpl(this.getConnection(), this.getPath() + "/disks");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("diskattachments")) {
            return this.diskAttachmentsService();
        }
        if (path.startsWith("diskattachments/")) {
            return this.diskAttachmentsService().service(path.substring(16));
        }
        if (path.equals("disks")) {
            return this.disksService();
        }
        if (path.startsWith("disks/")) {
            return this.disksService().service(path.substring(6));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "StorageDomainVmService:" + this.getPath();
    }

    private class RemoveResponseImpl
    implements StorageDomainVmService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<StorageDomainVmService.RemoveRequest, StorageDomainVmService.RemoveResponse>
    implements StorageDomainVmService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public StorageDomainVmService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageDomainVmService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainVmServiceImpl.this.getConnection().getUrl() + StorageDomainVmServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainVmServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            StorageDomainVmServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class RegisterResponseImpl
    implements StorageDomainVmService.RegisterResponse {
        private RegisterResponseImpl() {
        }
    }

    private class RegisterRequestImpl
    extends BaseRequest<StorageDomainVmService.RegisterRequest, StorageDomainVmService.RegisterResponse>
    implements StorageDomainVmService.RegisterRequest {
        private Boolean allowPartialImport;
        private Boolean async;
        private Boolean clone_;
        private Cluster cluster;
        private Boolean reassignBadMacs;
        private RegistrationConfiguration registrationConfiguration;
        private Vm vm;
        private List<VnicProfileMapping> vnicProfileMappings;

        private RegisterRequestImpl() {
        }

        @Override
        public StorageDomainVmService.RegisterRequest allowPartialImport(Boolean allowPartialImport) {
            this.allowPartialImport = allowPartialImport;
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest clone_(Boolean clone_) {
            this.clone_ = clone_;
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest cluster(Cluster cluster) {
            this.cluster = cluster;
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest cluster(ClusterBuilder cluster) {
            this.cluster = cluster.build();
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest reassignBadMacs(Boolean reassignBadMacs) {
            this.reassignBadMacs = reassignBadMacs;
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest registrationConfiguration(RegistrationConfiguration registrationConfiguration) {
            this.registrationConfiguration = registrationConfiguration;
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest registrationConfiguration(RegistrationConfigurationBuilder registrationConfiguration) {
            this.registrationConfiguration = registrationConfiguration.build();
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest vm(Vm vm) {
            this.vm = vm;
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest vm(VmBuilder vm) {
            this.vm = vm.build();
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest vnicProfileMappings(List<VnicProfileMapping> vnicProfileMappings) {
            this.vnicProfileMappings = vnicProfileMappings;
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest vnicProfileMappings(VnicProfileMapping ... vnicProfileMappings) {
            this.vnicProfileMappings = Arrays.asList(vnicProfileMappings);
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterRequest vnicProfileMappings(VnicProfileMappingBuilder ... vnicProfileMappings) {
            this.vnicProfileMappings = new ArrayList<VnicProfileMapping>(vnicProfileMappings.length);
            for (VnicProfileMappingBuilder element : vnicProfileMappings) {
                this.vnicProfileMappings.add(element.build());
            }
            return this;
        }

        @Override
        public StorageDomainVmService.RegisterResponse send() {
            HttpPost request = new HttpPost(StorageDomainVmServiceImpl.this.getConnection().getUrl() + StorageDomainVmServiceImpl.this.getPath() + "/register");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.allowPartialImport(this.allowPartialImport);
                action.async(this.async);
                action.clone_(this.clone_);
                action.cluster(this.cluster);
                action.reassignBadMacs(this.reassignBadMacs);
                action.registrationConfiguration(this.registrationConfiguration);
                action.vm(this.vm);
                action.vnicProfileMappings(this.vnicProfileMappings);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = StorageDomainVmServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = StorageDomainVmServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new RegisterResponseImpl();
        }
    }

    private class ImportResponseImpl
    implements StorageDomainVmService.ImportResponse {
        private ImportResponseImpl() {
        }
    }

    private class ImportRequestImpl
    extends BaseRequest<StorageDomainVmService.ImportRequest, StorageDomainVmService.ImportResponse>
    implements StorageDomainVmService.ImportRequest {
        private Boolean async;
        private Boolean clone_;
        private Cluster cluster;
        private Boolean collapseSnapshots;
        private Boolean exclusive;
        private StorageDomain storageDomain;
        private Vm vm;

        private ImportRequestImpl() {
        }

        @Override
        public StorageDomainVmService.ImportRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageDomainVmService.ImportRequest clone_(Boolean clone_) {
            this.clone_ = clone_;
            return this;
        }

        @Override
        public StorageDomainVmService.ImportRequest cluster(Cluster cluster) {
            this.cluster = cluster;
            return this;
        }

        @Override
        public StorageDomainVmService.ImportRequest cluster(ClusterBuilder cluster) {
            this.cluster = cluster.build();
            return this;
        }

        @Override
        public StorageDomainVmService.ImportRequest collapseSnapshots(Boolean collapseSnapshots) {
            this.collapseSnapshots = collapseSnapshots;
            return this;
        }

        @Override
        public StorageDomainVmService.ImportRequest exclusive(Boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        @Override
        public StorageDomainVmService.ImportRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public StorageDomainVmService.ImportRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public StorageDomainVmService.ImportRequest vm(Vm vm) {
            this.vm = vm;
            return this;
        }

        @Override
        public StorageDomainVmService.ImportRequest vm(VmBuilder vm) {
            this.vm = vm.build();
            return this;
        }

        @Override
        public StorageDomainVmService.ImportResponse send() {
            HttpPost request = new HttpPost(StorageDomainVmServiceImpl.this.getConnection().getUrl() + StorageDomainVmServiceImpl.this.getPath() + "/import");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.clone_(this.clone_);
                action.cluster(this.cluster);
                action.collapseSnapshots(this.collapseSnapshots);
                action.exclusive(this.exclusive);
                action.storageDomain(this.storageDomain);
                action.vm(this.vm);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = StorageDomainVmServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = StorageDomainVmServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ImportResponseImpl();
        }
    }

    private class GetResponseImpl
    implements StorageDomainVmService.GetResponse {
        private Vm vm;

        private GetResponseImpl() {
        }

        public void vm(Vm vm) {
            this.vm = vm;
        }

        @Override
        public Vm vm() {
            return this.vm;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<StorageDomainVmService.GetRequest, StorageDomainVmService.GetResponse>
    implements StorageDomainVmService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public StorageDomainVmService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public StorageDomainVmService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainVmServiceImpl.this.getConnection().getUrl() + StorageDomainVmServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainVmServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.vm(XmlVmReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageDomainVmServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

