/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ExternalHostServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalHostReader;
import org.ovirt.engine.sdk4.services.ExternalHostService;
import org.ovirt.engine.sdk4.services.ExternalHostsService;
import org.ovirt.engine.sdk4.types.ExternalHost;

public class ExternalHostsServiceImpl
extends ServiceImpl
implements ExternalHostsService {
    public ExternalHostsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ExternalHostsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public ExternalHostService hostService(String id) {
        return new ExternalHostServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.hostService(path);
        }
        return this.hostService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "ExternalHostsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements ExternalHostsService.ListResponse {
        private List<ExternalHost> hosts;

        private ListResponseImpl() {
        }

        public void hosts(List<ExternalHost> hosts) {
            this.hosts = hosts;
        }

        @Override
        public List<ExternalHost> hosts() {
            return this.hosts;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<ExternalHostsService.ListRequest, ExternalHostsService.ListResponse>
    implements ExternalHostsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public ExternalHostsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ExternalHostsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public ExternalHostsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public ExternalHostsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public ExternalHostsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalHostsServiceImpl.this.getConnection().getUrl() + ExternalHostsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalHostsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.hosts(XmlExternalHostReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ExternalHostsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

