/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StorageFormat {
    V1("v1"),
    V2("v2"),
    V3("v3"),
    V4("v4"),
    V5("v5");

    private static final Logger log;
    private String image;

    private StorageFormat(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static StorageFormat fromValue(String value) {
        try {
            return StorageFormat.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'StorageFormat' enumerated type. Valid values are 'v1', 'v2', 'v3', 'v4' and 'v5'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(StorageFormat.class);
    }
}

