/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DiskContentType {
    DATA("data"),
    HOSTED_ENGINE("hosted_engine"),
    HOSTED_ENGINE_CONFIGURATION("hosted_engine_configuration"),
    HOSTED_ENGINE_METADATA("hosted_engine_metadata"),
    HOSTED_ENGINE_SANLOCK("hosted_engine_sanlock"),
    ISO("iso"),
    MEMORY_DUMP_VOLUME("memory_dump_volume"),
    MEMORY_METADATA_VOLUME("memory_metadata_volume"),
    OVF_STORE("ovf_store");

    private static final Logger log;
    private String image;

    private DiskContentType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static DiskContentType fromValue(String value) {
        try {
            return DiskContentType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'DiskContentType' enumerated type. Valid values are 'data', 'hosted_engine', 'hosted_engine_configuration', 'hosted_engine_metadata', 'hosted_engine_sanlock', 'iso', 'memory_dump_volume', 'memory_metadata_volume' and 'ovf_store'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(DiskContentType.class);
    }
}

