/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.HostServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostWriter;
import org.ovirt.engine.sdk4.services.HostService;
import org.ovirt.engine.sdk4.services.HostsService;
import org.ovirt.engine.sdk4.types.Host;

public class HostsServiceImpl
extends ServiceImpl
implements HostsService {
    public HostsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public HostsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public HostsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public HostsService.AddUsingRootPasswordRequest addUsingRootPassword() {
        return new AddUsingRootPasswordRequestImpl();
    }

    @Override
    public HostsService.AddUsingSshRequest addUsingSsh() {
        return new AddUsingSshRequestImpl();
    }

    @Override
    public HostService hostService(String id) {
        return new HostServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.hostService(path);
        }
        return this.hostService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "HostsService:" + this.getPath();
    }

    private class AddUsingSshResponseImpl
    implements HostsService.AddUsingSshResponse {
        private Host host;

        private AddUsingSshResponseImpl() {
        }

        public void host(Host host) {
            this.host = host;
        }

        @Override
        public Host host() {
            return this.host;
        }
    }

    private class AddUsingSshRequestImpl
    extends BaseRequest<HostsService.AddUsingSshRequest, HostsService.AddUsingSshResponse>
    implements HostsService.AddUsingSshRequest {
        private Boolean activate;
        private Boolean deployHostedEngine;
        private Host host;
        private Boolean undeployHostedEngine;

        private AddUsingSshRequestImpl() {
        }

        @Override
        public HostsService.AddUsingSshRequest activate(Boolean activate) {
            this.activate = activate;
            return this;
        }

        @Override
        public HostsService.AddUsingSshRequest deployHostedEngine(Boolean deployHostedEngine) {
            this.deployHostedEngine = deployHostedEngine;
            return this;
        }

        @Override
        public HostsService.AddUsingSshRequest host(Host host) {
            this.host = host;
            return this;
        }

        @Override
        public HostsService.AddUsingSshRequest host(HostBuilder host) {
            this.host = host.build();
            return this;
        }

        @Override
        public HostsService.AddUsingSshRequest undeployHostedEngine(Boolean undeployHostedEngine) {
            this.undeployHostedEngine = undeployHostedEngine;
            return this;
        }

        @Override
        public HostsService.AddUsingSshResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(HostsServiceImpl.this.getConnection().getUrl() + HostsServiceImpl.this.getPath());
                if (this.activate != null) {
                    uriBuilder.addParameter("activate", XmlWriter.renderBoolean(this.activate));
                }
                if (this.deployHostedEngine != null) {
                    uriBuilder.addParameter("deploy_hosted_engine", XmlWriter.renderBoolean(this.deployHostedEngine));
                }
                if (this.undeployHostedEngine != null) {
                    uriBuilder.addParameter("undeploy_hosted_engine", XmlWriter.renderBoolean(this.undeployHostedEngine));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlHostWriter.writeOne(this.host, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = HostsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddUsingSshResponseImpl actionResponse = new AddUsingSshResponseImpl();
                        actionResponse.host(XmlHostReader.readOne(reader));
                        AddUsingSshResponseImpl addUsingSshResponseImpl = actionResponse;
                        reader.close();
                        return addUsingSshResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            HostsServiceImpl.this.checkFault(response);
            return new AddUsingSshResponseImpl();
        }
    }

    private class AddUsingRootPasswordResponseImpl
    implements HostsService.AddUsingRootPasswordResponse {
        private Host host;

        private AddUsingRootPasswordResponseImpl() {
        }

        public void host(Host host) {
            this.host = host;
        }

        @Override
        public Host host() {
            return this.host;
        }
    }

    private class AddUsingRootPasswordRequestImpl
    extends BaseRequest<HostsService.AddUsingRootPasswordRequest, HostsService.AddUsingRootPasswordResponse>
    implements HostsService.AddUsingRootPasswordRequest {
        private Boolean activate;
        private Boolean deployHostedEngine;
        private Host host;
        private Boolean undeployHostedEngine;

        private AddUsingRootPasswordRequestImpl() {
        }

        @Override
        public HostsService.AddUsingRootPasswordRequest activate(Boolean activate) {
            this.activate = activate;
            return this;
        }

        @Override
        public HostsService.AddUsingRootPasswordRequest deployHostedEngine(Boolean deployHostedEngine) {
            this.deployHostedEngine = deployHostedEngine;
            return this;
        }

        @Override
        public HostsService.AddUsingRootPasswordRequest host(Host host) {
            this.host = host;
            return this;
        }

        @Override
        public HostsService.AddUsingRootPasswordRequest host(HostBuilder host) {
            this.host = host.build();
            return this;
        }

        @Override
        public HostsService.AddUsingRootPasswordRequest undeployHostedEngine(Boolean undeployHostedEngine) {
            this.undeployHostedEngine = undeployHostedEngine;
            return this;
        }

        @Override
        public HostsService.AddUsingRootPasswordResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(HostsServiceImpl.this.getConnection().getUrl() + HostsServiceImpl.this.getPath());
                if (this.activate != null) {
                    uriBuilder.addParameter("activate", XmlWriter.renderBoolean(this.activate));
                }
                if (this.deployHostedEngine != null) {
                    uriBuilder.addParameter("deploy_hosted_engine", XmlWriter.renderBoolean(this.deployHostedEngine));
                }
                if (this.undeployHostedEngine != null) {
                    uriBuilder.addParameter("undeploy_hosted_engine", XmlWriter.renderBoolean(this.undeployHostedEngine));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlHostWriter.writeOne(this.host, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = HostsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddUsingRootPasswordResponseImpl actionResponse = new AddUsingRootPasswordResponseImpl();
                        actionResponse.host(XmlHostReader.readOne(reader));
                        AddUsingRootPasswordResponseImpl addUsingRootPasswordResponseImpl = actionResponse;
                        reader.close();
                        return addUsingRootPasswordResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            HostsServiceImpl.this.checkFault(response);
            return new AddUsingRootPasswordResponseImpl();
        }
    }

    private class ListResponseImpl
    implements HostsService.ListResponse {
        private List<Host> hosts;

        private ListResponseImpl() {
        }

        public void hosts(List<Host> hosts) {
            this.hosts = hosts;
        }

        @Override
        public List<Host> hosts() {
            return this.hosts;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<HostsService.ListRequest, HostsService.ListResponse>
    implements HostsService.ListRequest {
        private Boolean allContent;
        private Boolean caseSensitive;
        private Boolean checkVmsInAffinityClosure;
        private Boolean filter;
        private String follow;
        private BigInteger max;
        private String migrationTargetOf;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public HostsService.ListRequest allContent(Boolean allContent) {
            this.allContent = allContent;
            return this;
        }

        @Override
        public HostsService.ListRequest caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public HostsService.ListRequest checkVmsInAffinityClosure(Boolean checkVmsInAffinityClosure) {
            this.checkVmsInAffinityClosure = checkVmsInAffinityClosure;
            return this;
        }

        @Override
        public HostsService.ListRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public HostsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public HostsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public HostsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public HostsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public HostsService.ListRequest migrationTargetOf(String migrationTargetOf) {
            this.migrationTargetOf = migrationTargetOf;
            return this;
        }

        @Override
        public HostsService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public HostsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(HostsServiceImpl.this.getConnection().getUrl() + HostsServiceImpl.this.getPath());
                if (this.allContent != null) {
                    uriBuilder.addParameter("all_content", XmlWriter.renderBoolean(this.allContent));
                }
                if (this.caseSensitive != null) {
                    uriBuilder.addParameter("case_sensitive", XmlWriter.renderBoolean(this.caseSensitive));
                }
                if (this.checkVmsInAffinityClosure != null) {
                    uriBuilder.addParameter("check_vms_in_affinity_closure", XmlWriter.renderBoolean(this.checkVmsInAffinityClosure));
                }
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.migrationTargetOf != null) {
                    uriBuilder.addParameter("migration_target_of", XmlWriter.renderString(this.migrationTargetOf));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = HostsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.hosts(XmlHostReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            HostsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements HostsService.AddResponse {
        private Host host;

        private AddResponseImpl() {
        }

        public void host(Host host) {
            this.host = host;
        }

        @Override
        public Host host() {
            return this.host;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<HostsService.AddRequest, HostsService.AddResponse>
    implements HostsService.AddRequest {
        private Boolean activate;
        private Boolean deployHostedEngine;
        private Host host;
        private Boolean undeployHostedEngine;

        private AddRequestImpl() {
        }

        @Override
        public HostsService.AddRequest activate(Boolean activate) {
            this.activate = activate;
            return this;
        }

        @Override
        public HostsService.AddRequest deployHostedEngine(Boolean deployHostedEngine) {
            this.deployHostedEngine = deployHostedEngine;
            return this;
        }

        @Override
        public HostsService.AddRequest host(Host host) {
            this.host = host;
            return this;
        }

        @Override
        public HostsService.AddRequest host(HostBuilder host) {
            this.host = host.build();
            return this;
        }

        @Override
        public HostsService.AddRequest undeployHostedEngine(Boolean undeployHostedEngine) {
            this.undeployHostedEngine = undeployHostedEngine;
            return this;
        }

        @Override
        public HostsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(HostsServiceImpl.this.getConnection().getUrl() + HostsServiceImpl.this.getPath());
                if (this.activate != null) {
                    uriBuilder.addParameter("activate", XmlWriter.renderBoolean(this.activate));
                }
                if (this.deployHostedEngine != null) {
                    uriBuilder.addParameter("deploy_hosted_engine", XmlWriter.renderBoolean(this.deployHostedEngine));
                }
                if (this.undeployHostedEngine != null) {
                    uriBuilder.addParameter("undeploy_hosted_engine", XmlWriter.renderBoolean(this.undeployHostedEngine));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlHostWriter.writeOne(this.host, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = HostsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.host(XmlHostReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            HostsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

