/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.PayloadContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlFileReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmDeviceTypeReader;
import org.ovirt.engine.sdk4.types.Payload;

public class XmlPayloadReader {
    public static Payload readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        PayloadContainer object = new PayloadContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block12: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "files": {
                    object.files(XmlFileReader.readMany(reader));
                    continue block12;
                }
                case "type": {
                    object.type(XmlVmDeviceTypeReader.readOne(reader));
                    continue block12;
                }
                case "volume_id": {
                    object.volumeId(reader.readString());
                    continue block12;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block12;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlPayloadReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Payload> iterateMany(final XmlReader reader) {
        return new Iterator<Payload>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Payload next() {
                Payload next = XmlPayloadReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Payload> readMany(XmlReader reader) {
        ArrayList<Payload> list = new ArrayList<Payload>();
        Iterator<Payload> iterator = XmlPayloadReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(PayloadContainer object, String[] link) {
    }
}

