/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.xml;

import java.util.Iterator;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.types.Cpu;

public class XmlCpuWriter {
    
    public static void writeOne(Cpu object, XmlWriter writer) {
        writeOne(object, "cpu", writer);
    }
    
    public static void writeOne(Cpu object, String tag, XmlWriter writer) {
        writer.writeStartElement(tag);
        if (object.architecturePresent()) {
            XmlArchitectureWriter.writeOne(object.architecture(), "architecture", writer);
        }
        if (object.coresPresent()) {
            XmlCoreWriter.writeMany(object.cores().iterator(), "core", "cores", writer);
        }
        if (object.cpuTunePresent()) {
            XmlCpuTuneWriter.writeOne(object.cpuTune(), "cpu_tune", writer);
        }
        if (object.levelPresent()) {
            writer.writeInteger("level", object.level());
        }
        if (object.modePresent()) {
            XmlCpuModeWriter.writeOne(object.mode(), "mode", writer);
        }
        if (object.namePresent()) {
            writer.writeElement("name", object.name());
        }
        if (object.speedPresent()) {
            writer.writeDecimal("speed", object.speed());
        }
        if (object.topologyPresent()) {
            XmlCpuTopologyWriter.writeOne(object.topology(), "topology", writer);
        }
        if (object.typePresent()) {
            writer.writeElement("type", object.type());
        }
        writer.writeEndElement();
    }
    
    public static void writeMany(Iterator<Cpu> list, XmlWriter writer) {
        writeMany(list, "cpu", "cpus", writer);
    }
    
    public static void writeMany(Iterator<Cpu> list, String singular, String plural, XmlWriter writer) {
        writer.writeStartElement(plural);
        while (list.hasNext()) {
            XmlCpuWriter.writeOne(list.next(), singular, writer);
        }
        writer.writeEndElement();
    }
    
}

