/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DiskFormat {
    COW("cow"),
    RAW("raw");

    private static final Logger log;
    private String image;

    private DiskFormat(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static DiskFormat fromValue(String value) {
        try {
            return DiskFormat.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'DiskFormat' enumerated type. Valid values are 'cow' and 'raw'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(DiskFormat.class);
    }
}

