/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Architecture {
    PPC64("ppc64"),
    UNDEFINED("undefined"),
    X86_64("x86_64");

    private static final Logger log;
    private String image;

    private Architecture(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static Architecture fromValue(String value) {
        try {
            return Architecture.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'Architecture' enumerated type. Valid values are 'ppc64', 'undefined' and 'x86_64'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(Architecture.class);
    }
}

