/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.Qos;
import org.ovirt.engine.sdk4.types.QosType;

public class QosContainer extends IdentifiedContainer implements Qos {
    private BigInteger cpuLimit;
    private BigInteger inboundAverage;
    private BigInteger inboundBurst;
    private BigInteger inboundPeak;
    private BigInteger maxIops;
    private BigInteger maxReadIops;
    private BigInteger maxReadThroughput;
    private BigInteger maxThroughput;
    private BigInteger maxWriteIops;
    private BigInteger maxWriteThroughput;
    private BigInteger outboundAverage;
    private BigInteger outboundAverageLinkshare;
    private BigInteger outboundAverageRealtime;
    private BigInteger outboundAverageUpperlimit;
    private BigInteger outboundBurst;
    private BigInteger outboundPeak;
    private QosType type;
    private DataCenter dataCenter;
    
    public BigInteger cpuLimit() {
        return cpuLimit;
    }
    
    public void cpuLimit(BigInteger newCpuLimit) {
        cpuLimit = newCpuLimit;
    }
    
    public boolean cpuLimitPresent() {
        return cpuLimit != null;
    }
    
    public BigInteger inboundAverage() {
        return inboundAverage;
    }
    
    public void inboundAverage(BigInteger newInboundAverage) {
        inboundAverage = newInboundAverage;
    }
    
    public boolean inboundAveragePresent() {
        return inboundAverage != null;
    }
    
    public BigInteger inboundBurst() {
        return inboundBurst;
    }
    
    public void inboundBurst(BigInteger newInboundBurst) {
        inboundBurst = newInboundBurst;
    }
    
    public boolean inboundBurstPresent() {
        return inboundBurst != null;
    }
    
    public BigInteger inboundPeak() {
        return inboundPeak;
    }
    
    public void inboundPeak(BigInteger newInboundPeak) {
        inboundPeak = newInboundPeak;
    }
    
    public boolean inboundPeakPresent() {
        return inboundPeak != null;
    }
    
    public BigInteger maxIops() {
        return maxIops;
    }
    
    public void maxIops(BigInteger newMaxIops) {
        maxIops = newMaxIops;
    }
    
    public boolean maxIopsPresent() {
        return maxIops != null;
    }
    
    public BigInteger maxReadIops() {
        return maxReadIops;
    }
    
    public void maxReadIops(BigInteger newMaxReadIops) {
        maxReadIops = newMaxReadIops;
    }
    
    public boolean maxReadIopsPresent() {
        return maxReadIops != null;
    }
    
    public BigInteger maxReadThroughput() {
        return maxReadThroughput;
    }
    
    public void maxReadThroughput(BigInteger newMaxReadThroughput) {
        maxReadThroughput = newMaxReadThroughput;
    }
    
    public boolean maxReadThroughputPresent() {
        return maxReadThroughput != null;
    }
    
    public BigInteger maxThroughput() {
        return maxThroughput;
    }
    
    public void maxThroughput(BigInteger newMaxThroughput) {
        maxThroughput = newMaxThroughput;
    }
    
    public boolean maxThroughputPresent() {
        return maxThroughput != null;
    }
    
    public BigInteger maxWriteIops() {
        return maxWriteIops;
    }
    
    public void maxWriteIops(BigInteger newMaxWriteIops) {
        maxWriteIops = newMaxWriteIops;
    }
    
    public boolean maxWriteIopsPresent() {
        return maxWriteIops != null;
    }
    
    public BigInteger maxWriteThroughput() {
        return maxWriteThroughput;
    }
    
    public void maxWriteThroughput(BigInteger newMaxWriteThroughput) {
        maxWriteThroughput = newMaxWriteThroughput;
    }
    
    public boolean maxWriteThroughputPresent() {
        return maxWriteThroughput != null;
    }
    
    public BigInteger outboundAverage() {
        return outboundAverage;
    }
    
    public void outboundAverage(BigInteger newOutboundAverage) {
        outboundAverage = newOutboundAverage;
    }
    
    public boolean outboundAveragePresent() {
        return outboundAverage != null;
    }
    
    public BigInteger outboundAverageLinkshare() {
        return outboundAverageLinkshare;
    }
    
    public void outboundAverageLinkshare(BigInteger newOutboundAverageLinkshare) {
        outboundAverageLinkshare = newOutboundAverageLinkshare;
    }
    
    public boolean outboundAverageLinksharePresent() {
        return outboundAverageLinkshare != null;
    }
    
    public BigInteger outboundAverageRealtime() {
        return outboundAverageRealtime;
    }
    
    public void outboundAverageRealtime(BigInteger newOutboundAverageRealtime) {
        outboundAverageRealtime = newOutboundAverageRealtime;
    }
    
    public boolean outboundAverageRealtimePresent() {
        return outboundAverageRealtime != null;
    }
    
    public BigInteger outboundAverageUpperlimit() {
        return outboundAverageUpperlimit;
    }
    
    public void outboundAverageUpperlimit(BigInteger newOutboundAverageUpperlimit) {
        outboundAverageUpperlimit = newOutboundAverageUpperlimit;
    }
    
    public boolean outboundAverageUpperlimitPresent() {
        return outboundAverageUpperlimit != null;
    }
    
    public BigInteger outboundBurst() {
        return outboundBurst;
    }
    
    public void outboundBurst(BigInteger newOutboundBurst) {
        outboundBurst = newOutboundBurst;
    }
    
    public boolean outboundBurstPresent() {
        return outboundBurst != null;
    }
    
    public BigInteger outboundPeak() {
        return outboundPeak;
    }
    
    public void outboundPeak(BigInteger newOutboundPeak) {
        outboundPeak = newOutboundPeak;
    }
    
    public boolean outboundPeakPresent() {
        return outboundPeak != null;
    }
    
    public QosType type() {
        return type;
    }
    
    public void type(QosType newType) {
        type = newType;
    }
    
    public boolean typePresent() {
        return type != null;
    }
    
    public DataCenter dataCenter() {
        return dataCenter;
    }
    
    public void dataCenter(DataCenter newDataCenter) {
        dataCenter = newDataCenter;
    }
    
    public boolean dataCenterPresent() {
        return dataCenter != null;
    }
    
}
