/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StatisticUnit {
    BITS_PER_SECOND,
    BYTES,
    BYTES_PER_SECOND,
    COUNT_PER_SECOND,
    NONE,
    PERCENT,
    SECONDS;

    private static final Logger LOG;

    public String value() {
        return this.name().toLowerCase();
    }

    public static StatisticUnit fromValue(String value) {
        try {
            return StatisticUnit.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'StatisticUnit' enumerated type. Valid values are: 'bits_per_second', 'bytes', 'bytes_per_second', 'count_per_second', 'none', 'percent', 'seconds'.");
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(StatisticUnit.class);
    }
}

