/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.lang.String;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.Fault;
import org.ovirt.engine.sdk4.types.GlusterBrick;
import org.ovirt.engine.sdk4.types.GlusterVolumeProfileDetails;
import org.ovirt.engine.sdk4.types.GracePeriod;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.HostNic;
import org.ovirt.engine.sdk4.types.HostNicVirtualFunctionsConfiguration;
import org.ovirt.engine.sdk4.types.IscsiDetails;
import org.ovirt.engine.sdk4.types.Job;
import org.ovirt.engine.sdk4.types.LogicalUnit;
import org.ovirt.engine.sdk4.types.NetworkAttachment;
import org.ovirt.engine.sdk4.types.NetworkLabel;
import org.ovirt.engine.sdk4.types.Option;
import org.ovirt.engine.sdk4.types.PowerManagement;
import org.ovirt.engine.sdk4.types.ProxyTicket;
import org.ovirt.engine.sdk4.types.Snapshot;
import org.ovirt.engine.sdk4.types.Ssh;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Ticket;
import org.ovirt.engine.sdk4.types.Vm;
import org.ovirt.engine.sdk4.types.VnicProfileMapping;

public class ActionContainer extends IdentifiedContainer implements Action {
    private Boolean allowPartialImport;
    private Boolean async;
    private List<GlusterBrick> bricks;
    private List<Certificate> certificates;
    private Boolean checkConnectivity;
    private Boolean clone_;
    private Cluster cluster;
    private Boolean collapseSnapshots;
    private BigInteger connectivityTimeout;
    private DataCenter dataCenter;
    private Boolean deployHostedEngine;
    private GlusterVolumeProfileDetails details;
    private Boolean discardSnapshots;
    private Disk disk;
    private List<Disk> disks;
    private Boolean exclusive;
    private Fault fault;
    private String fenceType;
    private Boolean filter;
    private Boolean fixLayout;
    private Boolean force;
    private GracePeriod gracePeriod;
    private Host host;
    private String image;
    private Boolean importAsTemplate;
    private Boolean isAttached;
    private IscsiDetails iscsi;
    private List<String> iscsiTargets;
    private Job job;
    private List<LogicalUnit> logicalUnits;
    private Boolean maintenanceEnabled;
    private List<HostNic> modifiedBonds;
    private List<NetworkLabel> modifiedLabels;
    private List<NetworkAttachment> modifiedNetworkAttachments;
    private Option option;
    private Boolean pause;
    private PowerManagement powerManagement;
    private ProxyTicket proxyTicket;
    private String reason;
    private Boolean reassignBadMacs;
    private String remoteViewerConnectionFile;
    private List<HostNic> removedBonds;
    private List<NetworkLabel> removedLabels;
    private List<NetworkAttachment> removedNetworkAttachments;
    private String resolutionType;
    private Boolean restoreMemory;
    private String rootPassword;
    private Snapshot snapshot;
    private Ssh ssh;
    private String status;
    private Boolean stopGlusterService;
    private StorageDomain storageDomain;
    private List<StorageDomain> storageDomains;
    private Boolean succeeded;
    private List<NetworkAttachment> synchronizedNetworkAttachments;
    private Template template;
    private Ticket ticket;
    private Boolean undeployHostedEngine;
    private Boolean useCloudInit;
    private Boolean useSysprep;
    private HostNicVirtualFunctionsConfiguration virtualFunctionsConfiguration;
    private Vm vm;
    private List<VnicProfileMapping> vnicProfileMappings;
    
    public boolean allowPartialImport() {
        return allowPartialImport;
    }
    
    public void allowPartialImport(boolean newAllowPartialImport) {
        allowPartialImport = Boolean.valueOf(newAllowPartialImport);
    }
    
    public void allowPartialImport(Boolean newAllowPartialImport) {
        allowPartialImport = newAllowPartialImport;
    }
    
    public boolean allowPartialImportPresent() {
        return allowPartialImport != null;
    }
    
    public boolean async() {
        return async;
    }
    
    public void async(boolean newAsync) {
        async = Boolean.valueOf(newAsync);
    }
    
    public void async(Boolean newAsync) {
        async = newAsync;
    }
    
    public boolean asyncPresent() {
        return async != null;
    }
    
    public List<GlusterBrick> bricks() {
        return makeUnmodifiableList(bricks);
    }
    
    public void bricks(List<GlusterBrick> newBricks) {
        bricks = makeArrayList(newBricks);
    }
    
    public boolean bricksPresent() {
        return bricks != null && !bricks.isEmpty();
    }
    
    public List<Certificate> certificates() {
        return makeUnmodifiableList(certificates);
    }
    
    public void certificates(List<Certificate> newCertificates) {
        certificates = makeArrayList(newCertificates);
    }
    
    public boolean certificatesPresent() {
        return certificates != null && !certificates.isEmpty();
    }
    
    public boolean checkConnectivity() {
        return checkConnectivity;
    }
    
    public void checkConnectivity(boolean newCheckConnectivity) {
        checkConnectivity = Boolean.valueOf(newCheckConnectivity);
    }
    
    public void checkConnectivity(Boolean newCheckConnectivity) {
        checkConnectivity = newCheckConnectivity;
    }
    
    public boolean checkConnectivityPresent() {
        return checkConnectivity != null;
    }
    
    public boolean clone_() {
        return clone_;
    }
    
    public void clone_(boolean newClone) {
        clone_ = Boolean.valueOf(newClone);
    }
    
    public void clone_(Boolean newClone) {
        clone_ = newClone;
    }
    
    public boolean clone_Present() {
        return clone_ != null;
    }
    
    public Cluster cluster() {
        return cluster;
    }
    
    public void cluster(Cluster newCluster) {
        cluster = newCluster;
    }
    
    public boolean clusterPresent() {
        return cluster != null;
    }
    
    public boolean collapseSnapshots() {
        return collapseSnapshots;
    }
    
    public void collapseSnapshots(boolean newCollapseSnapshots) {
        collapseSnapshots = Boolean.valueOf(newCollapseSnapshots);
    }
    
    public void collapseSnapshots(Boolean newCollapseSnapshots) {
        collapseSnapshots = newCollapseSnapshots;
    }
    
    public boolean collapseSnapshotsPresent() {
        return collapseSnapshots != null;
    }
    
    public BigInteger connectivityTimeout() {
        return connectivityTimeout;
    }
    
    public void connectivityTimeout(BigInteger newConnectivityTimeout) {
        connectivityTimeout = newConnectivityTimeout;
    }
    
    public boolean connectivityTimeoutPresent() {
        return connectivityTimeout != null;
    }
    
    public DataCenter dataCenter() {
        return dataCenter;
    }
    
    public void dataCenter(DataCenter newDataCenter) {
        dataCenter = newDataCenter;
    }
    
    public boolean dataCenterPresent() {
        return dataCenter != null;
    }
    
    public boolean deployHostedEngine() {
        return deployHostedEngine;
    }
    
    public void deployHostedEngine(boolean newDeployHostedEngine) {
        deployHostedEngine = Boolean.valueOf(newDeployHostedEngine);
    }
    
    public void deployHostedEngine(Boolean newDeployHostedEngine) {
        deployHostedEngine = newDeployHostedEngine;
    }
    
    public boolean deployHostedEnginePresent() {
        return deployHostedEngine != null;
    }
    
    public GlusterVolumeProfileDetails details() {
        return details;
    }
    
    public void details(GlusterVolumeProfileDetails newDetails) {
        details = newDetails;
    }
    
    public boolean detailsPresent() {
        return details != null;
    }
    
    public boolean discardSnapshots() {
        return discardSnapshots;
    }
    
    public void discardSnapshots(boolean newDiscardSnapshots) {
        discardSnapshots = Boolean.valueOf(newDiscardSnapshots);
    }
    
    public void discardSnapshots(Boolean newDiscardSnapshots) {
        discardSnapshots = newDiscardSnapshots;
    }
    
    public boolean discardSnapshotsPresent() {
        return discardSnapshots != null;
    }
    
    public Disk disk() {
        return disk;
    }
    
    public void disk(Disk newDisk) {
        disk = newDisk;
    }
    
    public boolean diskPresent() {
        return disk != null;
    }
    
    public List<Disk> disks() {
        return makeUnmodifiableList(disks);
    }
    
    public void disks(List<Disk> newDisks) {
        disks = makeArrayList(newDisks);
    }
    
    public boolean disksPresent() {
        return disks != null && !disks.isEmpty();
    }
    
    public boolean exclusive() {
        return exclusive;
    }
    
    public void exclusive(boolean newExclusive) {
        exclusive = Boolean.valueOf(newExclusive);
    }
    
    public void exclusive(Boolean newExclusive) {
        exclusive = newExclusive;
    }
    
    public boolean exclusivePresent() {
        return exclusive != null;
    }
    
    public Fault fault() {
        return fault;
    }
    
    public void fault(Fault newFault) {
        fault = newFault;
    }
    
    public boolean faultPresent() {
        return fault != null;
    }
    
    public String fenceType() {
        return fenceType;
    }
    
    public void fenceType(String newFenceType) {
        fenceType = newFenceType;
    }
    
    public boolean fenceTypePresent() {
        return fenceType != null;
    }
    
    public boolean filter() {
        return filter;
    }
    
    public void filter(boolean newFilter) {
        filter = Boolean.valueOf(newFilter);
    }
    
    public void filter(Boolean newFilter) {
        filter = newFilter;
    }
    
    public boolean filterPresent() {
        return filter != null;
    }
    
    public boolean fixLayout() {
        return fixLayout;
    }
    
    public void fixLayout(boolean newFixLayout) {
        fixLayout = Boolean.valueOf(newFixLayout);
    }
    
    public void fixLayout(Boolean newFixLayout) {
        fixLayout = newFixLayout;
    }
    
    public boolean fixLayoutPresent() {
        return fixLayout != null;
    }
    
    public boolean force() {
        return force;
    }
    
    public void force(boolean newForce) {
        force = Boolean.valueOf(newForce);
    }
    
    public void force(Boolean newForce) {
        force = newForce;
    }
    
    public boolean forcePresent() {
        return force != null;
    }
    
    public GracePeriod gracePeriod() {
        return gracePeriod;
    }
    
    public void gracePeriod(GracePeriod newGracePeriod) {
        gracePeriod = newGracePeriod;
    }
    
    public boolean gracePeriodPresent() {
        return gracePeriod != null;
    }
    
    public Host host() {
        return host;
    }
    
    public void host(Host newHost) {
        host = newHost;
    }
    
    public boolean hostPresent() {
        return host != null;
    }
    
    public String image() {
        return image;
    }
    
    public void image(String newImage) {
        image = newImage;
    }
    
    public boolean imagePresent() {
        return image != null;
    }
    
    public boolean importAsTemplate() {
        return importAsTemplate;
    }
    
    public void importAsTemplate(boolean newImportAsTemplate) {
        importAsTemplate = Boolean.valueOf(newImportAsTemplate);
    }
    
    public void importAsTemplate(Boolean newImportAsTemplate) {
        importAsTemplate = newImportAsTemplate;
    }
    
    public boolean importAsTemplatePresent() {
        return importAsTemplate != null;
    }
    
    public boolean isAttached() {
        return isAttached;
    }
    
    public void isAttached(boolean newIsAttached) {
        isAttached = Boolean.valueOf(newIsAttached);
    }
    
    public void isAttached(Boolean newIsAttached) {
        isAttached = newIsAttached;
    }
    
    public boolean isAttachedPresent() {
        return isAttached != null;
    }
    
    public IscsiDetails iscsi() {
        return iscsi;
    }
    
    public void iscsi(IscsiDetails newIscsi) {
        iscsi = newIscsi;
    }
    
    public boolean iscsiPresent() {
        return iscsi != null;
    }
    
    public List<String> iscsiTargets() {
        return makeUnmodifiableList(iscsiTargets);
    }
    
    public void iscsiTargets(List<String> newIscsiTargets) {
        iscsiTargets = makeArrayList(newIscsiTargets);
    }
    
    public boolean iscsiTargetsPresent() {
        return iscsiTargets != null && !iscsiTargets.isEmpty();
    }
    
    public Job job() {
        return job;
    }
    
    public void job(Job newJob) {
        job = newJob;
    }
    
    public boolean jobPresent() {
        return job != null;
    }
    
    public List<LogicalUnit> logicalUnits() {
        return makeUnmodifiableList(logicalUnits);
    }
    
    public void logicalUnits(List<LogicalUnit> newLogicalUnits) {
        logicalUnits = makeArrayList(newLogicalUnits);
    }
    
    public boolean logicalUnitsPresent() {
        return logicalUnits != null && !logicalUnits.isEmpty();
    }
    
    public boolean maintenanceEnabled() {
        return maintenanceEnabled;
    }
    
    public void maintenanceEnabled(boolean newMaintenanceEnabled) {
        maintenanceEnabled = Boolean.valueOf(newMaintenanceEnabled);
    }
    
    public void maintenanceEnabled(Boolean newMaintenanceEnabled) {
        maintenanceEnabled = newMaintenanceEnabled;
    }
    
    public boolean maintenanceEnabledPresent() {
        return maintenanceEnabled != null;
    }
    
    public List<HostNic> modifiedBonds() {
        return makeUnmodifiableList(modifiedBonds);
    }
    
    public void modifiedBonds(List<HostNic> newModifiedBonds) {
        modifiedBonds = makeArrayList(newModifiedBonds);
    }
    
    public boolean modifiedBondsPresent() {
        return modifiedBonds != null && !modifiedBonds.isEmpty();
    }
    
    public List<NetworkLabel> modifiedLabels() {
        return makeUnmodifiableList(modifiedLabels);
    }
    
    public void modifiedLabels(List<NetworkLabel> newModifiedLabels) {
        modifiedLabels = makeArrayList(newModifiedLabels);
    }
    
    public boolean modifiedLabelsPresent() {
        return modifiedLabels != null && !modifiedLabels.isEmpty();
    }
    
    public List<NetworkAttachment> modifiedNetworkAttachments() {
        return makeUnmodifiableList(modifiedNetworkAttachments);
    }
    
    public void modifiedNetworkAttachments(List<NetworkAttachment> newModifiedNetworkAttachments) {
        modifiedNetworkAttachments = makeArrayList(newModifiedNetworkAttachments);
    }
    
    public boolean modifiedNetworkAttachmentsPresent() {
        return modifiedNetworkAttachments != null && !modifiedNetworkAttachments.isEmpty();
    }
    
    public Option option() {
        return option;
    }
    
    public void option(Option newOption) {
        option = newOption;
    }
    
    public boolean optionPresent() {
        return option != null;
    }
    
    public boolean pause() {
        return pause;
    }
    
    public void pause(boolean newPause) {
        pause = Boolean.valueOf(newPause);
    }
    
    public void pause(Boolean newPause) {
        pause = newPause;
    }
    
    public boolean pausePresent() {
        return pause != null;
    }
    
    public PowerManagement powerManagement() {
        return powerManagement;
    }
    
    public void powerManagement(PowerManagement newPowerManagement) {
        powerManagement = newPowerManagement;
    }
    
    public boolean powerManagementPresent() {
        return powerManagement != null;
    }
    
    public ProxyTicket proxyTicket() {
        return proxyTicket;
    }
    
    public void proxyTicket(ProxyTicket newProxyTicket) {
        proxyTicket = newProxyTicket;
    }
    
    public boolean proxyTicketPresent() {
        return proxyTicket != null;
    }
    
    public String reason() {
        return reason;
    }
    
    public void reason(String newReason) {
        reason = newReason;
    }
    
    public boolean reasonPresent() {
        return reason != null;
    }
    
    public boolean reassignBadMacs() {
        return reassignBadMacs;
    }
    
    public void reassignBadMacs(boolean newReassignBadMacs) {
        reassignBadMacs = Boolean.valueOf(newReassignBadMacs);
    }
    
    public void reassignBadMacs(Boolean newReassignBadMacs) {
        reassignBadMacs = newReassignBadMacs;
    }
    
    public boolean reassignBadMacsPresent() {
        return reassignBadMacs != null;
    }
    
    public String remoteViewerConnectionFile() {
        return remoteViewerConnectionFile;
    }
    
    public void remoteViewerConnectionFile(String newRemoteViewerConnectionFile) {
        remoteViewerConnectionFile = newRemoteViewerConnectionFile;
    }
    
    public boolean remoteViewerConnectionFilePresent() {
        return remoteViewerConnectionFile != null;
    }
    
    public List<HostNic> removedBonds() {
        return makeUnmodifiableList(removedBonds);
    }
    
    public void removedBonds(List<HostNic> newRemovedBonds) {
        removedBonds = makeArrayList(newRemovedBonds);
    }
    
    public boolean removedBondsPresent() {
        return removedBonds != null && !removedBonds.isEmpty();
    }
    
    public List<NetworkLabel> removedLabels() {
        return makeUnmodifiableList(removedLabels);
    }
    
    public void removedLabels(List<NetworkLabel> newRemovedLabels) {
        removedLabels = makeArrayList(newRemovedLabels);
    }
    
    public boolean removedLabelsPresent() {
        return removedLabels != null && !removedLabels.isEmpty();
    }
    
    public List<NetworkAttachment> removedNetworkAttachments() {
        return makeUnmodifiableList(removedNetworkAttachments);
    }
    
    public void removedNetworkAttachments(List<NetworkAttachment> newRemovedNetworkAttachments) {
        removedNetworkAttachments = makeArrayList(newRemovedNetworkAttachments);
    }
    
    public boolean removedNetworkAttachmentsPresent() {
        return removedNetworkAttachments != null && !removedNetworkAttachments.isEmpty();
    }
    
    public String resolutionType() {
        return resolutionType;
    }
    
    public void resolutionType(String newResolutionType) {
        resolutionType = newResolutionType;
    }
    
    public boolean resolutionTypePresent() {
        return resolutionType != null;
    }
    
    public boolean restoreMemory() {
        return restoreMemory;
    }
    
    public void restoreMemory(boolean newRestoreMemory) {
        restoreMemory = Boolean.valueOf(newRestoreMemory);
    }
    
    public void restoreMemory(Boolean newRestoreMemory) {
        restoreMemory = newRestoreMemory;
    }
    
    public boolean restoreMemoryPresent() {
        return restoreMemory != null;
    }
    
    public String rootPassword() {
        return rootPassword;
    }
    
    public void rootPassword(String newRootPassword) {
        rootPassword = newRootPassword;
    }
    
    public boolean rootPasswordPresent() {
        return rootPassword != null;
    }
    
    public Snapshot snapshot() {
        return snapshot;
    }
    
    public void snapshot(Snapshot newSnapshot) {
        snapshot = newSnapshot;
    }
    
    public boolean snapshotPresent() {
        return snapshot != null;
    }
    
    public Ssh ssh() {
        return ssh;
    }
    
    public void ssh(Ssh newSsh) {
        ssh = newSsh;
    }
    
    public boolean sshPresent() {
        return ssh != null;
    }
    
    public String status() {
        return status;
    }
    
    public void status(String newStatus) {
        status = newStatus;
    }
    
    public boolean statusPresent() {
        return status != null;
    }
    
    public boolean stopGlusterService() {
        return stopGlusterService;
    }
    
    public void stopGlusterService(boolean newStopGlusterService) {
        stopGlusterService = Boolean.valueOf(newStopGlusterService);
    }
    
    public void stopGlusterService(Boolean newStopGlusterService) {
        stopGlusterService = newStopGlusterService;
    }
    
    public boolean stopGlusterServicePresent() {
        return stopGlusterService != null;
    }
    
    public StorageDomain storageDomain() {
        return storageDomain;
    }
    
    public void storageDomain(StorageDomain newStorageDomain) {
        storageDomain = newStorageDomain;
    }
    
    public boolean storageDomainPresent() {
        return storageDomain != null;
    }
    
    public List<StorageDomain> storageDomains() {
        return makeUnmodifiableList(storageDomains);
    }
    
    public void storageDomains(List<StorageDomain> newStorageDomains) {
        storageDomains = makeArrayList(newStorageDomains);
    }
    
    public boolean storageDomainsPresent() {
        return storageDomains != null && !storageDomains.isEmpty();
    }
    
    public boolean succeeded() {
        return succeeded;
    }
    
    public void succeeded(boolean newSucceeded) {
        succeeded = Boolean.valueOf(newSucceeded);
    }
    
    public void succeeded(Boolean newSucceeded) {
        succeeded = newSucceeded;
    }
    
    public boolean succeededPresent() {
        return succeeded != null;
    }
    
    public List<NetworkAttachment> synchronizedNetworkAttachments() {
        return makeUnmodifiableList(synchronizedNetworkAttachments);
    }
    
    public void synchronizedNetworkAttachments(List<NetworkAttachment> newSynchronizedNetworkAttachments) {
        synchronizedNetworkAttachments = makeArrayList(newSynchronizedNetworkAttachments);
    }
    
    public boolean synchronizedNetworkAttachmentsPresent() {
        return synchronizedNetworkAttachments != null && !synchronizedNetworkAttachments.isEmpty();
    }
    
    public Template template() {
        return template;
    }
    
    public void template(Template newTemplate) {
        template = newTemplate;
    }
    
    public boolean templatePresent() {
        return template != null;
    }
    
    public Ticket ticket() {
        return ticket;
    }
    
    public void ticket(Ticket newTicket) {
        ticket = newTicket;
    }
    
    public boolean ticketPresent() {
        return ticket != null;
    }
    
    public boolean undeployHostedEngine() {
        return undeployHostedEngine;
    }
    
    public void undeployHostedEngine(boolean newUndeployHostedEngine) {
        undeployHostedEngine = Boolean.valueOf(newUndeployHostedEngine);
    }
    
    public void undeployHostedEngine(Boolean newUndeployHostedEngine) {
        undeployHostedEngine = newUndeployHostedEngine;
    }
    
    public boolean undeployHostedEnginePresent() {
        return undeployHostedEngine != null;
    }
    
    public boolean useCloudInit() {
        return useCloudInit;
    }
    
    public void useCloudInit(boolean newUseCloudInit) {
        useCloudInit = Boolean.valueOf(newUseCloudInit);
    }
    
    public void useCloudInit(Boolean newUseCloudInit) {
        useCloudInit = newUseCloudInit;
    }
    
    public boolean useCloudInitPresent() {
        return useCloudInit != null;
    }
    
    public boolean useSysprep() {
        return useSysprep;
    }
    
    public void useSysprep(boolean newUseSysprep) {
        useSysprep = Boolean.valueOf(newUseSysprep);
    }
    
    public void useSysprep(Boolean newUseSysprep) {
        useSysprep = newUseSysprep;
    }
    
    public boolean useSysprepPresent() {
        return useSysprep != null;
    }
    
    public HostNicVirtualFunctionsConfiguration virtualFunctionsConfiguration() {
        return virtualFunctionsConfiguration;
    }
    
    public void virtualFunctionsConfiguration(HostNicVirtualFunctionsConfiguration newVirtualFunctionsConfiguration) {
        virtualFunctionsConfiguration = newVirtualFunctionsConfiguration;
    }
    
    public boolean virtualFunctionsConfigurationPresent() {
        return virtualFunctionsConfiguration != null;
    }
    
    public Vm vm() {
        return vm;
    }
    
    public void vm(Vm newVm) {
        vm = newVm;
    }
    
    public boolean vmPresent() {
        return vm != null;
    }
    
    public List<VnicProfileMapping> vnicProfileMappings() {
        return makeUnmodifiableList(vnicProfileMappings);
    }
    
    public void vnicProfileMappings(List<VnicProfileMapping> newVnicProfileMappings) {
        vnicProfileMappings = makeArrayList(newVnicProfileMappings);
    }
    
    public boolean vnicProfileMappingsPresent() {
        return vnicProfileMappings != null && !vnicProfileMappings.isEmpty();
    }
    
}
