/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.ApiContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlApiSummaryReader;
import org.ovirt.engine.sdk4.internal.xml.XmlProductInfoReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSpecialObjectsReader;
import org.ovirt.engine.sdk4.types.Api;

public class XmlApiReader {
    public static Api readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        ApiContainer object = new ApiContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block14: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "product_info": {
                    object.productInfo(XmlProductInfoReader.readOne(reader));
                    continue block14;
                }
                case "special_objects": {
                    object.specialObjects(XmlSpecialObjectsReader.readOne(reader));
                    continue block14;
                }
                case "summary": {
                    object.summary(XmlApiSummaryReader.readOne(reader));
                    continue block14;
                }
                case "time": {
                    object.time(reader.readDate());
                    continue block14;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block14;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlApiReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Api> iterateMany(final XmlReader reader) {
        return new Iterator<Api>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Api next() {
                Api next = XmlApiReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Api> readMany(XmlReader reader) {
        ArrayList<Api> list = new ArrayList<Api>();
        Iterator<Api> iterator = XmlApiReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(ApiContainer object, String[] link) {
    }
}

