/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.ProductInfoContainer;
import org.ovirt.engine.sdk4.types.ProductInfo;
import org.ovirt.engine.sdk4.types.Version;

public class ProductInfoBuilder {
    private String name;
    private String vendor;
    private Version version;
    
    public ProductInfoBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public ProductInfoBuilder vendor(String newVendor) {
        vendor = newVendor;
        return this;
    }
    
    
    public ProductInfoBuilder version(Version newVersion) {
        version = newVersion;
        return this;
    }
    
    public ProductInfoBuilder version(VersionBuilder newVersion) {
        if (newVersion == null) {
            version = null;
        }
        else {
            version = newVersion.build();
        }
        return this;
    }
    
    
    public ProductInfo build() {
        ProductInfoContainer container = new ProductInfoContainer();
        container.name(name);
        container.vendor(vendor);
        container.version(version);
        return container;
    }
}
