/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Architecture {
    UNDEFINED,
    X86_64,
    PPC64;

    private static final Logger LOG;

    public String value() {
        return this.name().toLowerCase();
    }

    public static Architecture fromValue(String value) {
        try {
            return Architecture.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'Architecture' enumerated type. Valid values are: 'undefined', 'x86_64', 'ppc64'.");
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(Architecture.class);
    }
}

