package org.jboss.cache.loader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;

import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;

/**
 * Provides ignoreModifications features to all cache loaders.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.1.0
 */
public class ReadOnlyDelegatingCacheLoader extends AbstractDelegatingCacheLoader
{
   private static final Log log = LogFactory.getLog(ReadOnlyDelegatingCacheLoader.class);

   public ReadOnlyDelegatingCacheLoader(CacheLoader cl)
   {
      super(cl);
   }

   @Override
   public Object put(Fqn name, Object key, Object value) throws Exception
   {
      log.trace("Not delegating write operation to underlying cache loader");
      Map map = get(name);
      return (map == null) ? null : map.get(key);
   }

   @Override
   public void put(Fqn name, Map attributes) throws Exception
   {
      log.trace("Not delegating write operation to underlying cache loader");
   }

   @Override
   public void put(List<Modification> modifications) throws Exception
   {
      log.trace("Not delegating write operation to underlying cache loader");
   }

   @Override
   public Object remove(Fqn fqn, Object key) throws Exception
   {
      log.trace("Not delegating write operation to underlying cache loader");
      Map map = get(fqn);
      return (map == null) ? null : map.get(key);
   }

   @Override
   public void remove(Fqn fqn) throws Exception
   {
      log.trace("Not delegating write operation to underlying cache loader");
   }

   @Override
   public void removeData(Fqn fqn) throws Exception
   {
      log.trace("Not delegating write operation to underlying cache loader");
   }

   @Override
   public void prepare(Object tx, List<Modification> modifications, boolean one_phase) throws Exception
   {
      log.trace("Not delegating write operation to underlying cache loader");
   }

   @Override
   public void commit(Object tx) throws Exception
   {
      log.trace("Not delegating write operation to underlying cache loader");
   }

   @Override
   public void rollback(Object tx)
   {
      log.trace("Not delegating write operation to underlying cache loader");
   }

   @Override
   public void storeEntireState(ObjectInputStream is) throws Exception
   {
      log.trace("Not delegating write operation to underlying cache loader");
   }

   @Override
   public void storeState(Fqn subtree, ObjectInputStream is) throws Exception
   {
      log.trace("Not delegating write operation to underlying cache loader");
   }
}
