# Copyright (C) 2006-2007 Red Hat, Inc.
# Copyright (C) 2010 Collabora Ltd. <http://www.collabora.co.uk/>
# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import hashlib
import logging

import gconf
import gobject

from sugar.graphics.xocolor import XoColor
from sugar.profile import get_profile


_owner_instance = None
_logger = logging.getLogger('plugins.telepathy.buddy')


class BuddyModel(gobject.GObject):

    def __init__(self, **kwargs):
        self._contact_id = None
        self._account = None
        self._handle = None
        self._nick = None
        self._color = None
        self._tags = None
        self._current_activity = None
        self.activities = set()
        self.pubkey = None
        self.online = False

        gobject.GObject.__init__(self, **kwargs)

    def is_owner(self):
        return False

    def get_account(self):
        return self._account

    def set_account(self, account):
        self._account = account

    account = gobject.property(type=object, getter=get_account,
                               setter=set_account)

    def get_contact_id(self):
        return self._contact_id

    def set_contact_id(self, contact_id):
        self._contact_id = contact_id

    contact_id = gobject.property(type=object, getter=get_contact_id,
                                  setter=set_contact_id)

    def get_handle(self):
        return self._handle

    def set_handle(self, handle):
        self._handle = handle

    handle = gobject.property(type=object, getter=get_handle,
                              setter=set_handle)

    def get_nick(self):
        return self._nick or self.contact_id

    def set_nick(self, nick):
        self._nick = nick

    nick = gobject.property(type=object, getter=get_nick, setter=set_nick)

    def get_key(self):
        # TODO The rest of Shell code needs to be patched to use `handle`
        return self.contact_id

    key = gobject.property(type=object, getter=get_key)

    def get_color(self):
        return self._color

    def set_color(self, color):
        self._color = color

    color = gobject.property(type=object, getter=get_color, setter=set_color)

    def get_tags(self):
        return self._tags

    tags = gobject.property(type=object, getter=get_tags)

    def get_current_activity(self):
        return self._current_activity

    def set_current_activity(self, current_activity):
        if self._current_activity != current_activity:
            self._current_activity = current_activity
            self.notify('current-activity')

    current_activity = gobject.property(type=object,
                                        getter=get_current_activity,
                                        setter=set_current_activity)


class OwnerBuddyModel(BuddyModel):

    def __init__(self):
        BuddyModel.__init__(self)

        client = gconf.client_get_default()
        self.nick = client.get_string('/desktop/sugar/user/nick')
        color = client.get_string('/desktop/sugar/user/color')
        self.color = XoColor(color)
        self.pubkey = get_profile().pubkey

        public_key_hash = hashlib.sha1(get_profile().pubkey).hexdigest()
        server = client.get_string('/desktop/sugar/collaboration'
                                   '/jabber_server')
        self.contact_id = '%s@%s' % (public_key_hash, server)

    def is_owner(self):
        return True


def get_owner_instance():
    global _owner_instance
    if _owner_instance is None:
        _owner_instance = OwnerBuddyModel()
    return _owner_instance
