# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gconf


ORDER = 100


def init():
    pass


def start():
    pass


def binding():
    client = gconf.client_get_default()
    result = []

    if not client.get_bool('/system/http_proxy/use_http_proxy'):
        return result

    host = client.get_string('/system/http_proxy/host')
    port = client.get_int('/system/http_proxy/port')
    if client.get_bool('/system/http_proxy/use_authentication'):
        user = client.get_string('/system/http_proxy/authentication_user')
        pswd = client.get_string('/system/http_proxy/authentication_password')
        proxy = 'http://%s:%s@%s:%s' % (user, pswd, host, port)
    else:
        proxy = 'http://%s:%s' % (host, port)
    result.append('export http_proxy="%s"' % proxy)

    no_proxy = client.get_list('/system/http_proxy/ignore_hosts',
            gconf.VALUE_STRING)
    # In most cases, proxying localhost is useless.
    # On the other hand, proxying localhost breaks Sugar Network integration
    for required_host in ('localhost', '127.0.0.1', '::1'):
        if required_host not in no_proxy:
            no_proxy.append(required_host)
    result.append('export no_proxy="%s"' % ','.join(no_proxy))

    return result


if __name__ == '__main__':
    print binding()
