/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.diff;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jmeld.JMeldException;
import org.jmeld.diff.EclipseDiff;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMDiffAlgorithmIF;
import org.jmeld.diff.JMRevision;
import org.jmeld.diff.MaxTimeExceededException;
import org.jmeld.diff.MyersDiff;
import org.jmeld.ui.text.AbstractBufferDocument;
import org.jmeld.util.Ignore;
import org.jmeld.util.StopWatch;
import org.jmeld.util.file.CompareUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMDiff {
    private static final CharBuffer inputLine = CharBuffer.allocate(10000);
    private static final CharBuffer outputLine = CharBuffer.allocate(10000);
    private List<JMDiffAlgorithmIF> algorithms;

    public JMDiff() {
        MyersDiff myersDiff = new MyersDiff();
        myersDiff.checkMaxTime(true);
        this.algorithms = new ArrayList<JMDiffAlgorithmIF>();
        this.algorithms.add(new EclipseDiff());
    }

    public JMRevision diff(List<String> a, List<String> b, Ignore ignore) throws JMeldException {
        if (a == null) {
            a = Collections.emptyList();
        }
        if (b == null) {
            b = Collections.emptyList();
        }
        return this.diff(a.toArray(), b.toArray(), ignore);
    }

    public JMRevision diff(Object[] a, Object[] b, Ignore ignore) throws JMeldException {
        Object[] org = a;
        Object[] rev = b;
        if (org == null) {
            org = new Object[]{};
        }
        if (rev == null) {
            rev = new Object[]{};
        }
        boolean filtered = org instanceof AbstractBufferDocument.Line[] && rev instanceof AbstractBufferDocument.Line[];
        StopWatch sp = new StopWatch();
        sp.start();
        if (filtered) {
            org = this.filter(ignore, org);
            rev = this.filter(ignore, rev);
        }
        long filteredTime = sp.getElapsedTime();
        for (JMDiffAlgorithmIF algorithm : this.algorithms) {
            try {
                JMRevision revision = algorithm.diff(org, rev);
                revision.setIgnore(ignore);
                revision.update(a, b);
                if (filtered) {
                    this.adjustRevision(revision, a, (JMString[])org, b, (JMString[])rev);
                }
                if (a.length > 1000) {
                    System.out.println("diff took " + sp.getElapsedTime() + " msec. [filter=" + filteredTime + " msec][" + algorithm.getClass() + "]");
                }
                return revision;
            }
            catch (JMeldException ex) {
                if (ex.getCause() instanceof MaxTimeExceededException) {
                    System.out.println("Time exceeded for " + algorithm.getClass() + ": try next algorithm");
                    continue;
                }
                throw ex;
            }
        }
        return null;
    }

    private void adjustRevision(JMRevision revision, Object[] orgArray, JMString[] orgArrayFiltered, Object[] revArray, JMString[] revArrayFiltered) {
        for (JMDelta delta : revision.getDeltas()) {
            JMChunk chunk = delta.getOriginal();
            int index = chunk.getAnchor();
            int anchor = index < orgArrayFiltered.length ? orgArrayFiltered[index].lineNumber : orgArray.length;
            int size = chunk.getSize();
            if (size > 0 && (index += chunk.getSize() - 1) < orgArrayFiltered.length) {
                size = orgArrayFiltered[index].lineNumber - anchor + 1;
            }
            chunk.setAnchor(anchor);
            chunk.setSize(size);
            chunk = delta.getRevised();
            index = chunk.getAnchor();
            anchor = index < revArrayFiltered.length ? revArrayFiltered[index].lineNumber : revArray.length;
            size = chunk.getSize();
            if (size > 0 && (index += chunk.getSize() - 1) < revArrayFiltered.length) {
                size = revArrayFiltered[index].lineNumber - anchor + 1;
            }
            chunk.setAnchor(anchor);
            chunk.setSize(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMString[] filter(Ignore ignore, Object[] array) {
        ArrayList<JMString> result;
        CharBuffer charBuffer = inputLine;
        synchronized (charBuffer) {
            result = new ArrayList<JMString>(array.length);
            int lineNumber = -1;
            for (Object o : array) {
                ++lineNumber;
                inputLine.clear();
                inputLine.put(o.toString());
                CompareUtil.removeIgnoredChars(inputLine, ignore, outputLine);
                if (outputLine.remaining() == 0) continue;
                JMString jms = new JMString();
                jms.s = outputLine.toString();
                jms.lineNumber = lineNumber;
                result.add(jms);
            }
        }
        return result.toArray(new JMString[result.size()]);
    }

    class JMString {
        String s;
        int lineNumber;

        JMString() {
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object o) {
            return this.s.equals(((JMString)o).s);
        }

        public String toString() {
            return "[" + this.lineNumber + "] " + this.s;
        }
    }
}

