/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.db2;

import java.lang.reflect.Method;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.db2.DB2Plugin;

public class DB2JCCExceptionFormatter
implements ExceptionFormatter {
    public static final String JCC_EXCEPTION_PREFIX = "com.ibm.db2.jcc";
    public static final String JCC_EXCEPTION_CLASS = "SqlException";
    private static final String METHOD_GET_SQLCA = "getSqlca";
    private static final String METHOD_GET_SQL_STATE = "getSqlState";
    private static final String METHOD_GET_SQL_CODE = "getSqlCode";
    private static final String METHOD_GET_MESSAGE = "getMessage";
    private static final ILogger s_log = LoggerController.createLogger(DB2Plugin.class);

    public boolean formatsException(Throwable t) {
        if (t == null) {
            return false;
        }
        String className = t.getClass().getName();
        return className.startsWith(JCC_EXCEPTION_PREFIX) && className.endsWith("Exception");
    }

    public String format(Throwable t) throws Exception {
        Utilities.checkNull((String)"format", (Object[])new Object[]{"t", t});
        StringBuilder builder = new StringBuilder();
        Method getSqlca = t.getClass().getMethod(METHOD_GET_SQLCA, null);
        Object sqlca = getSqlca.invoke((Object)t, (Object[])null);
        Method getMessage = sqlca.getClass().getMethod(METHOD_GET_MESSAGE, null);
        String msg = getMessage.invoke(sqlca, (Object[])null).toString();
        Method getSqlCode = sqlca.getClass().getMethod(METHOD_GET_SQL_CODE, null);
        int sqlCode = (Integer)getSqlCode.invoke(sqlca, (Object[])null);
        Method getSqlState = sqlca.getClass().getMethod(METHOD_GET_SQL_STATE, null);
        String sqlState = getSqlState.invoke(sqlca, (Object[])null).toString();
        s_log.info((Object)("MESSAGE: " + msg));
        builder.append(msg).append(" SQL Code: ").append(sqlCode).append(", SQL State: ").append(sqlState);
        return builder.toString();
    }
}

