/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.action;

import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.plugins.mssql.MssqlPlugin;

public class IndexDefragCommand
implements ICommand {
    private ISession _session;
    private final MssqlPlugin _plugin;
    private final ITableInfo _tableInfo;
    private final String _indexName;

    public IndexDefragCommand(ISession session, MssqlPlugin plugin, ITableInfo tableInfo, String indexName) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        if (tableInfo == null) {
            throw new IllegalArgumentException("ITableInfo == null");
        }
        this._session = session;
        this._plugin = plugin;
        this._tableInfo = tableInfo;
        this._indexName = indexName;
    }

    public void execute() {
        StringBuffer sqlBuffer = new StringBuffer();
        String sqlSep = this._session.getQueryTokenizer().getSQLStatementSeparator();
        sqlBuffer.append("DBCC INDEXDEFRAG(");
        sqlBuffer.append(this._tableInfo.getCatalogName());
        sqlBuffer.append(",");
        sqlBuffer.append(this._tableInfo.getSimpleName());
        sqlBuffer.append(",");
        sqlBuffer.append(this._indexName);
        sqlBuffer.append(")\n");
        sqlBuffer.append(sqlSep);
        sqlBuffer.append(" \n");
        this._session.getSessionInternalFrame().getMainSQLPanelAPI().appendSQLScript(sqlBuffer.toString(), true);
        this._session.getSessionInternalFrame().getMainSQLPanelAPI().executeCurrentSQL();
        this._session.selectMainTab(1);
    }
}

