/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import java.sql.SQLException;
import unity.engine.JoinTuple;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.jdbc.UnityDriver;
import unity.predicates.AttrJoinPredicate;
import unity.predicates.Equal;
import unity.predicates.IntJoinPredicate;
import unity.predicates.SelectionPredicate;
import unity.query.LQCondNode;

public class JoinPredicate {
    protected SelectionPredicate filterPredicate;
    protected boolean inverse = false;
    protected JoinTuple filterTuple = new JoinTuple();
    protected LQCondNode queryNode;

    public JoinPredicate() {
    }

    public JoinPredicate(SelectionPredicate selectionPredicate) {
        this();
        this.filterPredicate = selectionPredicate;
    }

    public JoinPredicate inversePredicate() {
        return null;
    }

    public boolean isEqual(Tuple tuple, Tuple tuple2) throws SQLException {
        if (this.filterPredicate == null) {
            return true;
        }
        return this.evaluateFilter(tuple, tuple2);
    }

    public boolean isLessThan(Tuple tuple, Tuple tuple2) throws SQLException {
        return false;
    }

    public boolean evaluateFilter(Tuple tuple, Tuple tuple2) throws SQLException {
        if (this.inverse) {
            this.filterTuple.setLeftTuple(tuple2);
            this.filterTuple.setRightTuple(tuple);
        } else {
            this.filterTuple.setLeftTuple(tuple);
            this.filterTuple.setRightTuple(tuple2);
        }
        return this.filterPredicate.evaluate(this.filterTuple);
    }

    public boolean hasFilterPredicate() {
        return this.filterPredicate != null;
    }

    public boolean isEquiJoin() {
        return false;
    }

    public void setFilterPredicate(SelectionPredicate selectionPredicate) {
        this.filterPredicate = selectionPredicate;
    }

    public int getHashKeyInput1(Tuple tuple) throws SQLException {
        tuple.setStatus((byte)1);
        return 0;
    }

    public int getHashKeyInput2(Tuple tuple) throws SQLException {
        tuple.setStatus((byte)1);
        return 0;
    }

    public String toString() {
        if (this.filterPredicate == null) {
            return "CROSS PRODUCT";
        }
        return this.filterPredicate.toString();
    }

    public String toString(Relation relation, Relation relation2) {
        if (this.filterPredicate == null) {
            return "CROSS PRODUCT";
        }
        Relation relation3 = new Relation(relation);
        relation3.mergeRelation(relation2);
        return this.filterPredicate.toString(relation3);
    }

    public static boolean compare(Object object, Object object2) throws SQLException {
        if (object.getClass() == object2.getClass()) {
            if (object instanceof String ? !Equal.compareStrings((String)object, (String)object2) : !object.equals(object2)) {
                return false;
            }
        } else if (object instanceof String || object2 instanceof String) {
            if (!object.toString().equals(object2.toString())) {
                return false;
            }
        } else if (object instanceof Number && object2 instanceof Number) {
            Integer n;
            Integer n2;
            Long l;
            Long l2;
            if (object instanceof Long || object2 instanceof Long ? !(l2 = new Long(((Number)object).longValue())).equals(l = new Long(((Number)object2).longValue())) : (object instanceof Integer || object2 instanceof Integer) && !(n2 = new Integer(((Number)object).intValue())).equals(n = new Integer(((Number)object2).intValue()))) {
                return false;
            }
        } else {
            throw new SQLException(UnityDriver.i18n.getString("JoinPredicate.ErrorImplicitCast") + object.getClass() + " , " + object2.getClass());
        }
        return true;
    }

    public static int[] getAttributeLocs(JoinPredicate joinPredicate, int n) {
        if (joinPredicate instanceof AttrJoinPredicate) {
            AttrJoinPredicate attrJoinPredicate = (AttrJoinPredicate)joinPredicate;
            if (n == 1) {
                return attrJoinPredicate.getAttr1Locs();
            }
            return attrJoinPredicate.getAttr2Locs();
        }
        if (joinPredicate instanceof IntJoinPredicate) {
            IntJoinPredicate intJoinPredicate = (IntJoinPredicate)joinPredicate;
            if (n == 1) {
                return new int[]{intJoinPredicate.getAttr1Loc()};
            }
            return new int[]{intJoinPredicate.getAttr2Loc()};
        }
        return null;
    }

    public LQCondNode getQueryNode() {
        return this.queryNode;
    }

    public void setQueryNode(LQCondNode lQCondNode) {
        this.queryNode = lQCondNode;
    }
}

