/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstitute;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstituteRoot;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.IType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.TupelType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ViewObjectsUtil;

public class RootType {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RootType.class);
    private IType _type;

    public RootType(List<ObjectSubstituteRoot> objects, ArrayList<MappedClassInfo> allMappedClassInfos) {
        this._type = this.createResultType(objects.get(0), allMappedClassInfos, objects);
    }

    private IType createResultType(ObjectSubstituteRoot object, ArrayList<MappedClassInfo> allMappedClassInfos, List<ObjectSubstituteRoot> objects) {
        if (object.isArray()) {
            return this.createResultTupleType(object, allMappedClassInfos, objects);
        }
        String mappedClassName = object.getObjectSubstitute().getClassName();
        return this.createSingleTypeResultType(mappedClassName, allMappedClassInfos, objects);
    }

    private IType createResultTupleType(ObjectSubstituteRoot object, ArrayList<MappedClassInfo> allMappedClassInfos, List<ObjectSubstituteRoot> objects) {
        ArrayList<MappedClassInfo> mappedClassInfos = new ArrayList<MappedClassInfo>();
        for (int i = 0; i < object.getArraySize(); ++i) {
            ObjectSubstitute buf = object.getArrayItemAt(i);
            String mappedClassName = buf.getClassName();
            mappedClassInfos.add(ViewObjectsUtil.findMappedClassInfo(mappedClassName, allMappedClassInfos, false));
        }
        return new TupelType(mappedClassInfos, allMappedClassInfos, objects);
    }

    private SingleType createSingleTypeResultType(String mappedClassName, ArrayList<MappedClassInfo> allMappedClassInfos, List<ObjectSubstituteRoot> objects) {
        MappedClassInfo mappedClassInfo = ViewObjectsUtil.findMappedClassInfo(mappedClassName, allMappedClassInfos, false);
        return new SingleType(mappedClassInfo, allMappedClassInfos, ObjectSubstituteRoot.toObjectSubstitutes(objects));
    }

    public IType getResultType() {
        return this._type;
    }

    public String toString() {
        return s_stringMgr.getString("QueryResultNode.objectTree");
    }
}

