/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.configuration;

import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePlugin;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.ProcessDetails;
import net.sourceforge.squirrel_sql.plugins.hibernate.configuration.ProcessDetailsDialog;

public class ProcessDetailsController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ProcessDetailsController.class);
    private ProcessDetails _processDetails;
    private String[] _cp;
    private ProcessDetailsDialog _dialog;

    public ProcessDetailsController(HibernatePlugin plugin, ProcessDetails processDetails, String[] cp) {
        this._processDetails = processDetails;
        this._cp = cp;
        this._dialog = new ProcessDetailsDialog((JFrame)plugin.getApplication().getMainFrame());
        this._dialog.txtCommand.setText(processDetails.getCommand());
        this._dialog.chkEndProcessOnDisconnect.setSelected(processDetails.isEndProcessOnDisconnect());
        this._dialog.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcessDetailsController.this.onOK();
            }
        });
        this._dialog.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcessDetailsController.this.onCancel();
            }
        });
        this._dialog.btnRestoreDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcessDetailsController.this.onRestoreDefault();
            }
        });
        this._dialog.btnCopyCmndToClip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcessDetailsController.this.onCopyCmndToClip();
            }
        });
        GUIUtils.centerWithinParent((Window)this._dialog);
        this._dialog.setVisible(true);
    }

    private void onCopyCmndToClip() {
        if (null == this._dialog.txtCommand.getText()) {
            return;
        }
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(this._dialog.txtCommand.getText().trim());
        clip.setContents(data, data);
    }

    private void onRestoreDefault() {
        this._dialog.txtCommand.setText(this._processDetails.restoreDefault());
    }

    private void onCancel() {
        this.close();
    }

    private void close() {
        this._dialog.setVisible(false);
        this._dialog.dispose();
    }

    private void onOK() {
        int intPortNumber;
        if (null == this._dialog.txtCommand.getText() || 0 == this._dialog.txtCommand.getText().trim().length()) {
            JOptionPane.showConfirmDialog(this._dialog, s_stringMgr.getString("ProcessDetailsController.missingCommand"));
            return;
        }
        String command = this._dialog.txtCommand.getText().trim();
        if (0 > command.indexOf("-port:")) {
            JOptionPane.showConfirmDialog(this._dialog, s_stringMgr.getString("ProcessDetailsController.noPort"));
            return;
        }
        String portNumber = command.substring(command.indexOf("-port:") + "-port:".length(), command.length());
        try {
            intPortNumber = Integer.parseInt(portNumber);
        }
        catch (NumberFormatException e) {
            JOptionPane.showConfirmDialog(this._dialog, s_stringMgr.getString("ProcessDetailsController.invalidPortNumber", new Object[]{portNumber}));
            return;
        }
        this._processDetails.setCommand(command);
        this._processDetails.setPort(intPortNumber);
        this._processDetails.setEndProcessOnDisconnect(this._dialog.chkEndProcessOnDisconnect.isSelected());
        this.close();
    }
}

