/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.IOkClosePanelListener;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanelEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.dataimport.EDTMessageBoxUtil;
import net.sourceforge.squirrel_sql.plugins.dataimport.ImportDataIntoTableExecutor;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.ColumnMappingTableModel;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.ImportFileDialog;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.ImportFileDialogProps;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.SpecialColumnMapping;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.IFileImporter;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv.CSVFileImporter;

public class ImportFileDialogCtrl {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(ImportFileDialogCtrl.class);
    private final ImportFileDialog _importFileDialog;
    private String[][] previewData = null;
    private List<String> _importerColumns = new ArrayList<String>();
    private ISession _session;
    private File _importFile;
    private IFileImporter _importer;
    private ITableInfo _table;
    private TableColumnInfo[] _columns;

    public ImportFileDialogCtrl(ISession session, File importFile, IFileImporter importer, ITableInfo table, TableColumnInfo[] columns) {
        this._session = session;
        this._importFile = importFile;
        this._importer = importer;
        this._table = table;
        this._columns = columns;
        this._importFileDialog = new ImportFileDialog(this._importFile, importer.getImportFileTypeDescription(), this._table);
        this._importFileDialog.setSize(this.getDimension());
        this._importFileDialog.addWidgetListener((WidgetListener)new WidgetAdapter(){

            public boolean widgetClosing(WidgetEvent evt) {
                ImportFileDialogCtrl.this.onClosing();
                return true;
            }
        });
        this._importFileDialog.btnsPnl.addListener(new IOkClosePanelListener(){

            public void okPressed(OkClosePanelEvent evt) {
                ImportFileDialogCtrl.this.onOk();
            }

            public void closePressed(OkClosePanelEvent evt) {
                ImportFileDialogCtrl.this.close();
            }

            public void cancelPressed(OkClosePanelEvent evt) {
                ImportFileDialogCtrl.this.close();
            }
        });
        this._importFileDialog.tblMapping.setModel(new ColumnMappingTableModel(columns));
        this._importFileDialog.chkHeadersIncluded.setSelected(ImportFileDialogProps.isHeadersIncluded());
        this._importFileDialog.chkHeadersIncluded.addActionListener(e -> this.onHeadersIncluded());
        this.onHeadersIncluded();
        this._importFileDialog.btnSuggestColumns.addActionListener(e -> this.suggestColumns());
        this._importFileDialog.btnOneToOneMapping.addActionListener(e -> this.mapOneToOne());
        this._importFileDialog.txtCommitAfterInserts.setText("" + ImportFileDialogProps.getCommitAfterInsertsCount());
        this._importFileDialog.chkSingleTransaction.setSelected(ImportFileDialogProps.isSingleTransaction());
        this._importFileDialog.chkSingleTransaction.addActionListener(e -> this.updateTransactionPanel());
        this.updateTransactionPanel();
        this._importFileDialog.chkEmptyTableBeforeImport.setSelected(ImportFileDialogProps.isEmptyTableOnImport());
        this._importFileDialog.chkEmptyTableBeforeImport.addActionListener(e -> this.onEmptyTableBeforeImport());
        this.onEmptyTableBeforeImport();
        this._importFileDialog.chkTrimValues.setSelected(ImportFileDialogProps.isTrimValues());
        this._importFileDialog.chkSafeMode.setSelected(ImportFileDialogProps.isSaveMode());
        GUIUtils.enableCloseByEscape((DialogWidget)this._importFileDialog);
    }

    private void onEmptyTableBeforeImport() {
        if (this._importFileDialog.chkEmptyTableBeforeImport.isSelected()) {
            this._importFileDialog.lblEmptyTableWarning.setText(stringMgr.getString("ImportFileDialogCtrl.all.data.will.be.lost.warning"));
        } else {
            this._importFileDialog.lblEmptyTableWarning.setText(null);
        }
    }

    private void onHeadersIncluded() {
        this._importFileDialog.btnSuggestColumns.setSelected(false);
        this.updatePreviewData();
    }

    private Dimension getDimension() {
        return new Dimension(ImportFileDialogProps.getDialogWidth(), ImportFileDialogProps.getDialogHeight());
    }

    public void onClosing() {
        Dimension size = this._importFileDialog.getSize();
        ImportFileDialogProps.setDialogWidth(size.width);
        ImportFileDialogProps.setDialogHeight(size.height);
        ImportFileDialogProps.setCommitAfterInsertsCount(this.getCommitAfterEveryInsertsCount());
        ImportFileDialogProps.setEmptyTableOnImport(this._importFileDialog.chkEmptyTableBeforeImport.isSelected());
        ImportFileDialogProps.setHeadersIncluded(this._importFileDialog.chkHeadersIncluded.isSelected());
        ImportFileDialogProps.setSingleTransaction(this._importFileDialog.chkSingleTransaction.isSelected());
        ImportFileDialogProps.setTrimValues(this._importFileDialog.chkTrimValues.isSelected());
        ImportFileDialogProps.setSaveMode(this._importFileDialog.chkSafeMode.isSelected());
    }

    private void updateTransactionPanel() {
        boolean intermediateCommits = false == this._importFileDialog.chkSingleTransaction.isSelected();
        this._importFileDialog.txtCommitAfterInserts.setEnabled(intermediateCommits);
        this._importFileDialog.lblCommitAfterInsertBegin.setEnabled(intermediateCommits);
        this._importFileDialog.lblCommitAfterInsertEnd.setEnabled(intermediateCommits);
    }

    public void setPreviewData(String[][] data) {
        this.previewData = data;
        this.updatePreviewData();
    }

    private void updatePreviewData() {
        JComboBox<String> cboColumnMapping = new JComboBox<String>();
        cboColumnMapping.addItem(SpecialColumnMapping.SKIP.getVisibleString());
        cboColumnMapping.addItem(SpecialColumnMapping.FIXED_VALUE.getVisibleString());
        cboColumnMapping.addItem(SpecialColumnMapping.AUTO_INCREMENT.getVisibleString());
        cboColumnMapping.addItem(SpecialColumnMapping.NULL.getVisibleString());
        cboColumnMapping.addActionListener(e -> this.onColumnMappingSelected(e));
        if (this.previewData != null && this.previewData.length > 0) {
            int i;
            Object[] headers = new String[this.previewData[0].length];
            Object[][] data = this.previewData;
            if (this._importFileDialog.chkHeadersIncluded.isSelected()) {
                for (i = 0; i < headers.length; ++i) {
                    headers[i] = data[0][i];
                }
                data = new String[this.previewData.length - 1][];
                for (i = 1; i < this.previewData.length; ++i) {
                    data[i - 1] = this.previewData[i];
                }
            } else {
                for (i = 0; i < headers.length; ++i) {
                    headers[i] = stringMgr.getString("ImportFileDialog.column") + i;
                }
            }
            this._importerColumns.clear();
            for (i = 0; i < headers.length; ++i) {
                this._importerColumns.add(headers[i]);
            }
            for (String string : headers) {
                cboColumnMapping.addItem(string);
            }
            DefaultTableModel dataModel = new DefaultTableModel(data, headers){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this._importFileDialog.tblPreview.setModel(dataModel);
        }
        if (null != this._importFileDialog.tblMapping.getColumnModel().getColumn(1).getCellEditor()) {
            this._importFileDialog.tblMapping.getColumnModel().getColumn(1).getCellEditor().cancelCellEditing();
        }
        this._importFileDialog.tblMapping.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(cboColumnMapping));
        ((ColumnMappingTableModel)this._importFileDialog.tblMapping.getModel()).resetMappings();
        if (this._importFileDialog.btnSuggestColumns.isSelected()) {
            this.suggestColumns();
        } else if (this._importFileDialog.btnOneToOneMapping.isSelected()) {
            this.mapOneToOne();
        }
    }

    private void onColumnMappingSelected(ActionEvent e) {
        int selectedRow = this._importFileDialog.tblMapping.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        TableModel model = this._importFileDialog.tblMapping.getModel();
        String comboValue = ((JComboBox)e.getSource()).getSelectedItem().toString();
        int fixedValueColumnIdx = 2;
        if (comboValue.equals(SpecialColumnMapping.AUTO_INCREMENT.getVisibleString())) {
            if (model.getValueAt(selectedRow, fixedValueColumnIdx) == null || "".equals(model.getValueAt(selectedRow, fixedValueColumnIdx))) {
                model.setValueAt("0", selectedRow, fixedValueColumnIdx);
            }
        } else if (!comboValue.equals(SpecialColumnMapping.FIXED_VALUE.getVisibleString())) {
            model.setValueAt("", selectedRow, fixedValueColumnIdx);
        }
        this._importFileDialog.tblMapping.clearSelection();
    }

    private void mapOneToOne() {
        if (this._importFileDialog.btnSuggestColumns.isSelected()) {
            this._importFileDialog.btnSuggestColumns.setSelected(false);
        }
        ColumnMappingTableModel columnMappingTableModel = (ColumnMappingTableModel)this._importFileDialog.tblMapping.getModel();
        if (this._importFileDialog.btnOneToOneMapping.isSelected()) {
            columnMappingTableModel.resetMappings();
            for (int i = 0; i < Math.min(this._importerColumns.size(), this._columns.length); ++i) {
                String importerColumn = this._importerColumns.get(i);
                if (StringUtilities.isEmpty((String)importerColumn, (boolean)true)) continue;
                columnMappingTableModel.setValueAt(importerColumn, i, 1);
            }
        } else {
            columnMappingTableModel.resetMappings();
        }
    }

    public void suggestColumns() {
        if (this._importFileDialog.btnOneToOneMapping.isSelected()) {
            this._importFileDialog.btnOneToOneMapping.setSelected(false);
        }
        ColumnMappingTableModel columnMappingTableModel = (ColumnMappingTableModel)this._importFileDialog.tblMapping.getModel();
        if (this._importFileDialog.btnSuggestColumns.isSelected()) {
            columnMappingTableModel.resetMappings();
            for (String importerColumn : this._importerColumns) {
                TableColumnInfo suggestedColumn;
                if (null == importerColumn || importerColumn.isEmpty() || (suggestedColumn = this.suggestColumn(importerColumn)) == null) continue;
                String suggestedColumnName = suggestedColumn.getColumnName();
                int row = columnMappingTableModel.findTableColumn(suggestedColumnName);
                columnMappingTableModel.setValueAt(importerColumn, row, 1);
            }
        } else {
            columnMappingTableModel.resetMappings();
        }
    }

    private TableColumnInfo suggestColumn(String importerColumn) {
        for (TableColumnInfo colInfo : this._columns) {
            if (!colInfo.getColumnName().equalsIgnoreCase(importerColumn)) continue;
            return colInfo;
        }
        return null;
    }

    public void onOk() {
        ColumnMappingTableModel columnMappingModel = (ColumnMappingTableModel)this._importFileDialog.tblMapping.getModel();
        if (0 == columnMappingModel.getColumnCountExcludingSkipped(this._columns)) {
            String msg = stringMgr.getString("ImportFileDialogCtrl.all.columns.skipped.msg");
            String title = stringMgr.getString("ImportFileDialogCtrl.all.columns.skipped.title");
            EDTMessageBoxUtil.showMessageDialogOnEDT(msg, title);
            return;
        }
        this.close();
        if (this._importer instanceof CSVFileImporter) {
            ((CSVFileImporter)this._importer).setSafetySwitch(this._importFileDialog.chkSafeMode.isSelected());
        }
        this._importer.setTrimValues(this._importFileDialog.chkTrimValues.isSelected());
        int commitAfterEveryInsertsCount = this.getCommitAfterEveryInsertsCount();
        ImportDataIntoTableExecutor executor = new ImportDataIntoTableExecutor(this._session, this._table, this._columns, this._importerColumns, columnMappingModel, this._importer, this._importFileDialog.chkSingleTransaction.isSelected(), commitAfterEveryInsertsCount, this._importFileDialog.chkEmptyTableBeforeImport.isSelected());
        executor.setSkipHeader(this._importFileDialog.chkHeadersIncluded.isSelected());
        executor.execute();
    }

    private int getCommitAfterEveryInsertsCount() {
        int commitAfterEveryInsertsCount = ImportFileDialogProps.getCommitAfterInsertsCount();
        if (null != this._importFileDialog.txtCommitAfterInserts.getText()) {
            try {
                int buf = Integer.valueOf(this._importFileDialog.txtCommitAfterInserts.getText());
                if (commitAfterEveryInsertsCount >= 0) {
                    commitAfterEveryInsertsCount = buf;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return commitAfterEveryInsertsCount;
    }

    private void close() {
        this.onClosing();
        this._importFileDialog.setVisible(false);
        this._importFileDialog.dispose();
    }

    public void show() {
        Main.getApplication().getMainFrame().addWidget((DialogWidget)this._importFileDialog);
        this._importFileDialog.moveToFront();
        DialogWidget.centerWithinDesktop((DialogWidget)this._importFileDialog);
        this._importFileDialog.setVisible(true);
    }
}

