/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.smarttools;

import java.awt.print.PrinterException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.smarttools.STDataType;
import net.sourceforge.squirrel_sql.plugins.smarttools.SmarttoolsPlugin;

public class SmarttoolsHelper {
    private static final ILogger log = LoggerController.createLogger(SmarttoolsHelper.class);
    public static final String CR = System.getProperty("line.separator", "\n");

    private SmarttoolsHelper() {
    }

    public static ImageIcon loadIcon(String imageIconName) {
        URL imgURL = SmarttoolsPlugin.class.getResource("images/" + imageIconName);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        log.error((Object)("Couldn't find file: images/" + imageIconName));
        return null;
    }

    public static int convertStringToIntDef(String string, int defaultValue) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static void printTable(JTable table, String headerText, String footerText) {
        try {
            MessageFormat headerFormat = new MessageFormat(headerText);
            MessageFormat footerFormat = new MessageFormat(footerText);
            table.print(JTable.PrintMode.FIT_WIDTH, headerFormat, footerFormat);
        }
        catch (PrinterException e) {
            log.error((Object)e.getLocalizedMessage());
        }
    }

    public static List<STDataType> getListSmarttoolsDataType(boolean withGroupNull) {
        ArrayList<STDataType> listSmarttoolsDataType = new ArrayList<STDataType>();
        listSmarttoolsDataType.add(new STDataType(-1, "Group integer", 1));
        listSmarttoolsDataType.add(new STDataType(-1, "Group char", 3));
        listSmarttoolsDataType.add(new STDataType(-1, "Group numeric", 2));
        if (withGroupNull) {
            listSmarttoolsDataType.add(new STDataType(0, "NULL", 0));
        }
        listSmarttoolsDataType.add(new STDataType(-5, "BIGINT", 1));
        listSmarttoolsDataType.add(new STDataType(1, "CHAR", 3));
        listSmarttoolsDataType.add(new STDataType(91, "DATE", 4));
        listSmarttoolsDataType.add(new STDataType(3, "DECIMAL", 2));
        listSmarttoolsDataType.add(new STDataType(8, "DOUBLE", 2));
        listSmarttoolsDataType.add(new STDataType(6, "FLOAT", 2));
        listSmarttoolsDataType.add(new STDataType(4, "INTEGER", 1));
        listSmarttoolsDataType.add(new STDataType(-1, "LONGVARCHAR", 3));
        listSmarttoolsDataType.add(new STDataType(2, "NUMERIC", 2));
        listSmarttoolsDataType.add(new STDataType(7, "REAL", 2));
        listSmarttoolsDataType.add(new STDataType(5, "SMALLINT", 1));
        listSmarttoolsDataType.add(new STDataType(92, "TIME", 4));
        listSmarttoolsDataType.add(new STDataType(93, "TIMESTAMP", 4));
        listSmarttoolsDataType.add(new STDataType(-6, "TINYINT", 1));
        listSmarttoolsDataType.add(new STDataType(12, "VARCHAR", 3));
        return listSmarttoolsDataType;
    }

    public static void fillOperatorTypes(JComboBox cbOperator, int usedGroup) {
        cbOperator.removeAllItems();
        cbOperator.addItem("is null");
        cbOperator.addItem("is not null");
        cbOperator.addItem("=");
        cbOperator.addItem("<>");
        cbOperator.addItem(">");
        cbOperator.addItem("<");
        if (usedGroup == 3) {
            cbOperator.addItem("like");
            cbOperator.addItem("not like");
        }
        cbOperator.setSelectedIndex(0);
    }

    public static boolean isDataTypeString(int dataType) {
        return dataType == 1 || dataType == -1 || dataType == 12;
    }

    public static boolean isDataTypeInt(int dataType) {
        return dataType == -5 || dataType == 4 || dataType == 5 || dataType == -6;
    }

    public static boolean isDataTypeNumeric(int dataType) {
        return dataType == 3 || dataType == 8 || dataType == 6 || dataType == 2 || dataType == 7;
    }

    public static boolean isDataTypeDate(int dataType) {
        return dataType == 91 || dataType == 93 || dataType == 92;
    }

    public static String getDataTypeForDisplay(TableColumnInfo tableColumnInfo) {
        StringBuilder buf = new StringBuilder();
        buf.append(tableColumnInfo.getTypeName());
        if (SmarttoolsHelper.isDataTypeString(tableColumnInfo.getDataType())) {
            buf.append(" (" + tableColumnInfo.getColumnSize() + ")");
        } else if (SmarttoolsHelper.isDataTypeNumeric(tableColumnInfo.getDataType())) {
            buf.append(" (" + tableColumnInfo.getColumnSize() + "," + tableColumnInfo.getDecimalDigits() + ")");
        }
        return buf.toString();
    }

    public static int checkColumnData(Statement stmt, String sql) throws SQLException {
        int resultFound = 0;
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            resultFound = rs.getInt(1);
        }
        rs.close();
        return resultFound;
    }

    public static void markAllRows(JTable tbl, int col, boolean mark) {
        for (int row = 0; row < tbl.getRowCount(); ++row) {
            tbl.setValueAt(mark, row, col);
        }
    }

    public static void setColumnWidth(JTable table, int[] colWidth) {
        TableColumnModel tcm = table.getColumnModel();
        for (int col = 0; col < tcm.getColumnCount(); ++col) {
            if (col >= colWidth.length) continue;
            tcm.getColumn(col).setPreferredWidth(colWidth[col]);
        }
        table.doLayout();
    }

    public static int getRowCount(Statement stmt, String tableName) throws SQLException {
        int rowCount = 0;
        ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
        if (rs.next()) {
            rowCount = rs.getInt(1);
        }
        rs.close();
        return rowCount;
    }
}

