/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ColorSchemeTransform;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.colorscheme.EbonyColorScheme;
import org.jvnet.substance.colorscheme.MetallicColorScheme;
import org.jvnet.substance.colorscheme.TintColorScheme;
import org.jvnet.substance.colorscheme.ToneColorScheme;
import org.jvnet.substance.painter.border.ClassicBorderPainter;
import org.jvnet.substance.painter.border.CompositeBorderPainter;
import org.jvnet.substance.painter.border.DelegateBorderPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.FlatDecorationPainter;
import org.jvnet.substance.painter.gradient.SimplisticGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.ClassicButtonShaper;
import org.jvnet.substance.watermark.SubstanceCrosshatchWatermark;

public class RavenGraphiteSkin
extends SubstanceSkin {
    public static String NAME = "Raven Graphite";

    public RavenGraphiteSkin() {
        SubstanceColorScheme activeScheme = new TintColorScheme(new EbonyColorScheme(), 0.2){
            Color foreColor;
            {
                this.foreColor = new Color(200, 200, 200);
            }

            @Override
            public Color getForegroundColor() {
                return this.foreColor;
            }
        }.named("Raven Graphite Active");
        SubstanceColorScheme selectedDisabledScheme = new TintColorScheme(new EbonyColorScheme(), 0.2){
            Color foreColor;
            {
                this.foreColor = new Color(32, 32, 32);
            }

            @Override
            public Color getForegroundColor() {
                return this.foreColor;
            }
        }.named("Raven Graphite Selected Disabled");
        SubstanceColorScheme disabledScheme = new ToneColorScheme(new EbonyColorScheme(), 0.35){
            Color foreColor;
            {
                this.foreColor = new Color(32, 32, 32);
            }

            @Override
            public Color getForegroundColor() {
                return this.foreColor;
            }
        }.named("Raven Graphite Disabled");
        SubstanceColorScheme defaultScheme = activeScheme.shade(0.2).named("Raven Graphite Default");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, disabledScheme);
        SubstanceColorScheme highlightScheme = new MetallicColorScheme().tint(0.1).named("Raven Graphite Highlight");
        defaultSchemeBundle.registerHighlightColorScheme(highlightScheme, 0.6f, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(highlightScheme, 0.8f, ComponentState.SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(highlightScheme, 1.0f, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(highlightScheme, 0.75f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultSchemeBundle.registerColorScheme((SubstanceColorScheme)new EbonyColorScheme(), ColorSchemeAssociationKind.HIGHLIGHT_BORDER, ComponentState.getActiveStates());
        SubstanceColorScheme textHighlightScheme = new MetallicColorScheme().tone(0.5).named("Raven Graphite Text Highlight");
        defaultSchemeBundle.registerColorScheme(textHighlightScheme, ColorSchemeAssociationKind.TEXT_HIGHLIGHT, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerColorScheme(highlightScheme, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultSchemeBundle.registerColorScheme(disabledScheme, 0.5f, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(selectedDisabledScheme, 0.5f, ComponentState.DISABLED_SELECTED);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, DecorationAreaType.NONE);
        this.registerAsDecorationArea(defaultScheme, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.FOOTER, DecorationAreaType.GENERAL, DecorationAreaType.TOOLBAR);
        this.setSelectedTabFadeStart(0.3);
        this.setSelectedTabFadeEnd(0.6);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = new SubstanceCrosshatchWatermark();
        this.gradientPainter = new SimplisticGradientPainter(){

            @Override
            public Color getBottomFillColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
                return this.getMidFillColorBottom(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
            }

            @Override
            public Color getTopFillColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
                return super.getBottomFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
            }
        };
        this.decorationPainter = new FlatDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new CompositeBorderPainter("Raven Graphite", new ClassicBorderPainter(), new DelegateBorderPainter("Raven Graphite Inner", new ClassicBorderPainter(), -1, 0x60FFFFFF, 0xFFFFFF, new ColorSchemeTransform(){

            @Override
            public SubstanceColorScheme transform(SubstanceColorScheme scheme) {
                return scheme.tint(0.4f);
            }
        }));
        this.highlightBorderPainter = new ClassicBorderPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

