/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.type.Type;

public class TeiidDialect
extends Dialect {
    public TeiidDialect() {
        this.registerColumnType(1, "char");
        this.registerColumnType(12, "string");
        this.registerColumnType(-7, "boolean");
        this.registerColumnType(-6, "byte");
        this.registerColumnType(5, "short");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "long");
        this.registerColumnType(7, "float");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(2, "bigdecimal");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(-3, "blob");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(2000, "object");
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)Hibernate.DOUBLE));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)Hibernate.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)Hibernate.DOUBLE));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction("atan2", (Type)Hibernate.DOUBLE));
        this.registerFunction("ceil", (SQLFunction)new StandardSQLFunction("ceiling"));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)Hibernate.DOUBLE));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction("cot", (Type)Hibernate.DOUBLE));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees", (Type)Hibernate.DOUBLE));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)Hibernate.DOUBLE));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor"));
        this.registerFunction("formatbigdecimal", (SQLFunction)new StandardSQLFunction("formatbigdecimal", (Type)Hibernate.STRING));
        this.registerFunction("formatbiginteger", (SQLFunction)new StandardSQLFunction("formatbiginteger", (Type)Hibernate.STRING));
        this.registerFunction("formatdouble", (SQLFunction)new StandardSQLFunction("formatdouble", (Type)Hibernate.STRING));
        this.registerFunction("formatfloat", (SQLFunction)new StandardSQLFunction("formatfloat", (Type)Hibernate.STRING));
        this.registerFunction("formatinteger", (SQLFunction)new StandardSQLFunction("formatinteger", (Type)Hibernate.STRING));
        this.registerFunction("formatlong", (SQLFunction)new StandardSQLFunction("formatlong", (Type)Hibernate.STRING));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)Hibernate.DOUBLE));
        this.registerFunction("mod", (SQLFunction)new StandardSQLFunction("mod"));
        this.registerFunction("parsebigdecimal", (SQLFunction)new StandardSQLFunction("parsebigdecimal", (Type)Hibernate.BIG_DECIMAL));
        this.registerFunction("parsebiginteger", (SQLFunction)new StandardSQLFunction("parsebiginteger", (Type)Hibernate.BIG_INTEGER));
        this.registerFunction("parsedouble", (SQLFunction)new StandardSQLFunction("parsedouble", (Type)Hibernate.DOUBLE));
        this.registerFunction("parsefloat", (SQLFunction)new StandardSQLFunction("parsefloat", (Type)Hibernate.FLOAT));
        this.registerFunction("parseinteger", (SQLFunction)new StandardSQLFunction("parseinteger", (Type)Hibernate.INTEGER));
        this.registerFunction("parselong", (SQLFunction)new StandardSQLFunction("parselong", (Type)Hibernate.LONG));
        this.registerFunction("pi", (SQLFunction)new StandardSQLFunction("pi", (Type)Hibernate.DOUBLE));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction("power", (Type)Hibernate.DOUBLE));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians", (Type)Hibernate.DOUBLE));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)Hibernate.INTEGER));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)Hibernate.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)Hibernate.DOUBLE));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)Hibernate.INTEGER));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("chr", (Type)Hibernate.CHARACTER));
        this.registerFunction("char", (SQLFunction)new StandardSQLFunction("char", (Type)Hibernate.CHARACTER));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)Hibernate.STRING, "", "||", ""));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction("initcap", (Type)Hibernate.STRING));
        this.registerFunction("insert", (SQLFunction)new StandardSQLFunction("insert", (Type)Hibernate.STRING));
        this.registerFunction("lcase", (SQLFunction)new StandardSQLFunction("lcase", (Type)Hibernate.STRING));
        this.registerFunction("left", (SQLFunction)new StandardSQLFunction("left", (Type)Hibernate.STRING));
        this.registerFunction("locate", (SQLFunction)new StandardSQLFunction("locate", (Type)Hibernate.INTEGER));
        this.registerFunction("lpad", (SQLFunction)new StandardSQLFunction("lpad", (Type)Hibernate.STRING));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim", (Type)Hibernate.STRING));
        this.registerFunction("repeat", (SQLFunction)new StandardSQLFunction("repeat", (Type)Hibernate.STRING));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction("replace", (Type)Hibernate.STRING));
        this.registerFunction("right", (SQLFunction)new StandardSQLFunction("right", (Type)Hibernate.STRING));
        this.registerFunction("rpad", (SQLFunction)new StandardSQLFunction("rpad", (Type)Hibernate.STRING));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim", (Type)Hibernate.STRING));
        this.registerFunction("substring", (SQLFunction)new StandardSQLFunction("substring", (Type)Hibernate.STRING));
        this.registerFunction("translate", (SQLFunction)new StandardSQLFunction("translate", (Type)Hibernate.STRING));
        this.registerFunction("ucase", (SQLFunction)new StandardSQLFunction("ucase", (Type)Hibernate.STRING));
        this.registerFunction("curdate", (SQLFunction)new NoArgSQLFunction("curdate", (Type)Hibernate.DATE));
        this.registerFunction("curtime", (SQLFunction)new NoArgSQLFunction("curtime", (Type)Hibernate.TIME));
        this.registerFunction("now", (SQLFunction)new NoArgSQLFunction("now", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("dayname", (SQLFunction)new StandardSQLFunction("dayname", (Type)Hibernate.STRING));
        this.registerFunction("dayofmonth", (SQLFunction)new StandardSQLFunction("dayofmonth", (Type)Hibernate.INTEGER));
        this.registerFunction("dayofweek", (SQLFunction)new StandardSQLFunction("dayofweek", (Type)Hibernate.INTEGER));
        this.registerFunction("dayofyear", (SQLFunction)new StandardSQLFunction("dayofyear", (Type)Hibernate.INTEGER));
        this.registerFunction("formatdate", (SQLFunction)new StandardSQLFunction("formatdate", (Type)Hibernate.STRING));
        this.registerFunction("formattime", (SQLFunction)new StandardSQLFunction("formattime", (Type)Hibernate.STRING));
        this.registerFunction("formattimestamp", (SQLFunction)new StandardSQLFunction("formattimestamp", (Type)Hibernate.STRING));
        this.registerFunction("hour", (SQLFunction)new StandardSQLFunction("hour", (Type)Hibernate.INTEGER));
        this.registerFunction("minute", (SQLFunction)new StandardSQLFunction("minute", (Type)Hibernate.INTEGER));
        this.registerFunction("monthname", (SQLFunction)new StandardSQLFunction("monthname", (Type)Hibernate.STRING));
        this.registerFunction("parsedate", (SQLFunction)new StandardSQLFunction("parsedate", (Type)Hibernate.DATE));
        this.registerFunction("parsetime", (SQLFunction)new StandardSQLFunction("parsetime", (Type)Hibernate.TIME));
        this.registerFunction("parsetimestamp", (SQLFunction)new StandardSQLFunction("parsetimestamp", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("second", (SQLFunction)new StandardSQLFunction("second", (Type)Hibernate.INTEGER));
        this.registerFunction("timestampcreate", (SQLFunction)new StandardSQLFunction("timestampcreate", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("timestampAdd", (SQLFunction)new StandardSQLFunction("timestampAdd"));
        this.registerFunction("timestampDiff", (SQLFunction)new StandardSQLFunction("timestampDiff", (Type)Hibernate.LONG));
        this.registerFunction("week", (SQLFunction)new StandardSQLFunction("week", (Type)Hibernate.INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)Hibernate.INTEGER));
        this.registerFunction("modifytimezone", (SQLFunction)new StandardSQLFunction("modifytimezone", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("convert", (SQLFunction)new StandardSQLFunction("convert"));
        this.registerFunction("to_bytes", (SQLFunction)new StandardSQLFunction("to_bytes", Hibernate.BLOB));
        this.registerFunction("to_chars", (SQLFunction)new StandardSQLFunction("to_chars", Hibernate.CLOB));
        this.registerFunction("from_unittime", (SQLFunction)new StandardSQLFunction("from_unittime", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("session_id", (SQLFunction)new StandardSQLFunction("session_id", (Type)Hibernate.STRING));
        this.registerFunction("uuid", (SQLFunction)new StandardSQLFunction("uuid", (Type)Hibernate.STRING));
        this.registerFunction("unescape", (SQLFunction)new StandardSQLFunction("unescape", (Type)Hibernate.STRING));
        this.registerFunction("array_get", (SQLFunction)new StandardSQLFunction("uuid", Hibernate.OBJECT));
        this.registerFunction("array_length", (SQLFunction)new StandardSQLFunction("unescape", (Type)Hibernate.INTEGER));
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean hasAlterTable() {
        return false;
    }

    public boolean supportsColumnCheck() {
        return false;
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "now";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean supportsTableCheck() {
        return false;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsUnique() {
        return false;
    }

    public String toBooleanValueString(boolean arg0) {
        if (arg0) {
            return "{b'true'}";
        }
        return "{b'false'}";
    }

    public String getLimitString(String querySelect, boolean hasOffset) {
        return new StringBuffer(querySelect.length() + 20).append(querySelect).append(hasOffset ? " limit ?, ?" : " limit ?").toString();
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        ResultSet rs = ps.getResultSet();
        return rs;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    public String getForUpdateNowaitString() {
        return "";
    }

    public String getForUpdateNowaitString(String aliases) {
        return "";
    }

    public String getForUpdateString() {
        return "";
    }

    public String getForUpdateString(LockMode lockMode) {
        return "";
    }

    public String getForUpdateString(String aliases) {
        return "";
    }

    public String getSelectGUIDString() {
        return "select uuid()";
    }
}

