/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLookPropGetCommand
extends SVNLookCommand {
    protected SVNLookPropGetCommand() {
        super("propget", new String[]{"pget", "pg"});
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        options.add(SVNLookOption.REVPROP);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNErrorMessage err;
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        if (environment.getFirstArgument() == null) {
            err = null;
            err = environment.isRevProp() ? SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing propname argument") : SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing propname and repository path arguments");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        } else if (!environment.isRevProp() && environment.getSecondArgument() == null) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing propname or repository path argument");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        String propName = environment.getFirstArgument();
        SVNPropertyValue propValue = null;
        SVNLookClient client = environment.getClientManager().getLookClient();
        propValue = environment.isRevision() ? (environment.isRevProp() ? client.doGetRevisionProperty(environment.getRepositoryFile(), propName, this.getRevisionObject()) : client.doGetProperty(environment.getRepositoryFile(), propName, environment.getSecondArgument(), this.getRevisionObject())) : (environment.isRevProp() ? client.doGetRevisionProperty(environment.getRepositoryFile(), propName, environment.getTransaction()) : client.doGetProperty(environment.getRepositoryFile(), propName, environment.getSecondArgument(), environment.getTransaction()));
        if (propValue == null) {
            SVNErrorMessage err2 = null;
            err2 = environment.isRevProp() ? (environment.isRevision() ? SVNErrorMessage.create(SVNErrorCode.PROPERTY_NOT_FOUND, "Property ''{0}'' not found on revision {1}", propName, String.valueOf(environment.getRevision())) : SVNErrorMessage.create(SVNErrorCode.PROPERTY_NOT_FOUND, "Property ''{0}'' not found in transaction {1}", propName, String.valueOf(environment.getTransaction()))) : (environment.isRevision() ? SVNErrorMessage.create(SVNErrorCode.PROPERTY_NOT_FOUND, "Property ''{0}'' not found on path ''{1}'' in revision {2}", propName, environment.getSecondArgument(), SVNRevision.create(environment.getRevision())) : SVNErrorMessage.create(SVNErrorCode.PROPERTY_NOT_FOUND, "Property ''{0}'' not found on path ''{1}'' in transaction {2}", propName, environment.getSecondArgument(), environment.getTransaction()));
            SVNErrorManager.error(err2, SVNLogType.CLIENT);
        }
        if (propValue.isString()) {
            environment.getOut().print(propValue.getString());
        } else {
            environment.getOut().print(propValue.getBytes());
        }
    }
}

