/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import com.trilead.ssh2.auth.AgentProxy;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.SVNSSHPrivateKeyUtil;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthStoreHandler;
import org.tmatesoft.svn.core.internal.wc.ISVNGnomeKeyringPasswordProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNSSLPasspharsePromptSupport;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNConsoleAuthenticationProvider
implements ISVNAuthenticationProvider,
ISVNSSLPasspharsePromptSupport,
ISVNAuthStoreHandler,
ISVNGnomeKeyringPasswordProvider {
    private static final String OUR_PASSPHRASE_PROMPT_TEXT = "-----------------------------------------------------------------------\nATTENTION!  Your passphrase for client certificate:\n\n   {0}\n\ncan only be stored to disk unencrypted!  You are advised to configure\nyour system so that Subversion can store passphrase encrypted, if\npossible.  See the documentation for details.\n\nYou can avoid future appearances of this warning by setting the value\nof the ''store-ssl-client-cert-pp-plaintext'' option to either ''yes'' or\n''no'' in ''{1}''.\n-----------------------------------------------------------------------\n";
    private static final String OUR_PASSWORD_PROMPT_TEXT = "-----------------------------------------------------------------------\nATTENTION!  Your password for authentication realm:\n\n   {0}\n\ncan only be stored to disk unencrypted!  You are advised to configure\nyour system so that Subversion can store passwords encrypted, if\npossible.  See the documentation for details.\n\nYou can avoid future appearances of this warning by setting the value\nof the ''store-plaintext-passwords'' option to either ''yes'' or ''no'' in\n''{1}''.\n-----------------------------------------------------------------------\n";
    private static final String OUR_HOST_KEY_PROMPT_TEXT = "The ''{0}'' server''s key fingerprint is:\n{1}\n";
    private static final String OUR_PASSWORD_PROMPT_STRING = "Store password unencrypted (yes/no)? ";
    private static final String OUR_PASSPHRASE_PROMPT_STRING = "Store passphrase unencrypted (yes/no)? ";
    private static final int MAX_PROMPT_COUNT = 3;
    private Map<String, Integer> myRequestsCount = new HashMap<String, Integer>();
    private boolean myIsTrustServerCertificate;

    public SVNConsoleAuthenticationProvider(boolean trustServerCertificate) {
        this.myIsTrustServerCertificate = trustServerCertificate;
    }

    @Override
    public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
        if (certificate instanceof byte[]) {
            StringBuffer prompt = new StringBuffer(OUR_HOST_KEY_PROMPT_TEXT);
            if (resultMayBeStored) {
                prompt.append("If you trust this host, enter ''p'' to add the key to the SVN cache and carry on connecting.\n");
                prompt.append("If you want to carry on connecting just once, without adding the key to the cache, type ''t''.");
                prompt.append("If you do not trust this host, type ''R'' to abandon the connection.");
                prompt.append("\n(R)eject, accept (t)emporarily or accept (p)ermanently? ");
            } else {
                prompt.append("If you want to carry on connecting just once, without adding the key to the cache, type ''t''.");
                prompt.append("If you do not trust this host, type ''R'' to abandon the connection.");
                prompt.append("\n(R)eject or accept (t)emporarily? ");
            }
            System.err.print(MessageFormat.format(prompt.toString(), url.getHost(), SVNSSLUtil.getFingerprint((byte[])certificate, "MD5")));
            System.err.flush();
            while (true) {
                String line;
                if ((line = SVNConsoleAuthenticationProvider.readLine()) == null) {
                    return 0;
                }
                if (line.length() < 1) continue;
                char ch = line.charAt(0);
                if (ch == 'R' || ch == 'r') {
                    return 0;
                }
                if (ch == 't' || ch == 'T') {
                    return 1;
                }
                if (resultMayBeStored && (ch == 'p' || ch == 'P')) break;
            }
            return 2;
        }
        if (this.myIsTrustServerCertificate) {
            return 1;
        }
        if (!(certificate instanceof X509Certificate)) {
            return 1;
        }
        String hostName = url.getHost();
        X509Certificate cert = (X509Certificate)certificate;
        StringBuffer prompt = SVNSSLUtil.getServerCertificatePrompt(cert, realm, hostName);
        if (resultMayBeStored) {
            prompt.append("\n(R)eject, accept (t)emporarily or accept (p)ermanently? ");
        } else {
            prompt.append("\n(R)eject or accept (t)emporarily? ");
        }
        System.err.print(prompt.toString());
        System.err.flush();
        while (true) {
            String line;
            if ((line = SVNConsoleAuthenticationProvider.readLine()) == null) {
                return 0;
            }
            if (line.length() < 1) continue;
            char ch = line.charAt(0);
            if (ch == 'R' || ch == 'r') {
                return 0;
            }
            if (ch == 't' || ch == 'T') {
                return 1;
            }
            if (resultMayBeStored && (ch == 'p' || ch == 'P')) break;
        }
        return 2;
    }

    @Override
    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        Integer requestsCount = this.myRequestsCount.get(kind + "$" + url + "$" + realm);
        if (requestsCount == null) {
            this.myRequestsCount.put(kind + "$" + url + "$" + realm, new Integer(1));
        } else {
            if (requestsCount == 3) {
                return null;
            }
            this.myRequestsCount.put(kind + "$" + url + "$" + realm, new Integer(requestsCount + 1));
        }
        if ("svn.simple".equals(kind)) {
            String promptString;
            String name = null;
            String defaultUserName = null;
            if (previousAuth != null) {
                if (previousAuth.isPartial()) {
                    name = previousAuth.getUserName();
                } else if (previousAuth.getUserName() != null) {
                    defaultUserName = previousAuth.getUserName();
                }
            }
            SVNConsoleAuthenticationProvider.printRealm(realm);
            if (name == null && "".equals(name = SVNConsoleAuthenticationProvider.prompt(promptString = defaultUserName == null ? "Username" : "Username [" + defaultUserName + "]")) && defaultUserName != null) {
                name = defaultUserName;
            }
            if (name == null) {
                return null;
            }
            String password = SVNConsoleAuthenticationProvider.promptPassword("Password for '" + name + "'");
            if (password == null) {
                return null;
            }
            return new SVNPasswordAuthentication(name, password, authMayBeStored, url, false);
        }
        if ("svn.ssh".equals(kind)) {
            String name = null;
            String defaultUserName = null;
            String defaultPassword = null;
            String defaultPassphrase = null;
            File defaultPrivateKeyFile = null;
            int defaultPort = -1;
            if (url.getUserInfo() != null && !"".equals(url.getUserInfo())) {
                defaultUserName = url.getUserInfo();
            }
            if (previousAuth != null && previousAuth instanceof SVNSSHAuthentication) {
                SVNSSHAuthentication sshPreviousAuth = (SVNSSHAuthentication)previousAuth;
                defaultUserName = defaultUserName == null ? sshPreviousAuth.getUserName() : defaultUserName;
                defaultPassword = sshPreviousAuth.getPassword();
                defaultPassphrase = sshPreviousAuth.getPassphrase();
                defaultPrivateKeyFile = sshPreviousAuth.getPrivateKeyFile();
                defaultPort = sshPreviousAuth.getPortNumber();
            }
            SVNConsoleAuthenticationProvider.printRealm(realm);
            name = SVNConsoleAuthenticationProvider.prompt(defaultUserName == null ? "Username" : "Username [" + defaultUserName + "]");
            if ("".equals(name) && defaultUserName != null) {
                name = defaultUserName;
            }
            if (name == null) {
                return null;
            }
            String passwordPrompt = null;
            if (defaultPassword != null) {
                passwordPrompt = "Password for '" + url.getHost() + "' (leave blank if you are going to use private key) [";
                for (int i = 0; i < defaultPassword.length(); ++i) {
                    passwordPrompt = passwordPrompt + "*";
                }
                passwordPrompt = passwordPrompt + "]";
            } else {
                passwordPrompt = "Password for '" + url.getHost() + "' (leave blank if you are going to use private key)";
            }
            String password = SVNConsoleAuthenticationProvider.promptPassword(passwordPrompt);
            if (password == null) {
                return null;
            }
            if ("".equals(password)) {
                password = defaultPassword != null ? defaultPassword : null;
            }
            String keyFilePath = null;
            File keyFile = null;
            String passphrase = null;
            if (password == null) {
                while (keyFilePath == null) {
                    String privateKeyFilePrompt = null;
                    privateKeyFilePrompt = defaultPrivateKeyFile != null ? "Private key for '" + url.getHost() + "' (OpenSSH format) [" + defaultPrivateKeyFile.getAbsolutePath() + "]" : "Private key for '" + url.getHost() + "' (OpenSSH format) (leave blank to use a SSH agent)";
                    keyFilePath = SVNConsoleAuthenticationProvider.prompt(privateKeyFilePrompt);
                    if ("".equals(keyFilePath)) {
                        if (defaultPrivateKeyFile == null) continue;
                        if (!defaultPrivateKeyFile.isFile() || !defaultPrivateKeyFile.canRead()) {
                            defaultPrivateKeyFile = null;
                            keyFilePath = null;
                            keyFile = null;
                            continue;
                        }
                        keyFile = defaultPrivateKeyFile;
                        keyFilePath = keyFile.getAbsolutePath();
                        continue;
                    }
                    if (keyFilePath == null) {
                        return null;
                    }
                    keyFile = new File(keyFilePath);
                    if (keyFile.isFile() && keyFile.canRead()) continue;
                    keyFilePath = null;
                    keyFile = null;
                }
                if (keyFile != null) {
                    String passphrasePrompt = null;
                    if (defaultPassphrase != null) {
                        passphrasePrompt = "Private key passphrase [";
                        for (int i = 0; i < defaultPassphrase.length(); ++i) {
                            passphrasePrompt = passphrasePrompt + "*";
                        }
                        passphrasePrompt = passphrasePrompt + "]";
                    } else {
                        passphrasePrompt = "Private key passphrase [none]";
                    }
                    passphrase = SVNConsoleAuthenticationProvider.promptPassword(passphrasePrompt);
                    if ("".equals(passphrase)) {
                        passphrase = defaultPassphrase != null ? defaultPassphrase : null;
                    } else if (passphrase == null) {
                        return null;
                    }
                }
            }
            int port = defaultPort > 0 ? defaultPort : 22;
            String portValue = SVNConsoleAuthenticationProvider.prompt("Port number for '" + url.getHost() + "' [" + port + "]");
            if (portValue == null) {
                return null;
            }
            if (!"".equals(portValue)) {
                try {
                    port = Integer.parseInt(portValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (password != null) {
                return new SVNSSHAuthentication(name, password, port, authMayBeStored, url, false);
            }
            if (keyFile != null) {
                return new SVNSSHAuthentication(name, keyFile, passphrase, port, authMayBeStored, url, false);
            }
            AgentProxy agentProxy = SVNSSHPrivateKeyUtil.createOptionalSSHAgentProxy();
            if (agentProxy != null) {
                return new SVNSSHAuthentication(name, agentProxy, port, url, false);
            }
            return null;
        }
        if ("svn.username".equals(kind)) {
            String name = System.getProperty("user.name");
            if (name != null && "".equals(name.trim())) {
                name = null;
            }
            if (name != null) {
                return new SVNUserNameAuthentication(name, authMayBeStored, url, false);
            }
            SVNConsoleAuthenticationProvider.printRealm(realm);
            name = SVNConsoleAuthenticationProvider.prompt(!"file".equals(url.getProtocol()) ? "Author name [" + System.getProperty("user.name") + "]" : "Username [" + System.getProperty("user.name") + "]");
            if (name == null) {
                return null;
            }
            if ("".equals(name.trim())) {
                name = System.getProperty("user.name");
            }
            return new SVNUserNameAuthentication(name, authMayBeStored, url, false);
        }
        if ("svn.ssl.client-passphrase".equals(kind)) {
            if (SVNSSLAuthentication.isCertificatePath(realm)) {
                String passphrase = SVNConsoleAuthenticationProvider.promptPassword("Passphrase for '" + realm + "'");
                if (passphrase == null) {
                    return null;
                }
                return new SVNPasswordAuthentication("", passphrase, authMayBeStored, url, false);
            }
            boolean isMSCAPI = false;
            SVNConsoleAuthenticationProvider.printRealm(realm);
            String path = null;
            while (path == null) {
                path = SVNConsoleAuthenticationProvider.prompt("Client certificate filename or 'MSCAPI'");
                if ("".equals(path)) continue;
                if (path == null) {
                    return null;
                }
                if (path.startsWith("MSCAPI")) {
                    isMSCAPI = true;
                    continue;
                }
                File file = new File(path);
                if (file.isFile() && file.canRead()) continue;
                path = null;
            }
            if (isMSCAPI) {
                String alias = SVNConsoleAuthenticationProvider.promptPassword("MSCAPI certificate alias");
                if (alias == null) {
                    return null;
                }
                if ("".equals(alias)) {
                    alias = null;
                }
                return new SVNSSLAuthentication("MSCAPI", alias, authMayBeStored, url, false);
            }
            SVNSSLAuthentication sslAuth = new SVNSSLAuthentication(new File(path), null, authMayBeStored, url, false);
            sslAuth.setCertificatePath(path);
            return sslAuth;
        }
        return null;
    }

    @Override
    public boolean canStorePlainTextPasswords(String realm, SVNAuthentication auth) throws SVNException {
        return this.isPlainTextAllowed(realm, OUR_PASSWORD_PROMPT_TEXT, OUR_PASSWORD_PROMPT_STRING);
    }

    @Override
    public boolean canStorePlainTextPassphrases(String realm, SVNAuthentication auth) throws SVNException {
        return this.isPlainTextAllowed(realm, OUR_PASSPHRASE_PROMPT_TEXT, OUR_PASSPHRASE_PROMPT_STRING);
    }

    private boolean isPlainTextAllowed(String realm, String promptText, String promptString) {
        File configPath = new File(SVNWCUtil.getDefaultConfigurationDirectory(), "servers");
        String formattedMessage = MessageFormat.format(promptText, realm, configPath.getAbsolutePath());
        System.err.print(formattedMessage);
        while (true) {
            System.err.print(promptString);
            System.err.flush();
            String answer = SVNConsoleAuthenticationProvider.readLine();
            if ("yes".equalsIgnoreCase(answer)) {
                return true;
            }
            if ("no".equalsIgnoreCase(answer)) {
                return false;
            }
            promptString = "Please type 'yes' or 'no': ";
        }
    }

    private static void printRealm(String realm) {
        if (realm != null) {
            System.err.println("Authentication realm: " + realm);
            System.err.flush();
        }
    }

    private static String prompt(String label) {
        System.err.print(label + ": ");
        System.err.flush();
        return SVNConsoleAuthenticationProvider.readLine();
    }

    private static String promptPassword(String label) {
        System.err.print(label + ": ");
        System.err.flush();
        Class<System> systemClass = System.class;
        try {
            Class<?> consoleClass;
            Method readPasswordMethod;
            Object consoleObject;
            Method consoleMethod = systemClass.getMethod("console", new Class[0]);
            if (consoleMethod != null && (consoleObject = consoleMethod.invoke(null, new Object[0])) != null && (readPasswordMethod = (consoleClass = consoleObject.getClass()).getMethod("readPassword", new Class[0])) != null) {
                Object password = readPasswordMethod.invoke(consoleObject, new Object[0]);
                if (password == null) {
                    return null;
                }
                if (password instanceof char[]) {
                    return new String((char[])password);
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return SVNConsoleAuthenticationProvider.readLine();
    }

    private static String readLine() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean isSSLPassphrasePromtSupported() {
        return true;
    }

    @Override
    public String getKeyringPassword(String keyringName) throws SVNException {
        return SVNConsoleAuthenticationProvider.promptPassword("Password for '" + keyringName + "' GNOME keyring");
    }
}

