"""add owasp model

Revision ID: 581121b181d8
Revises: 47e53ddc0308
Create Date: 2022-08-04 17:40:48.253598+00:00

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '581121b181d8'
down_revision = '47e53ddc0308'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('owasp',
    sa.Column('create_date', sa.DateTime(), nullable=True),
    sa.Column('update_date', sa.DateTime(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=False),
    sa.Column('creator_id', sa.Integer(), nullable=True),
    sa.Column('update_user_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['creator_id'], ['faraday_user.id'], ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['update_user_id'], ['faraday_user.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('owasp_vulnerability_association',
    sa.Column('owasp_id', sa.Integer(), nullable=True),
    sa.Column('vulnerability_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['owasp_id'], ['owasp.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['vulnerability_id'], ['vulnerability.id'], ondelete='CASCADE')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('owasp_vulnerability_association')
    op.drop_table('owasp')
    # ### end Alembic commands ###
