/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.storage.classes;

import eu.bibl.banalysis.asm.ClassNode;
import eu.bibl.banalysis.asm.refactor.Refactorer;
import eu.bibl.banalysis.storage.HookMap;
import eu.bibl.banalysis.storage.classes.matching.ClassMatcher;
import eu.bibl.banalysis.storage.classes.matching.FieldMatcher;
import eu.bibl.banalysis.storage.classes.matching.MethodMatcher;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassContainer {
    protected Map<String, ClassNode> nodeMap = new HashMap<String, ClassNode>();
    public final Map<URL, Map<String, byte[]>> resources = new HashMap<URL, Map<String, byte[]>>();

    public ClassContainer() {
    }

    public ClassContainer(Collection<ClassNode> nodes) {
        this();
        for (ClassNode cn : nodes) {
            this.nodeMap.put(cn.name, cn);
        }
    }

    public ClassContainer(ClassNode[] nodes) {
        this(Arrays.asList(nodes));
    }

    public Map<String, ClassNode> getNodes() {
        return this.nodeMap;
    }

    public void setNodes(Map<String, ClassNode> nodes) {
        this.nodeMap = nodes;
    }

    public void refactor(HookMap hm) {
        Refactorer rf = new Refactorer(hm, this);
        rf.run();
    }

    public void relocate(String oldName, ClassNode cn) {
        if (this.nodeMap.containsKey(oldName)) {
            this.nodeMap.remove(oldName);
        }
        this.nodeMap.put(cn.name, cn);
    }

    public void add(ClassContainer other) {
        if (other == null) {
            return;
        }
        this.nodeMap.putAll(other.getNodes());
        this.resources.putAll(other.resources);
    }

    public void addClass(ClassNode cn) {
        this.nodeMap.put(cn.name, cn);
    }

    public List<ClassNode> retrieveClasses(ClassMatcher matcher) {
        if (matcher == null) {
            return new ArrayList<ClassNode>();
        }
        return (List)matcher.match(this.nodeMap.values());
    }

    public Map<ClassNode, List<MethodNode>> retrieveMatchingMethods(ClassMatcher cMatch, MethodMatcher mMatch) {
        List<ClassNode> klasses = this.retrieveClasses(cMatch);
        if (klasses.size() == 0) {
            return new HashMap<ClassNode, List<MethodNode>>();
        }
        HashMap<ClassNode, List<MethodNode>> result = new HashMap<ClassNode, List<MethodNode>>();
        for (ClassNode cn : klasses) {
            result.put(cn, (List<MethodNode>)mMatch.match(cn));
        }
        return result;
    }

    public Map<ClassNode, List<FieldNode>> retrieveMatchingFields(ClassMatcher cMatch, FieldMatcher fMatch) {
        List<ClassNode> klasses = this.retrieveClasses(cMatch);
        if (klasses.size() == 0) {
            return new HashMap<ClassNode, List<FieldNode>>();
        }
        HashMap<ClassNode, List<FieldNode>> result = new HashMap<ClassNode, List<FieldNode>>();
        for (ClassNode cn : klasses) {
            result.put(cn, (List<FieldNode>)fMatch.match(cn));
        }
        return result;
    }
}

