/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.storage;

import eu.bibl.banalysis.storage.CallbackMappingData;
import eu.bibl.banalysis.storage.ClassMappingData;
import eu.bibl.banalysis.storage.FieldMappingData;
import eu.bibl.banalysis.storage.MappingData;
import eu.bibl.banalysis.storage.filter.CallbackMappingDataFilter;
import eu.bibl.banalysis.storage.filter.FieldMappingDataFilter;
import java.util.ArrayList;
import java.util.List;

public class HookMap {
    protected List<ClassMappingData> classes = new ArrayList<ClassMappingData>();
    protected List<FieldMappingData> fields = new ArrayList<FieldMappingData>();
    protected List<CallbackMappingData> methods = new ArrayList<CallbackMappingData>();

    public void addClass(ClassMappingData MappingData2) {
        this.classes.add(MappingData2);
    }

    public void addField(FieldMappingData field) {
        this.fields.add(field);
    }

    public void addMethod(CallbackMappingData method) {
        this.methods.add(method);
    }

    public List<ClassMappingData> getClasses() {
        return this.classes;
    }

    public MappingData getClassByObfuscatedName(String obfName) {
        for (MappingData mappingData : this.classes) {
            if (!mappingData.obfuscatedName.equals(obfName)) continue;
            return mappingData;
        }
        return null;
    }

    public MappingData getClassByRefactoredName(String refacName) {
        for (MappingData mappingData : this.classes) {
            if (!mappingData.refactoredName.equals(refacName)) continue;
            return mappingData;
        }
        return null;
    }

    public List<FieldMappingData> getFields() {
        return this.fields;
    }

    public List<FieldMappingData> getFieldsByObfuscatedFieldOwner(String obfName) {
        ArrayList<FieldMappingData> fields = new ArrayList<FieldMappingData>();
        for (FieldMappingData field : this.fields) {
            if (!field.fieldOwner.obfuscatedName.equals(obfName)) continue;
            fields.add(field);
        }
        return fields;
    }

    public List<FieldMappingData> getFieldsByRefactoredFieldOwner(String refacName) {
        ArrayList<FieldMappingData> fields = new ArrayList<FieldMappingData>();
        for (FieldMappingData field : this.fields) {
            if (!field.fieldOwner.refactoredName.equals(refacName)) continue;
            fields.add(field);
        }
        return fields;
    }

    public List<FieldMappingData> getFieldsByObfuscatedMethodOwner(String obfName) {
        ArrayList<FieldMappingData> fields = new ArrayList<FieldMappingData>();
        for (FieldMappingData field : this.fields) {
            if (!field.methodOwner.obfuscatedName.equals(obfName)) continue;
            fields.add(field);
        }
        return fields;
    }

    public List<FieldMappingData> getFieldsByRefactoredMethodOwner(String refacName) {
        ArrayList<FieldMappingData> fields = new ArrayList<FieldMappingData>();
        for (FieldMappingData field : this.fields) {
            if (!field.methodOwner.refactoredName.equals(refacName)) continue;
            fields.add(field);
        }
        return fields;
    }

    public List<CallbackMappingData> getMethods() {
        return this.methods;
    }

    public List<CallbackMappingData> getMethodsByObfuscatedFieldOwner(String obfName) {
        ArrayList<CallbackMappingData> methods = new ArrayList<CallbackMappingData>();
        for (CallbackMappingData method : this.methods) {
            if (!method.methodOwner.obfuscatedName.equals(obfName)) continue;
            methods.add(method);
        }
        return methods;
    }

    public List<CallbackMappingData> getMethodsByRefactoredFieldOwner(String refacName) {
        ArrayList<CallbackMappingData> methods = new ArrayList<CallbackMappingData>();
        for (CallbackMappingData method : this.methods) {
            if (!method.methodOwner.refactoredName.equals(refacName)) continue;
            methods.add(method);
        }
        return methods;
    }

    public List<CallbackMappingData> getMethodsByObfuscatedMethodOwner(String obfName) {
        ArrayList<CallbackMappingData> methods = new ArrayList<CallbackMappingData>();
        for (CallbackMappingData method : this.methods) {
            if (!method.callbackOwner.obfuscatedName.equals(obfName)) continue;
            methods.add(method);
        }
        return methods;
    }

    public List<CallbackMappingData> getMethodsByRefactoredMethodOwner(String refacName) {
        ArrayList<CallbackMappingData> methods = new ArrayList<CallbackMappingData>();
        for (CallbackMappingData method : this.methods) {
            if (!method.callbackOwner.refactoredName.equals(refacName)) continue;
            methods.add(method);
        }
        return methods;
    }

    public List<FieldMappingData> filterFields(FieldMappingDataFilter filter) {
        ArrayList<FieldMappingData> filteredFields = new ArrayList<FieldMappingData>();
        for (FieldMappingData data : this.fields) {
            if (!filter.accept(data)) continue;
            filteredFields.add(data);
        }
        return filteredFields;
    }

    public List<CallbackMappingData> filterMethods(CallbackMappingDataFilter filter) {
        ArrayList<CallbackMappingData> filteredMethods = new ArrayList<CallbackMappingData>();
        for (CallbackMappingData data : this.methods) {
            if (!filter.accept(data)) continue;
            filteredMethods.add(data);
        }
        return filteredMethods;
    }
}

