// FontConfig database of language orthographies.
// License: Public Domain.
// This file is autogenerated from fc-lang database.
// https://www.freedesktop.org/wiki/Software/fontconfig/
// https://gitlab.freedesktop.org/fontconfig/fontconfig/tree/master/fc-lang
// by convert utility from https://github.com/virxkane/freetype_textdraw

#include "crsetup.h"
#if USE_LOCALE_DATA==1

#include <string.h>

#include "fc-lang-data.h"

#include "files/aa_orth.c"
#include "files/ab_orth.c"
#include "files/af_orth.c"
#include "files/ak_orth.c"
#include "files/am_orth.c"
#include "files/an_orth.c"
#include "files/ar_orth.c"
#include "files/as_orth.c"
#include "files/ast_orth.c"
#include "files/av_orth.c"
#include "files/ay_orth.c"
#include "files/az_az_orth.c"
#include "files/az_ir_orth.c"
#include "files/ba_orth.c"
#include "files/be_orth.c"
#include "files/ber_dz_orth.c"
#include "files/ber_ma_orth.c"
#include "files/bg_orth.c"
#include "files/bh_orth.c"
#include "files/bho_orth.c"
#include "files/bi_orth.c"
#include "files/bin_orth.c"
#include "files/bm_orth.c"
#include "files/bn_orth.c"
#include "files/bo_orth.c"
#include "files/br_orth.c"
#include "files/brx_orth.c"
#include "files/bs_orth.c"
#include "files/bua_orth.c"
#include "files/byn_orth.c"
#include "files/ca_orth.c"
#include "files/ce_orth.c"
#include "files/ch_orth.c"
#include "files/chm_orth.c"
#include "files/chr_orth.c"
#include "files/co_orth.c"
#include "files/crh_orth.c"
#include "files/cs_orth.c"
#include "files/csb_orth.c"
#include "files/cu_orth.c"
#include "files/cv_orth.c"
#include "files/cy_orth.c"
#include "files/da_orth.c"
#include "files/de_orth.c"
#include "files/doi_orth.c"
#include "files/dv_orth.c"
#include "files/dz_orth.c"
#include "files/ee_orth.c"
#include "files/el_orth.c"
#include "files/en_orth.c"
#include "files/eo_orth.c"
#include "files/es_orth.c"
#include "files/et_orth.c"
#include "files/eu_orth.c"
#include "files/fa_orth.c"
#include "files/fat_orth.c"
#include "files/ff_orth.c"
#include "files/fi_orth.c"
#include "files/fil_orth.c"
#include "files/fj_orth.c"
#include "files/fo_orth.c"
#include "files/fr_orth.c"
#include "files/fur_orth.c"
#include "files/fy_orth.c"
#include "files/ga_orth.c"
#include "files/gd_orth.c"
#include "files/gez_orth.c"
#include "files/gl_orth.c"
#include "files/gn_orth.c"
#include "files/gu_orth.c"
#include "files/gv_orth.c"
#include "files/ha_orth.c"
#include "files/haw_orth.c"
#include "files/he_orth.c"
#include "files/hi_orth.c"
#include "files/hne_orth.c"
#include "files/ho_orth.c"
#include "files/hr_orth.c"
#include "files/hsb_orth.c"
#include "files/ht_orth.c"
#include "files/hu_orth.c"
#include "files/hy_orth.c"
#include "files/hz_orth.c"
#include "files/ia_orth.c"
#include "files/id_orth.c"
#include "files/ie_orth.c"
#include "files/ig_orth.c"
#include "files/ii_orth.c"
#include "files/ik_orth.c"
#include "files/io_orth.c"
#include "files/is_orth.c"
#include "files/it_orth.c"
#include "files/iu_orth.c"
#include "files/ja_orth.c"
#include "files/jv_orth.c"
#include "files/ka_orth.c"
#include "files/kaa_orth.c"
#include "files/kab_orth.c"
#include "files/ki_orth.c"
#include "files/kj_orth.c"
#include "files/kk_orth.c"
#include "files/kl_orth.c"
#include "files/km_orth.c"
#include "files/kn_orth.c"
#include "files/ko_orth.c"
#include "files/kok_orth.c"
#include "files/kr_orth.c"
#include "files/ks_orth.c"
#include "files/ku_am_orth.c"
#include "files/ku_iq_orth.c"
#include "files/ku_ir_orth.c"
#include "files/ku_tr_orth.c"
#include "files/kum_orth.c"
#include "files/kv_orth.c"
#include "files/kw_orth.c"
#include "files/kwm_orth.c"
#include "files/ky_orth.c"
#include "files/la_orth.c"
#include "files/lah_orth.c"
#include "files/lb_orth.c"
#include "files/lez_orth.c"
#include "files/lg_orth.c"
#include "files/li_orth.c"
#include "files/ln_orth.c"
#include "files/lo_orth.c"
#include "files/lt_orth.c"
#include "files/lv_orth.c"
#include "files/mai_orth.c"
#include "files/mg_orth.c"
#include "files/mh_orth.c"
#include "files/mi_orth.c"
#include "files/mk_orth.c"
#include "files/ml_orth.c"
#include "files/mn_cn_orth.c"
#include "files/mn_mn_orth.c"
#include "files/mni_orth.c"
#include "files/mo_orth.c"
#include "files/mr_orth.c"
#include "files/ms_orth.c"
#include "files/mt_orth.c"
#include "files/my_orth.c"
#include "files/na_orth.c"
#include "files/nb_orth.c"
#include "files/nds_orth.c"
#include "files/ne_orth.c"
#include "files/ng_orth.c"
#include "files/nl_orth.c"
#include "files/nn_orth.c"
#include "files/no_orth.c"
#include "files/nqo_orth.c"
#include "files/nr_orth.c"
#include "files/nso_orth.c"
#include "files/nv_orth.c"
#include "files/ny_orth.c"
#include "files/oc_orth.c"
#include "files/om_orth.c"
#include "files/or_orth.c"
#include "files/os_orth.c"
#include "files/ota_orth.c"
#include "files/pa_orth.c"
#include "files/pa_pk_orth.c"
#include "files/pap_an_orth.c"
#include "files/pap_aw_orth.c"
#include "files/pes_orth.c"
#include "files/pl_orth.c"
#include "files/prs_orth.c"
#include "files/ps_af_orth.c"
#include "files/ps_pk_orth.c"
#include "files/pt_orth.c"
#include "files/qu_orth.c"
#include "files/quz_orth.c"
#include "files/rm_orth.c"
#include "files/rn_orth.c"
#include "files/ro_orth.c"
#include "files/ru_orth.c"
#include "files/rw_orth.c"
#include "files/sa_orth.c"
#include "files/sah_orth.c"
#include "files/sat_orth.c"
#include "files/sc_orth.c"
#include "files/sco_orth.c"
#include "files/sd_orth.c"
#include "files/se_orth.c"
#include "files/sel_orth.c"
#include "files/sg_orth.c"
#include "files/sh_orth.c"
#include "files/shs_orth.c"
#include "files/si_orth.c"
#include "files/sid_orth.c"
#include "files/sk_orth.c"
#include "files/sl_orth.c"
#include "files/sm_orth.c"
#include "files/sma_orth.c"
#include "files/smj_orth.c"
#include "files/smn_orth.c"
#include "files/sms_orth.c"
#include "files/sn_orth.c"
#include "files/so_orth.c"
#include "files/sq_orth.c"
#include "files/sr_orth.c"
#include "files/ss_orth.c"
#include "files/st_orth.c"
#include "files/su_orth.c"
#include "files/sv_orth.c"
#include "files/sw_orth.c"
#include "files/syr_orth.c"
#include "files/ta_orth.c"
#include "files/te_orth.c"
#include "files/tg_orth.c"
#include "files/th_orth.c"
#include "files/ti_er_orth.c"
#include "files/ti_et_orth.c"
#include "files/tig_orth.c"
#include "files/tk_orth.c"
#include "files/tl_orth.c"
#include "files/tn_orth.c"
#include "files/to_orth.c"
#include "files/tr_orth.c"
#include "files/ts_orth.c"
#include "files/tt_orth.c"
#include "files/tw_orth.c"
#include "files/ty_orth.c"
#include "files/tyv_orth.c"
#include "files/ug_orth.c"
#include "files/uk_orth.c"
#include "files/und_zmth_orth.c"
#include "files/und_zsye_orth.c"
#include "files/ur_orth.c"
#include "files/uz_orth.c"
#include "files/ve_orth.c"
#include "files/vi_orth.c"
#include "files/vo_orth.c"
#include "files/vot_orth.c"
#include "files/wa_orth.c"
#include "files/wal_orth.c"
#include "files/wen_orth.c"
#include "files/wo_orth.c"
#include "files/xh_orth.c"
#include "files/yap_orth.c"
#include "files/yi_orth.c"
#include "files/yo_orth.c"
#include "files/za_orth.c"
#include "files/zh_cn_orth.c"
#include "files/zh_hk_orth.c"
#include "files/zh_mo_orth.c"
#include "files/zh_sg_orth.c"
#include "files/zh_tw_orth.c"
#include "files/zu_orth.c"

static const struct fc_lang_rec fc_lang_data[] = {
	"aa", AA_LANG_ORTH_SZ, aa_lang_orth_chars,
	"ab", AB_LANG_ORTH_SZ, ab_lang_orth_chars,
	"af", AF_LANG_ORTH_SZ, af_lang_orth_chars,
	"ak", AK_LANG_ORTH_SZ, ak_lang_orth_chars,
	"am", AM_LANG_ORTH_SZ, am_lang_orth_chars,
	"an", AN_LANG_ORTH_SZ, an_lang_orth_chars,
	"ar", AR_LANG_ORTH_SZ, ar_lang_orth_chars,
	"as", AS_LANG_ORTH_SZ, as_lang_orth_chars,
	"ast", AST_LANG_ORTH_SZ, ast_lang_orth_chars,
	"av", AV_LANG_ORTH_SZ, av_lang_orth_chars,
	"ay", AY_LANG_ORTH_SZ, ay_lang_orth_chars,
	"az_az", AZ_AZ_LANG_ORTH_SZ, az_az_lang_orth_chars,
	"az_ir", AZ_IR_LANG_ORTH_SZ, az_ir_lang_orth_chars,
	"ba", BA_LANG_ORTH_SZ, ba_lang_orth_chars,
	"be", BE_LANG_ORTH_SZ, be_lang_orth_chars,
	"ber_dz", BER_DZ_LANG_ORTH_SZ, ber_dz_lang_orth_chars,
	"ber_ma", BER_MA_LANG_ORTH_SZ, ber_ma_lang_orth_chars,
	"bg", BG_LANG_ORTH_SZ, bg_lang_orth_chars,
	"bh", BH_LANG_ORTH_SZ, bh_lang_orth_chars,
	"bho", BHO_LANG_ORTH_SZ, bho_lang_orth_chars,
	"bi", BI_LANG_ORTH_SZ, bi_lang_orth_chars,
	"bin", BIN_LANG_ORTH_SZ, bin_lang_orth_chars,
	"bm", BM_LANG_ORTH_SZ, bm_lang_orth_chars,
	"bn", BN_LANG_ORTH_SZ, bn_lang_orth_chars,
	"bo", BO_LANG_ORTH_SZ, bo_lang_orth_chars,
	"br", BR_LANG_ORTH_SZ, br_lang_orth_chars,
	"brx", BRX_LANG_ORTH_SZ, brx_lang_orth_chars,
	"bs", BS_LANG_ORTH_SZ, bs_lang_orth_chars,
	"bua", BUA_LANG_ORTH_SZ, bua_lang_orth_chars,
	"byn", BYN_LANG_ORTH_SZ, byn_lang_orth_chars,
	"ca", CA_LANG_ORTH_SZ, ca_lang_orth_chars,
	"ce", CE_LANG_ORTH_SZ, ce_lang_orth_chars,
	"ch", CH_LANG_ORTH_SZ, ch_lang_orth_chars,
	"chm", CHM_LANG_ORTH_SZ, chm_lang_orth_chars,
	"chr", CHR_LANG_ORTH_SZ, chr_lang_orth_chars,
	"co", CO_LANG_ORTH_SZ, co_lang_orth_chars,
	"crh", CRH_LANG_ORTH_SZ, crh_lang_orth_chars,
	"cs", CS_LANG_ORTH_SZ, cs_lang_orth_chars,
	"csb", CSB_LANG_ORTH_SZ, csb_lang_orth_chars,
	"cu", CU_LANG_ORTH_SZ, cu_lang_orth_chars,
	"cv", CV_LANG_ORTH_SZ, cv_lang_orth_chars,
	"cy", CY_LANG_ORTH_SZ, cy_lang_orth_chars,
	"da", DA_LANG_ORTH_SZ, da_lang_orth_chars,
	"de", DE_LANG_ORTH_SZ, de_lang_orth_chars,
	"doi", DOI_LANG_ORTH_SZ, doi_lang_orth_chars,
	"dv", DV_LANG_ORTH_SZ, dv_lang_orth_chars,
	"dz", DZ_LANG_ORTH_SZ, dz_lang_orth_chars,
	"ee", EE_LANG_ORTH_SZ, ee_lang_orth_chars,
	"el", EL_LANG_ORTH_SZ, el_lang_orth_chars,
	"en", EN_LANG_ORTH_SZ, en_lang_orth_chars,
	"eo", EO_LANG_ORTH_SZ, eo_lang_orth_chars,
	"es", ES_LANG_ORTH_SZ, es_lang_orth_chars,
	"et", ET_LANG_ORTH_SZ, et_lang_orth_chars,
	"eu", EU_LANG_ORTH_SZ, eu_lang_orth_chars,
	"fa", FA_LANG_ORTH_SZ, fa_lang_orth_chars,
	"fat", FAT_LANG_ORTH_SZ, fat_lang_orth_chars,
	"ff", FF_LANG_ORTH_SZ, ff_lang_orth_chars,
	"fi", FI_LANG_ORTH_SZ, fi_lang_orth_chars,
	"fil", FIL_LANG_ORTH_SZ, fil_lang_orth_chars,
	"fj", FJ_LANG_ORTH_SZ, fj_lang_orth_chars,
	"fo", FO_LANG_ORTH_SZ, fo_lang_orth_chars,
	"fr", FR_LANG_ORTH_SZ, fr_lang_orth_chars,
	"fur", FUR_LANG_ORTH_SZ, fur_lang_orth_chars,
	"fy", FY_LANG_ORTH_SZ, fy_lang_orth_chars,
	"ga", GA_LANG_ORTH_SZ, ga_lang_orth_chars,
	"gd", GD_LANG_ORTH_SZ, gd_lang_orth_chars,
	"gez", GEZ_LANG_ORTH_SZ, gez_lang_orth_chars,
	"gl", GL_LANG_ORTH_SZ, gl_lang_orth_chars,
	"gn", GN_LANG_ORTH_SZ, gn_lang_orth_chars,
	"gu", GU_LANG_ORTH_SZ, gu_lang_orth_chars,
	"gv", GV_LANG_ORTH_SZ, gv_lang_orth_chars,
	"ha", HA_LANG_ORTH_SZ, ha_lang_orth_chars,
	"haw", HAW_LANG_ORTH_SZ, haw_lang_orth_chars,
	"he", HE_LANG_ORTH_SZ, he_lang_orth_chars,
	"hi", HI_LANG_ORTH_SZ, hi_lang_orth_chars,
	"hne", HNE_LANG_ORTH_SZ, hne_lang_orth_chars,
	"ho", HO_LANG_ORTH_SZ, ho_lang_orth_chars,
	"hr", HR_LANG_ORTH_SZ, hr_lang_orth_chars,
	"hsb", HSB_LANG_ORTH_SZ, hsb_lang_orth_chars,
	"ht", HT_LANG_ORTH_SZ, ht_lang_orth_chars,
	"hu", HU_LANG_ORTH_SZ, hu_lang_orth_chars,
	"hy", HY_LANG_ORTH_SZ, hy_lang_orth_chars,
	"hz", HZ_LANG_ORTH_SZ, hz_lang_orth_chars,
	"ia", IA_LANG_ORTH_SZ, ia_lang_orth_chars,
	"id", ID_LANG_ORTH_SZ, id_lang_orth_chars,
	"ie", IE_LANG_ORTH_SZ, ie_lang_orth_chars,
	"ig", IG_LANG_ORTH_SZ, ig_lang_orth_chars,
	"ii", II_LANG_ORTH_SZ, ii_lang_orth_chars,
	"ik", IK_LANG_ORTH_SZ, ik_lang_orth_chars,
	"io", IO_LANG_ORTH_SZ, io_lang_orth_chars,
	"is", IS_LANG_ORTH_SZ, is_lang_orth_chars,
	"it", IT_LANG_ORTH_SZ, it_lang_orth_chars,
	"iu", IU_LANG_ORTH_SZ, iu_lang_orth_chars,
	"ja", JA_LANG_ORTH_SZ, ja_lang_orth_chars,
	"jv", JV_LANG_ORTH_SZ, jv_lang_orth_chars,
	"ka", KA_LANG_ORTH_SZ, ka_lang_orth_chars,
	"kaa", KAA_LANG_ORTH_SZ, kaa_lang_orth_chars,
	"kab", KAB_LANG_ORTH_SZ, kab_lang_orth_chars,
	"ki", KI_LANG_ORTH_SZ, ki_lang_orth_chars,
	"kj", KJ_LANG_ORTH_SZ, kj_lang_orth_chars,
	"kk", KK_LANG_ORTH_SZ, kk_lang_orth_chars,
	"kl", KL_LANG_ORTH_SZ, kl_lang_orth_chars,
	"km", KM_LANG_ORTH_SZ, km_lang_orth_chars,
	"kn", KN_LANG_ORTH_SZ, kn_lang_orth_chars,
	"ko", KO_LANG_ORTH_SZ, ko_lang_orth_chars,
	"kok", KOK_LANG_ORTH_SZ, kok_lang_orth_chars,
	"kr", KR_LANG_ORTH_SZ, kr_lang_orth_chars,
	"ks", KS_LANG_ORTH_SZ, ks_lang_orth_chars,
	"ku_am", KU_AM_LANG_ORTH_SZ, ku_am_lang_orth_chars,
	"ku_iq", KU_IQ_LANG_ORTH_SZ, ku_iq_lang_orth_chars,
	"ku_ir", KU_IR_LANG_ORTH_SZ, ku_ir_lang_orth_chars,
	"ku_tr", KU_TR_LANG_ORTH_SZ, ku_tr_lang_orth_chars,
	"kum", KUM_LANG_ORTH_SZ, kum_lang_orth_chars,
	"kv", KV_LANG_ORTH_SZ, kv_lang_orth_chars,
	"kw", KW_LANG_ORTH_SZ, kw_lang_orth_chars,
	"kwm", KWM_LANG_ORTH_SZ, kwm_lang_orth_chars,
	"ky", KY_LANG_ORTH_SZ, ky_lang_orth_chars,
	"la", LA_LANG_ORTH_SZ, la_lang_orth_chars,
	"lah", LAH_LANG_ORTH_SZ, lah_lang_orth_chars,
	"lb", LB_LANG_ORTH_SZ, lb_lang_orth_chars,
	"lez", LEZ_LANG_ORTH_SZ, lez_lang_orth_chars,
	"lg", LG_LANG_ORTH_SZ, lg_lang_orth_chars,
	"li", LI_LANG_ORTH_SZ, li_lang_orth_chars,
	"ln", LN_LANG_ORTH_SZ, ln_lang_orth_chars,
	"lo", LO_LANG_ORTH_SZ, lo_lang_orth_chars,
	"lt", LT_LANG_ORTH_SZ, lt_lang_orth_chars,
	"lv", LV_LANG_ORTH_SZ, lv_lang_orth_chars,
	"mai", MAI_LANG_ORTH_SZ, mai_lang_orth_chars,
	"mg", MG_LANG_ORTH_SZ, mg_lang_orth_chars,
	"mh", MH_LANG_ORTH_SZ, mh_lang_orth_chars,
	"mi", MI_LANG_ORTH_SZ, mi_lang_orth_chars,
	"mk", MK_LANG_ORTH_SZ, mk_lang_orth_chars,
	"ml", ML_LANG_ORTH_SZ, ml_lang_orth_chars,
	"mn_cn", MN_CN_LANG_ORTH_SZ, mn_cn_lang_orth_chars,
	"mn_mn", MN_MN_LANG_ORTH_SZ, mn_mn_lang_orth_chars,
	"mni", MNI_LANG_ORTH_SZ, mni_lang_orth_chars,
	"mo", MO_LANG_ORTH_SZ, mo_lang_orth_chars,
	"mr", MR_LANG_ORTH_SZ, mr_lang_orth_chars,
	"ms", MS_LANG_ORTH_SZ, ms_lang_orth_chars,
	"mt", MT_LANG_ORTH_SZ, mt_lang_orth_chars,
	"my", MY_LANG_ORTH_SZ, my_lang_orth_chars,
	"na", NA_LANG_ORTH_SZ, na_lang_orth_chars,
	"nb", NB_LANG_ORTH_SZ, nb_lang_orth_chars,
	"nds", NDS_LANG_ORTH_SZ, nds_lang_orth_chars,
	"ne", NE_LANG_ORTH_SZ, ne_lang_orth_chars,
	"ng", NG_LANG_ORTH_SZ, ng_lang_orth_chars,
	"nl", NL_LANG_ORTH_SZ, nl_lang_orth_chars,
	"nn", NN_LANG_ORTH_SZ, nn_lang_orth_chars,
	"no", NO_LANG_ORTH_SZ, no_lang_orth_chars,
	"nqo", NQO_LANG_ORTH_SZ, nqo_lang_orth_chars,
	"nr", NR_LANG_ORTH_SZ, nr_lang_orth_chars,
	"nso", NSO_LANG_ORTH_SZ, nso_lang_orth_chars,
	"nv", NV_LANG_ORTH_SZ, nv_lang_orth_chars,
	"ny", NY_LANG_ORTH_SZ, ny_lang_orth_chars,
	"oc", OC_LANG_ORTH_SZ, oc_lang_orth_chars,
	"om", OM_LANG_ORTH_SZ, om_lang_orth_chars,
	"or", OR_LANG_ORTH_SZ, or_lang_orth_chars,
	"os", OS_LANG_ORTH_SZ, os_lang_orth_chars,
	"ota", OTA_LANG_ORTH_SZ, ota_lang_orth_chars,
	"pa", PA_LANG_ORTH_SZ, pa_lang_orth_chars,
	"pa_pk", PA_PK_LANG_ORTH_SZ, pa_pk_lang_orth_chars,
	"pap_an", PAP_AN_LANG_ORTH_SZ, pap_an_lang_orth_chars,
	"pap_aw", PAP_AW_LANG_ORTH_SZ, pap_aw_lang_orth_chars,
	"pes", PES_LANG_ORTH_SZ, pes_lang_orth_chars,
	"pl", PL_LANG_ORTH_SZ, pl_lang_orth_chars,
	"prs", PRS_LANG_ORTH_SZ, prs_lang_orth_chars,
	"ps_af", PS_AF_LANG_ORTH_SZ, ps_af_lang_orth_chars,
	"ps_pk", PS_PK_LANG_ORTH_SZ, ps_pk_lang_orth_chars,
	"pt", PT_LANG_ORTH_SZ, pt_lang_orth_chars,
	"qu", QU_LANG_ORTH_SZ, qu_lang_orth_chars,
	"quz", QUZ_LANG_ORTH_SZ, quz_lang_orth_chars,
	"rm", RM_LANG_ORTH_SZ, rm_lang_orth_chars,
	"rn", RN_LANG_ORTH_SZ, rn_lang_orth_chars,
	"ro", RO_LANG_ORTH_SZ, ro_lang_orth_chars,
	"ru", RU_LANG_ORTH_SZ, ru_lang_orth_chars,
	"rw", RW_LANG_ORTH_SZ, rw_lang_orth_chars,
	"sa", SA_LANG_ORTH_SZ, sa_lang_orth_chars,
	"sah", SAH_LANG_ORTH_SZ, sah_lang_orth_chars,
	"sat", SAT_LANG_ORTH_SZ, sat_lang_orth_chars,
	"sc", SC_LANG_ORTH_SZ, sc_lang_orth_chars,
	"sco", SCO_LANG_ORTH_SZ, sco_lang_orth_chars,
	"sd", SD_LANG_ORTH_SZ, sd_lang_orth_chars,
	"se", SE_LANG_ORTH_SZ, se_lang_orth_chars,
	"sel", SEL_LANG_ORTH_SZ, sel_lang_orth_chars,
	"sg", SG_LANG_ORTH_SZ, sg_lang_orth_chars,
	"sh", SH_LANG_ORTH_SZ, sh_lang_orth_chars,
	"shs", SHS_LANG_ORTH_SZ, shs_lang_orth_chars,
	"si", SI_LANG_ORTH_SZ, si_lang_orth_chars,
	"sid", SID_LANG_ORTH_SZ, sid_lang_orth_chars,
	"sk", SK_LANG_ORTH_SZ, sk_lang_orth_chars,
	"sl", SL_LANG_ORTH_SZ, sl_lang_orth_chars,
	"sm", SM_LANG_ORTH_SZ, sm_lang_orth_chars,
	"sma", SMA_LANG_ORTH_SZ, sma_lang_orth_chars,
	"smj", SMJ_LANG_ORTH_SZ, smj_lang_orth_chars,
	"smn", SMN_LANG_ORTH_SZ, smn_lang_orth_chars,
	"sms", SMS_LANG_ORTH_SZ, sms_lang_orth_chars,
	"sn", SN_LANG_ORTH_SZ, sn_lang_orth_chars,
	"so", SO_LANG_ORTH_SZ, so_lang_orth_chars,
	"sq", SQ_LANG_ORTH_SZ, sq_lang_orth_chars,
	"sr", SR_LANG_ORTH_SZ, sr_lang_orth_chars,
	"ss", SS_LANG_ORTH_SZ, ss_lang_orth_chars,
	"st", ST_LANG_ORTH_SZ, st_lang_orth_chars,
	"su", SU_LANG_ORTH_SZ, su_lang_orth_chars,
	"sv", SV_LANG_ORTH_SZ, sv_lang_orth_chars,
	"sw", SW_LANG_ORTH_SZ, sw_lang_orth_chars,
	"syr", SYR_LANG_ORTH_SZ, syr_lang_orth_chars,
	"ta", TA_LANG_ORTH_SZ, ta_lang_orth_chars,
	"te", TE_LANG_ORTH_SZ, te_lang_orth_chars,
	"tg", TG_LANG_ORTH_SZ, tg_lang_orth_chars,
	"th", TH_LANG_ORTH_SZ, th_lang_orth_chars,
	"ti_er", TI_ER_LANG_ORTH_SZ, ti_er_lang_orth_chars,
	"ti_et", TI_ET_LANG_ORTH_SZ, ti_et_lang_orth_chars,
	"tig", TIG_LANG_ORTH_SZ, tig_lang_orth_chars,
	"tk", TK_LANG_ORTH_SZ, tk_lang_orth_chars,
	"tl", TL_LANG_ORTH_SZ, tl_lang_orth_chars,
	"tn", TN_LANG_ORTH_SZ, tn_lang_orth_chars,
	"to", TO_LANG_ORTH_SZ, to_lang_orth_chars,
	"tr", TR_LANG_ORTH_SZ, tr_lang_orth_chars,
	"ts", TS_LANG_ORTH_SZ, ts_lang_orth_chars,
	"tt", TT_LANG_ORTH_SZ, tt_lang_orth_chars,
	"tw", TW_LANG_ORTH_SZ, tw_lang_orth_chars,
	"ty", TY_LANG_ORTH_SZ, ty_lang_orth_chars,
	"tyv", TYV_LANG_ORTH_SZ, tyv_lang_orth_chars,
	"ug", UG_LANG_ORTH_SZ, ug_lang_orth_chars,
	"uk", UK_LANG_ORTH_SZ, uk_lang_orth_chars,
	"und_zmth", UND_ZMTH_LANG_ORTH_SZ, und_zmth_lang_orth_chars,
	"und_zsye", UND_ZSYE_LANG_ORTH_SZ, und_zsye_lang_orth_chars,
	"ur", UR_LANG_ORTH_SZ, ur_lang_orth_chars,
	"uz", UZ_LANG_ORTH_SZ, uz_lang_orth_chars,
	"ve", VE_LANG_ORTH_SZ, ve_lang_orth_chars,
	"vi", VI_LANG_ORTH_SZ, vi_lang_orth_chars,
	"vo", VO_LANG_ORTH_SZ, vo_lang_orth_chars,
	"vot", VOT_LANG_ORTH_SZ, vot_lang_orth_chars,
	"wa", WA_LANG_ORTH_SZ, wa_lang_orth_chars,
	"wal", WAL_LANG_ORTH_SZ, wal_lang_orth_chars,
	"wen", WEN_LANG_ORTH_SZ, wen_lang_orth_chars,
	"wo", WO_LANG_ORTH_SZ, wo_lang_orth_chars,
	"xh", XH_LANG_ORTH_SZ, xh_lang_orth_chars,
	"yap", YAP_LANG_ORTH_SZ, yap_lang_orth_chars,
	"yi", YI_LANG_ORTH_SZ, yi_lang_orth_chars,
	"yo", YO_LANG_ORTH_SZ, yo_lang_orth_chars,
	"za", ZA_LANG_ORTH_SZ, za_lang_orth_chars,
	"zh_cn", ZH_CN_LANG_ORTH_SZ, zh_cn_lang_orth_chars,
	"zh_hk", ZH_HK_LANG_ORTH_SZ, zh_hk_lang_orth_chars,
	"zh_mo", ZH_MO_LANG_ORTH_SZ, zh_mo_lang_orth_chars,
	"zh_sg", ZH_SG_LANG_ORTH_SZ, zh_sg_lang_orth_chars,
	"zh_tw", ZH_TW_LANG_ORTH_SZ, zh_tw_lang_orth_chars,
	"zu", ZU_LANG_ORTH_SZ, zu_lang_orth_chars,
};

const struct fc_lang_rec* get_fc_lang_data() {
	return &fc_lang_data[0];
}

unsigned int get_fc_lang_data_size() {
	return FC_LANG_DATA_SZ;
}

const struct fc_lang_rec* fc_lang_find(const char* lang_code) {
	const struct fc_lang_rec* lang_ptr = fc_lang_data;
	int i;
	int found = 0;
	for (i = 0; i < FC_LANG_DATA_SZ; i++) {
		if (strcmp(lang_ptr->lang_code, lang_code) == 0)
		{
			found = 1;
			break;
		}
	}
	if (found)
		return lang_ptr;
	return 0;
}

#endif  // USE_LOCALE_DATA==1
