/***********************************************************************
*                           xulmaker
*                        (xulmaker.js)
*                         version 0.40
************************************************************************
 *
 * Contributors:
 * ============
 *    Franklin de Graaf (franklin@xpower.com)
 *	Michael Hearn 
 *
 * Description:
 * ===========
 * xulmaker manages a nodelist that represents the XUL document being designed.
 * Each node represents a particular XUL element. (Currently only a subset of all
 * XUL elements are supported.)
 * xulmaker starts with a single node in this nodelist, the "window" node.
 *
 * To manage the target XUL document, xulmaker maintains the following views
 * of the entire target XUL document.
 *     (1) a display of the target XUL document
 *     (2) a flat list of all elements in the target XUL document
 *     (3) a hierarchal list of all elements in the target XUL document
 * In addition, xulmaker maintains:
 *      -  a panel, called the attributes inspector, that displays the
 *         attributes of the currently active (selected) element.
 *         It displays the attributes and their corresponding values.
 * The identification of the "active" element is kept in sync between all
 * three views and the Attributes Inspector panel is kept in sync to display
 * the attributes of the "active" element. 
 * (These views are coordinated through event listeners.)
 *
 * The toolbox (menubar and toolbars) is used to delete or add elements
 * to the target XUL document. Either the active element is deleted or a
 * new element is added to the active element - if the active element allows
 * for child elements.
 * 
 * Attributes may be removed, added or changed for the active element in the
 * Attributes Inspector panel. When an element is created it is created with
 * a default set of attributes and corresponding default values. New attributes
 * may be added from a popup list of available attributes according to the
 * element type (tagname) of the active element. Attribute changes and/or
 * changes to their corresponding values are reflected immediately in the display
 * of the target XUL document by updating its corresponding nodelist.
 *
 * An element is made the currently active element by selecting it in one of the
 * following viewing panels:
 *     (1) "window"
 *     (2) "xm:idtree"
 *     (3) "xm:idlist"
 * Nodes in each of these contexts are called a ddoc node, idtree node and idlist
 * node respectively. 
 *
 * API
 * ===
 * The xulmaker UI (particularly the layout) is defined in a XUL file -
 * "xulmaker.xul", which links to this (javascript) file. The XUL file may be
 * customized as long as the API to this javascript file is maintained.
 * In particular, the following elements, as identified by particular id attributes,
 * need to be included. (These are the only elements whose contents are dynamically
 * created and updated, all others remain static as defined by the XUL document.)
 *
 *     (1) "xm:ddoc"
 *         - The xul element in which we build/design our target design document
 *     (2) "xm:idtree"
 *         - The xul element in which we display a *tree* of the elements in the
 *           design document.
 *     (3) "xm:idlist"
 *         - The xul element in which we display a *list* of the elements in the
 *           design document.
 *     (4) "xm:attrlist"
 *         - The xul element in which we display the list of the attributes and their
 *           respective values for the active element.
 *     (5) "xm:availattrlist"
 *         - The element in which we display a list of all available attributes
 *           for the particular element type (tag name) of the active element.
 *     (6) "xm:attrlist-popup" and "xm:attrlist-popup-remove"
 *         - The popup menu and the remove menuitem for the selected attribute
 *
 *     Note that there is both an attributes list - attribute name and value,
 *     for the active element and an available attributes list - attribute name,
 *     for the particular element type of the active element.
 *
 * In addition, the XUL file must include the following UI elements and attributes:
 * (in order for the css style sheet styles to work)
 *     (1) The <column> element must have an id, e.g. "xm:element", and have the
 *         primary attribute set.
 *     (2) 
 *
 * The XUL file should also provide some way, usually through the menubar and toolbar,
 * but possibly through dialogs and palettes, to execute the following functions:
 *
 *     addElement("<element-type>") // added as a child of the active element
 *     deleteElement() //the active element
 *     serializeToXML()
 *
 * In addition, the CSS stylesheet refers to particular xulmaker elements - by
 * element name (type), element class and (potentially) element id. (see the CSS
 * style sheet for which ones.)
 * 
 *
 * ISSUES (bugs/problems)
 * ======
 * (1) TreeList - if buttons are added after boxes in a box, they are displayed in that order
 *     when all leaf elements should be shown before all non-leaf elements - or maybe not.
 * (2) The size of an icon as used in a column value, seems to throw off the indentation of the
 *     lines drawn between column values. (Note the skew at the grippy.)
 *     
 * NOTES
 * =====
 * (1) To add a XUL element to the palette of XUL elements,
 *     do the following:
 *     - make an array entry for elementData[]
 *     - update the addElement(), if required, to add required attributes
 *     - make an array entry for defaultAttr[], identifying default attributes -
 *       attribute name and default attribute value.
 *     - make a button entry in the toolbar(optional) (XUL file)
 *     - make a menuitem entry in the Edit menu (XUL file)
 *     - make a broadcaster entry (XUL file)
 *
 * (2) Use of "this" as a prefix in a qualified name always refers to the containing object
 *     - xulmaker, DesignDocument, ElementList, ElementTree, AttributeInspector
 * (3) We use a "xm:active" attribute to indicate the active element in the design document
 *     and we use an "active" attribute for the other panels. These attributes need to have
 *     different names in order for them to have different styles assigned to them in the
 *     the CSS stylesheet. (The panel elements may be differentiated using a class attribute
 *     but the design document may not be encumbered with a class attribute that is an
 *     artifact of xulmaker.)
 * (4) Whenever an element appears in the idlist that you didn't expect, it's probably because
 *     it didn't have the namespace ("--xulmaker-", or "xm:") prefix. (When we make an element
 *     into a comment, we also need to change the id if it starts with "--" so that it doesn't
 *     trip up the parser.)
 *
 * CHANGE LOG (for Version 0.40) 
 * ==========
 *
 * Resolved Issues
 * ---------------
 * (1) removing (deleting) elements (widgets) work
 * (2) File IO
 *
 * Enhancements
 * ------------
 * (1) Added trace facilities.
 * (2) Made the tree list work - selection here makes it the active element.
 * (3) Changed policy of selecting the active element when adding an element - it stays the same,
 *     it no longer changes to to the added element (This makes it easier to add multiple children.)
 * (4) The target XML document view is given as given as three different views as
 *     selected by tabs. <== This comment should be in the XUL file
 * (5) Added an output frame. <== This comment should be in the XUL file
 * (6) Added a toolbar and placed the menubar and the toolbar in a toolbox (this makes their grippies work)
 *     <== This comment should be in the XUL file
 * (7) Made the definition of element attribute inheritance recursive to an arbitrary level
 *     (It previously only supported one level of inheritance.)
 * (8) Added the window debug feature (using the debug attribute on the window element)
 * (9) Added small icons for each element in the tree list (not all elements yet)
 * (10) Added large icons for toolbar (not all elements yet)
 * (11) The entire IDE document is no longer searched when building (updating) the other views - we start
 *      with the <window> element (topNode) in the Design Document (ddoc).
 * TODO
 * ====
 * minor
 * -----
 * (-) display the active element in the statusbar, e.g. <box orient="vertical"> (2 children)
 * (-) xy position in statusbar should  be limited to the design document. (For performance we need to
 *     do better - respond only to the event at the right depth.)
 * (-) statusbar should be right aligned (neither "right" nor "after" seems to work.)
 * (1) not all elements have defined small icons, as used in the ElementTree, and large icons, as used
 *     in the toolbar (see TODO - major (1) )
 * (4) we should be able to change the id attribute but not be able to delete it. (Every element needs an id
 *     in the Design Document for the design process to work, but the elements in the resulting deliverable
 *     design document do not necessarily have to have ids - how do we distinguish. I suggest a naming 
 *     convention - names with the namespace "xm:" are removable ids.)
 * (5) ElementTree should have several columns. Instead of the current column, which displays id, it should
 *     display the element type and the id should be displayed in a separate column. Furthermore, we could
 *     have additional columns to display frequently occuring attributes such as "value", "label", and "flex".
 * (6) When we select the serialized tab we should automatically generate the serialized source code from the
 *     Design Document. Similarly, when we select the Design Document we should generate the node structure
 *     from the source code. This allows us to edit the source code in between times.
 *
 * also:
 *    - Attribute documentation links
 * 
 * major
 * -----
 * (1) Events should be handled better. We need to distinguish between events that are part of the design
 *     document and those that are artifacts of the design process. For example, tabpanels need to be
 *     selected to become visible, yet we select elements in the Element Explorer that are not visible
 *     in the Design Document.
 * (2) Use XML Schema for XUL documents to build the standard design elements.
 *     (We might need to convert the DTD to the XML Schema.) The XML Schema should
 *     contain all the required information, except perhaps the small and large
 *     icons corresponding to each design element (widget). (Version 0.50 ???)
 * (2) Do a better job (performance wise) to synchronize the various views.
 *     (Currently the nodelists, tree view and flat view, are rebuilt entirely
 *     from scratch when adding or deleting elements. 
 * (3) The code view of the target XUL document should be editable directly.
 * (4) Use drag and drop for adding elements (and attributes). 
 *
***********************************************************************/
if(TRACE_LOADING){ alert("Start loading: xulmaker.js"); }

var editorShell;
var XULSchema;

//======================================================================
/*
try {
	//alert("including jslib/io/" );
	//include('chrome://jslib/content/io/file.js');
	alert("including file.js" );
	include('chrome://xulmaker/content/file.js');
} catch(e) {
	alert("JSLib not loaded correctly." );
	//alert("JSLib not loaded correctly. (Exception:" + e + ")" );
}
*/
//======================================================================
function setSecurity() {
	try {
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
		//netscape.security.PrivilegeManager.enablePrivilege("UniversalFileAccess");
		netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserWrite");
		alert("Set security. ");
	} catch (e) {
		alert("Could NOT set security. " + e);
	}
}

//----------------------------------------------------------------------
// Constants
//----------------------------------------------------------------------

//const NAMESPACE = "xulmaker";
//const NAMESPACE = "xm:";


// The following are not necesarily xul file API elements - they are typically
// built dynamically by this script.
const DDOC_PREFIX = "";
const ELEMENT_TREE_ID_PREFIX = ELEMENT_TREE_ID + "-";
const ELEMENT_LIST_ID_PREFIX = ELEMENT_LIST_ID + "-";
const ATTRIBUTE_LIST_ID_PREFIX = ATTRIBUTE_LIST_ID + "-";

const DDOC_ID = NAMESPACE + "ddoc";
const ELEMENT_TREE_ID = NAMESPACE + "idtree";
const ELEMENT_LIST_ID = NAMESPACE + "idlist";
const ATTRIBUTE_LIST_ID = NAMESPACE + "attrlist";

const DESIGN_VIEW_ID = NAMESPACE + "design-view";
const CODE_VIEW_ID = NAMESPACE + "code-view";
const BROWSER_VIEW_ID = NAMESPACE + "browser-view";
const BROWSER_VIEW_NAME = BROWSER_VIEW_ID;

//----------------------------------------------------------------------
// Variables
//----------------------------------------------------------------------

var outputFrame; // Generic browser frame (used by trace to display output messages)


//======================================================================
//  xulmaker
//======================================================================
// This is the IDE


//----------------------------------------------------------------------
// xulmaker::xulmaker() (Constructor)
//----------------------------------------------------------------------
 
function xulmaker() {
const METHOD_NAME = "xulmaker::xulmaker";
trace(METHOD_NAME, "BEGIN" );

	var theDesignDocument;
	var theElementList; // formerly the idlist or flat list
	var theElementTree; //formerly the idtree;
	var theAttributeInspector;

	var xyStatusPanel;

	this.theDesignDocument = new DesignDocument();
	this.theElementList = new ElementList(this.theDesignDocument);
	this.theElementTree = new ElementTree(this.theDesignDocument);
	this.theAttributeInspector = new AttributeInspector(this.theDesignDocument);

	this.xyStatusPanel = document.getElementById(NAMESPACE + "xy-status");
	if (!this.xyStatusPanel) { alert("xyStatus panel in statusbar not found"); }

/*
	var XULSchema = new XMLSchema();
	//XULSchema.openFile("chrome://xulmaker/content/xul.xsd"); //this doesn't work yet
	XULSchema.openFile("D:\\Project Files\\mozilla\\xulmaker\\content\\xul.xsd"); //this works
*/

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::deleteElement()
//----------------------------------------------------------------------

xulmaker.prototype.deleteElement = function() {
const METHOD_NAME = "xulmaker::deleteElement";
trace(METHOD_NAME, "BEGIN" );

	element = this.theDesignDocument.deleteElement();
	this.update();

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::addElement()
//----------------------------------------------------------------------

xulmaker.prototype.addElement = function (elementType,selectAsActive) {
const METHOD_NAME = "xulmaker::addElement";
trace(METHOD_NAME, "BEGIN" );

	var element = this.theDesignDocument.addElement(elementType);
	this.update();
	if (selectAsActive) {
		var elementId = element.getAttribute("id");
		this.selectElement(elementId);
	}

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::update()
//----------------------------------------------------------------------
/** Rebuilds both the Element List (flat list) and the Element Tree (tree list).
 * (This routine is called after an add/change/delete of an element in the Design Document.)
 * select node changes the active node in the design document, idlist and idtree
**/

xulmaker.prototype.update = function() {
const METHOD_NAME = "xulmaker::update";
trace(METHOD_NAME, "BEGIN" );

	this.theElementList.update();
	this.theElementTree.update();
	this.theAttributeInspector.update(true);

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::selectElement(id)
//----------------------------------------------------------------------

xulmaker.prototype.selectElement = function(id) {
const METHOD_NAME = "xulmaker::selectElement";
trace(METHOD_NAME, "BEGIN" );

	//alert("selectElement(\"" + id + "\")");
	this.theDesignDocument.selectElement(id);
	this.theElementList.selectElement(id);
	this.theElementTree.selectElement(id);
	//this.theAttributeInspector.selectElement(id);

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::getWindow()
//----------------------------------------------------------------------

xulmaker.prototype.getWindow = function() {
	return document.getElementById(NAMESPACE + "ddoc").firstChild;
}

//----------------------------------------------------------------------
// xulmaker::saveToFilePicker()
//----------------------------------------------------------------------
// SavaAs FilePicker Dialog

xulmaker.prototype.saveToFilePicker = function() {
const METHOD_NAME = "xulmaker::saveToFilePicker";
trace(METHOD_NAME, "BEGIN" );

	if (browserMode) { setSecurity(); }
	var f = "";
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	fp.init(window, "Save to file...", nsIFilePicker.modeSave);
      fp.appendFilters(nsIFilePicker.filterXUL | nsIFilterPicker.filterXML);
      fp.appendFilter("XUL Files","*.xul");
      fp.appendFilter("All Files","*.*");
	if (fp.show() == nsIFilePicker.returnOK && fp.fileURL.spec && fp.fileURL.spec.length > 0)
			{ f = fp.fileURL.spec;}

trace(METHOD_NAME, "END" );
	return f;
}

// CHECK WHERE THE FILEPICKER FUNCTIONS ARE USED
// I DON'T BELIEVE WE NEED THEM HERE ANYMORE - DESIGNDOCUMENT DOES IT
//----------------------------------------------------------------------
// xulmaker::openFromFilePicker()
//----------------------------------------------------------------------
// Open FilePicker Dialog

xulmaker.prototype.openFromFilePicker = function() {
const METHOD_NAME = "xulmaker::openFromFilePicker";
trace(METHOD_NAME, "BEGIN" );

	if (browserMode) { setSecurity(); }
	var f = "";
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	fp.init(window, "Opening file...", nsIFilePicker.modeOpen);
      fp.appendFilters(nsIFilePicker.filterAll | nsIFilePicker.filterXUL | nsIFilePicker.filterXML);
      fp.appendFilter("XUL Files","*.xul");
      fp.appendFilter("All Files","*.*");
	if (fp.show() == nsIFilePicker.returnOK && fp.fileURL.spec && fp.fileURL.spec.length > 0)
			{ f = fp.fileURL.spec;}

trace(METHOD_NAME, "END" );
	return f;
}

//----------------------------------------------------------------------
// xulmaker::FilePicker(mode)
//----------------------------------------------------------------------
// FilePicker Dialog

xulmaker.prototype.FilePicker = function(mode) {
const METHOD_NAME = "xulmaker::FilePicker";
trace(METHOD_NAME, "BEGIN" );

	if (browserMode) { setSecurity(); }
	var f = "";
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	if (mode =="open") {
		fp.init(window, "Opening file...", nsIFilePicker.modeOpen);
	}
	if (mode=="save") {
		fp.init(window, "Saving as file...", nsIFilePicker.modeSave);
	}

	if (fp.show() == nsIFilePicker.returnOK && fp.fileURL.spec && fp.fileURL.spec.length > 0)
			{ f = fp.fileURL.spec;}

trace(METHOD_NAME, "END" );
	return f;
}

//----------------------------------------------------------------------
// xulmaker::addElementFromToolbar()
//----------------------------------------------------------------------

xulmaker.prototype.addElementFromToolbar = function() {
const METHOD_NAME = "xulmaker::addElementFromToolbar";
trace(METHOD_NAME, "BEGIN" );

	var XULelementTypeList = document.getElementById(NAMESPACE+"element-type-list");
	//alert("elementType: " + XULelementTypeList.value);
	var elementType = XULelementTypeList.value; 
	//elementType = elementType.substring(1,elementType.length-1); // strip off leading and trailing angle brackets
	//alert("elementType: " + elementType);
	var XULselectAsActive = document.getElementById(NAMESPACE+"select-as-active");
	var selectAsActive = XULselectAsActive.getAttribute("checked");
	this.addElement(elementType, selectAsActive);

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::addAttributeFromToolbar()
//----------------------------------------------------------------------

xulmaker.prototype.addAttributeFromToolbar = function() {
const METHOD_NAME = "xulmaker::addAttributeFromToolbar";
trace(METHOD_NAME, "BEGIN" );

	var XULattributeList = document.getElementById(NAMESPACE+"attribute-list");
	var attribute = XULattributeList.value; 
	var XULattributeValueList = document.getElementById(NAMESPACE+"attribute-value-list");
	var attributeValue = XULattributeValueList.value;
	//this.theDesignDocument.getActiveNode().setAttribute(attribute, attributeValue); 
	this.theAttributeInspector.addAttribute(attribute,attributeValue);

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::newFile()
//----------------------------------------------------------------------

xulmaker.prototype.newFile = function() {
const METHOD_NAME = "xulmaker::newFile";
trace(METHOD_NAME, "BEGIN" );

	// TODO: check for "dirty" flag and prompt for save first as necessary
	this.theDesignDocument.newFile();
	this.update();

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::openFile()
//----------------------------------------------------------------------

xulmaker.prototype.openFile = function() {
const METHOD_NAME = "xulmaker::openFile";
trace(METHOD_NAME, "BEGIN" );

	// TODO: check for "dirty" flag and prompt for save first as necessary
	this.theDesignDocument.openFile();
	this.update();

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::closeFile()
//----------------------------------------------------------------------

xulmaker.prototype.closeFile = function() {
const METHOD_NAME = "xulmaker::closeFile";
trace(METHOD_NAME, "BEGIN" );

	// TODO: check for "dirty" flag and prompt for save first as necessary
	this.theDesignDocument.newFile(); //close is the same as new in a single document application

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::saveFile()
//----------------------------------------------------------------------

xulmaker.prototype.saveFile = function() {
const METHOD_NAME = "xulmaker::saveFile";
trace(METHOD_NAME, "BEGIN" );

	this.theDesignDocument.saveFile();

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::saveAsFile()
//----------------------------------------------------------------------

xulmaker.prototype.saveAsFile = function() {
const METHOD_NAME = "xulmaker::saveAsFile";
trace(METHOD_NAME, "BEGIN" );

	this.theDesignDocument.saveAsFile();

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::exit()
//----------------------------------------------------------------------

xulmaker.prototype.exit = function() {
const METHOD_NAME = "xulmaker::exit";
trace(METHOD_NAME, "BEGIN" );

	// TODO: check for "dirty" flag and prompt for save first as necessary
	window.close();

trace(METHOD_NAME, "END" );
}


//----------------------------------------------------------------------
// xulmaker::onChangeElementSelection(event)
//----------------------------------------------------------------------

xulmaker.prototype.onChangeElementSelection = function(event) {
	alert("System Error:\nonChangeElementSelection:\n This event should have been directed to a particular panel, e.g. 'theElementList'.");
	// get the id of the new selection
	// (There should be an easier way of getting this.)
	var broadcaster = document.getElementById(event.target.getAttribute("element"));
	id = broadcaster.getAttribute("selection");
	alert("selection: " + id);
}


//----------------------------------------------------------------------
// xulmaker::onChangeCheckDebug(event)
//----------------------------------------------------------------------

xulmaker.prototype.onChangeCheckDebug = function(event) {
const METHOD_NAME = "xulmaker::onChangeCheckDebug";
trace(METHOD_NAME, "BEGIN" );

	var menuitemNode = event.target;
      if (menuitemNode.getAttribute("type") == "checkbox") { 
      	this.theDesignDocument.setWindowDebugMode(menuitemNode.getAttribute("checked"));
	}

trace(METHOD_NAME, "END" );
}


//----------------------------------------------------------------------
// xulmaker::updateModel()
//----------------------------------------------------------------------

xulmaker.prototype.updateModel = function() {
const METHOD_NAME = "xulmaker::updateModel";
trace(METHOD_NAME, "BEGIN" );

	var xmlCode = document.getElementById(NAMESPACE+"code-view").value;
	
		// Parse XML Code string
		if (xmlCode) {
trace(METHOD_NAME, "INFO", "xmlCode:\n" + xmlCode );
      		var aParser = new DOMParser();
			trace( "updateModel", "MSG", "Created DOMParser");
			var xmlDOM;
			try {
				xmlDOM = aParser.parseFromString( xmlCode , "text/xml" ) ;
				//xmlDOM = aParser.parseFromString( xmlCode , "application-x/xml" ) ;
				trace( "updateModel", "MSG", "Parsed the XML code string.");
			} catch (e) {
				alert(e);
			}
			
			//var sample = xmlDOM.getElementById('window1');

			//alert("window element: " + sample);  //<<<<<<<<<<<<<<<<we get a null here
			//alert("window element tagname: " + xmlDOM.getElementById('window1').tagName );

			//this.theDesignDocument.updateModel(xmlDOM);//since xmlDOM is incorrect, we won't do this just yet.
		} else {
trace(METHOD_NAME, "WARNING", "Missing " + NAMESPACE + "code-view value"  );
		}

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// xulmaker::onSelectView(view)
//----------------------------------------------------------------------

xulmaker.prototype.onSelectView = function(view) {
const METHOD_NAME = "xulmaker::onSelectView";
trace(METHOD_NAME, "BEGIN" );

	var viewElement;
	var xulCode;
	switch (view) {
	case "design":
		break;
	case "code":
		xulCode =this.serialize('ddoc');
		viewElement = document.getElementById(CODE_VIEW_ID);
		viewElement.value = xulCode;
		break;
	case "browser":
		// find output frame

var browserFrame;
var object = ""; //<<<<<<<<<<<<<<<<
var display = false;
switch (object) {
case "window":
		// The following returns a [object ChromeWindow]
		browserFrame = window.frames[BROWSER_VIEW_NAME]; // uses NAME attribute, not ID attribute!!!
		if (!browserFrame) { alert("There is no browser frame to display the browser view."); }
		if (display) {
			alert("browserFrame: " + browserFrame);
			displayProperties(listProperties(browserFrame));
		}
		break;
default:
case "element":
		// The following returns a [object XULElement]
		browserFrame = document.getElementById(BROWSER_VIEW_ID);
		if (!browserFrame) { alert("There is no browser frame to display the browser view."); }
		if (display) {
			alert("browserFrame: " + browserFrame);
			alert("browserFrame: <" + browserFrame.tagName + " id=\"" + browserFrame.getAttribute('id') + "\">");
			displayProperties(listProperties(browserFrame),"browserFrame");
			displayProperties(listProperties(browserFrame.contentWindow),"contentWindow");
		}
		break;
}

//The following are some hacked browserFrame solutions (only "html" and "current" works)
var codeversion = ""; //<<<<<<<<<<<<<<<<
switch (codeversion) {
case "xml":

		//But we can't "write" XML code (Use of .document requires ChromeWindow)
		//xulCode = this.serialize('ddoc');
		xulCode = '<window xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul">';
		xulCode += '\n<toolbox id="toolbox0">';
		xulCode += '\n<menubar>';
		xulCode += '\n<menu label="File"/>';
		xulCode += '\n<menu label="Edit"/>';
		xulCode += '\n</menubar>';
		xulCode += '\n</toolbox>';
		xulCode += '\n</window>';
		alert("xulCode:\n" + xulCode);

		displayProperties(listProperties(browserFrame.document));
		alert("contentType=\"" + browserFrame.document.contentType + "\""); // its "text/html"
		//browserFrame.document.contentType = "text/xml"; //<<<< WE NEED TO BE ABLE TO SET THIS!!!!!
		//alert("contentType=\"" + browserFrame.document.contentType + "\"");
		//browserFrame.document.open();
		browserFrame.document.open("chrome://xulmaker/content/samples/empty.xul");
		alert("contentType=\"" + browserFrame.document.contentType + "\"");
		//browserFrame.document.write('<?xml version="1.0"?>');
		//browserFrame.document.write('<?xml-stylesheet href="chrome://global/skin" type="text/css"?>');
		//browserFrame.document.write('<?xml-stylesheet href="chrome://xulmaker/content/xulmaker.css" type="text/css"?>');
		browserFrame.document.write(xulCode);
		browserFrame.document.close();
		break;
case "import": //(Use of .document requires ChromeWindow)
		alert("topNode: " + this.theDesignDocument.topNode.tagName);
		browserFrame.document.importNode(this.theDesignDocument.topNode,true);
		break;
case "doc": //(Use of .document requires ChromeWindow)
		var doc = document.implementation.createDocument("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul","window",null);
		var label = document.createElement("label");
		label.setAttribute("value","Hello");
		doc.appendChild(label);
		browserFrame.document = doc;
		break;
default:
case "file":
		var message = "We have been unable to get the browser view to be assigned dynamically to XML/XUL code.";
		message += "\nIn the meantime you need to save your file to view it here.";
		message += "\n(Opening or saving identifies your file to the browser.)";
		alert(message);
		var filename = this.theDesignDocument.fileName;
		//alert("filename: " + filename);
		if (filename) {
			browserFrame.loadURI(filename);
			//browserFrame.document.window.setAttribute("style","background:white");//doesn't work
			//browserFrame.document.window.style="background:white";//doesn't work
			//browserFrame.document.getElementById("window").setAttribute("style","background:white");//doesn't work
		} else {
			alert("Document hasn't been opened or saved yet.\nYou need to save the document so that the browser knows the file name.");
		}
		break;
case "html":
		// We can "write" HTML code (to a ChromeWindow but not a XULElement)(Use of .document requires ChromeWindow)
		var htmlCode = '<HTML><BODY><H1>Browser View</H1>';
		htmlCode += '<P>The &lt;browser&gt; element can display either HTML or XML/XUL code - using the "src" attribute.</P>';
		htmlCode += '<P>It can also display HTML code - using a document.write()</P>';
		htmlCode += '<P>But it is NOT able to display XML/XUL code - using a document.write()</P>';
		htmlCode += '</BODY></HTML>';
		browserFrame.document.open();
		browserFrame.document.write(htmlCode);
		browserFrame.document.close();
}
		break;
	default:
	}

trace(METHOD_NAME, "END" );
}


//----------------------------------------------------------------------
// xulmaker::onSelectXULPlanet(view)
//----------------------------------------------------------------------

xulmaker.prototype.onSelectXULPlanet = function(view) {
const METHOD_NAME = "xulmaker::onSelectXULPlanet";
trace(METHOD_NAME, "BEGIN" );
	var viewElement;
	var filename;
	switch (view) {
	default:
	case "home":
//alert("XULPlanet - home");
		viewElement=document.getElementById(NAMESPACE+"xulplanet");
		filename="http://www.xulplanet.com";
		break;
	case "quickref":
//alert("XULPlanet - quickref");
		viewElement=document.getElementById(NAMESPACE+"xulplanet-quickref");
		filename="http://www.xulplanet.com/references/elemref/quickref.html";
		break;
	}
	var browserFrame = viewElement.contentWindow;
//alert("browserFrame: " + browserFrame);
	browserFrame.loadURI(filename);

trace(METHOD_NAME, "END" );
}


//----------------------------------------------------------------------
// xulmaker::onMouseMove(event)
//----------------------------------------------------------------------

xulmaker.prototype.onMouseMove = function(event) {
	//var textNode = document.createTextNode("<" + event.currentTarget.tagName + ">  " + event.clientX + ", " + event.clientY);
	//this.xyStatusNode.removeChild(xyStatusNode.firstChild);
	//this.xyStatusNode.appendChild(textNode);
	this.xyStatusPanel.label = "<" + event.target.tagName + ">  " + event.clientX + ", " + event.clientY;
}


//----------------------------------------------------------------------
// xulmaker::serialize(view)
//----------------------------------------------------------------------

xulmaker.prototype.serialize = function(view) {
const METHOD_NAME = "xulmaker::serialize";
trace(METHOD_NAME, "BEGIN" );
trace(METHOD_NAME, "INFO", "view=" + view);

	var topNode;
	var topNodeTagName;
	switch (view) {
	case "idtree":
		topNode = document.getElementById(ELEMENT_TREE_ID);
		topNodeTagName = "tree";
		break;
	case "idlist":
		topNode = document.getElementById(ELEMENT_LIST_ID);
		topNodeTagName = "grid";
		break;
	case "ddoc":
		topNode = document.getElementById(DESIGN_VIEW_ID);
		topNodeTagName = "window";
		break;
	}
	trace("serialize", "MSG", "topNode: " + topNode.tagName);
	// Get the real top node - this may be only its container
	if (topNode.tagName != topNodeTagName) {
		if (topNode.hasChildNodes) {
			var nodelist = topNode.childNodes;
			for (var i=0; i<nodelist.length; i++) {
				var elementName = nodelist[i].tagName;
				elementName = elementName.substring(elementName.indexOf(":")+1, elementName.length); // strip off leading namespace
				if (elementName==topNodeTagName) {
					topNode=nodelist[i];
					break;
				}
			}
		}
	}

	var doc = document.implementation.createDocument("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",topNodeTagName,null);
//doc.prefix = "b0";//this clobers the serialization
	//var newlineNode = document.createTextNode(" \n\r"); //we no longer add whitespace here - its done directly in the document
	//doc.documentElement.appendChild(newlineNode);
	//this for loop is redundant since we do a deep copy of each of the children and there is only one child.
	// why are we copying at all, just serialize the fragment
	for (var i = 0; i < topNode.childNodes.length; i++) {
		//doc.documentElement.appendChild(newlineNode);
  		copyNodeToDoc(topNode.childNodes.item(i),doc);
		//doc.documentElement.appendChild(newlineNode);
	}
	var serializer = new XMLSerializer();
	var s = serializer.serializeToString(doc);

trace(METHOD_NAME, "END" );
	return s;
}
//======================================================================
//End of xulmaker

// ********************* DOM Manipulation routines ****************************


function documentToNodeList(doc) {
	return doc.getElementsByTagName("*");
}

function getNodesIDList(nodelist) {

	data = new Array();
	nextindex = 0;
	for (i=0; i < nodelist.length; i++) {
		// check that the node is an element with an id attribute
		if ((nodelist.item(i).nodeType == 1) && (nodelist.item(i).hasAttribute("id") == true)) {
			//ignore ide tags (Note that this is called from the Debug menu as "getNodesIDList(document)"
                  //alert("nodelist.item(" + i + ")=\"" + nodelist.item(i).getAttribute("id") + "\""); 
			if (nodelist.item(i).getAttribute("id").slice(0,NAMESPACE.length) != NAMESPACE + "") {
				data[nextindex] = nodelist.item(i).getAttribute("id");
	                  //alert("nodelist.item(" + i + ")=\"" + nodelist.item(i).getAttribute("id") + "\""); 
				nextindex++;
			}
		}
	}

      //alert("data IDList contains " + data.length + " elements.");
	return data;
}

function isIDUnique(id) {
	var nodes = getNodesIDList(documentToNodeList(document));
	unique = true;
	for (i=0; i < nodes.length; i++) {
		if (nodes[i] == id) {
			unique = false;
			break;
		}
	}
	return unique;
}

function copyDocToNode(doc,node) {
	// this function copies the contents of the doc into the node
	node.appendChild(doc.documentElement.cloneNode(true));
}

function copyNodeToDoc(node,doc) {
	var newlineNode = document.createTextNode("\n\r");
	doc.documentElement.appendChild(newlineNode);
	doc.documentElement.appendChild(node.cloneNode(true));
	doc.documentElement.appendChild(newlineNode);
	return doc;
}

//----------------------------------------------------------------------
// Init()
//----------------------------------------------------------------------

function Init() {
	traceInit(); //Initialize tracing (must happen before any trace statements)
const METHOD_NAME = "Init";
trace(METHOD_NAME, "BEGIN" );

	window.title = "xulmaker v"+VERSION;
	xm = new xulmaker(); //makes theDesignDocument, theElementList, theElementTree and theAttributeInspector

trace(METHOD_NAME, "END" );
}
/***********************************************************************
if(TRACE_LOADING){ alert("Continuing loading: xulmaker.js"); }
***********************************************************************/
if(TRACE_LOADING){ alert("Finish loading: xulmaker.js"); }
