/*
Version: MPL 1.1/GPL 2.0

The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/. 

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is TeleKast.

The Initial Developer of the Original Code is Greg Marine.
Portions created by the Initial Developer are Copyright (C) 2006-2007
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms
of the GNU General Public License version 2 or above (the  "GPL License"),
in which case the provisions of the GPL License are applicable instead of
those above. If you wish to allow use of your version of this file only
under the terms of the GPL License and not to allow others to use
your version of this file under the MPL, indicate your decision by
deleting the provisions above and replace them with the notice and
other provisions required by the GPL License. If you do not delete
the provisions above, a recipient may use your version of this file
under either the MPL or the GPL License.
*/

// TeleKast Utilities JavaScript

// Variables
var strTeleprompterPath;
var strTeleprompterStylesheetPath;
var strTeleprompterJSPath;
var strStylesheetPath;
var strSegmentPreviewPath;
var strPrintDocument;
var strScriptPath;
var blnScriptSaved;
var blnWebImport;
var blnWebFirstCompile;
var strKioskDocPath;
var blnKioskDocSaved;
var blnKioskImport;
var blnKioskFirstCompile;
var strTeleKast;
var objSystem;
var objDirUtils;
var objFileUtils;
var Prompts;
var objPrefs;
var intClipAutoRefresh;
var intClipAutoRefreshCounter;
var intNotifications;

// jslib Includes
include('chrome://jslib/content/io/dir.js');
include('chrome://jslib/content/io/dirUtils.js');
include('chrome://jslib/content/io/file.js');
include('chrome://jslib/content/io/fileUtils.js');
include('chrome://jslib/content/utils/system.js');
include('chrome://jslib/content/utils/date.js');

// Initialize
function init()
{
    // Initialize variables.
    strTeleKast = Element("TeleKastProperties").getString("TELEKAST_FILES");
    objSystem = new System;
    objDirUtils = new DirUtils;
    objFileUtils = new FileUtils;
    Prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
    intClipAutoRefreshCounter = 0;
    objPrefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
    CreateDefaultPrefs();
}

// Creates default preferences that the user can change later.
function CreateDefaultPrefs()
{
    // Folder Paths
    try
    {
        objPrefs.getCharPref("telekast.folders.filepath");
    }
    catch(e)
    {
        objPrefs.setCharPref("telekast.folders.filepath", objDirUtils.getHomeDir() + objSystem.separator + strTeleKast);
    }
    
    // Kiosk Editor
    try
    {
        objPrefs.getIntPref("telekast.kioskeditor.delay");
    }
    catch(e)
    {
        objPrefs.setIntPref("telekast.kioskeditor.delay", 10);
    }
    
    try
    {
        objPrefs.getIntPref("telekast.kioskeditor.fontsize");
    }
    catch(e)
    {
        objPrefs.setIntPref("telekast.kioskeditor.fontsize", 72);
    }
    
    try
    {
        objPrefs.getCharPref("telekast.kioskeditor.forecolor");
    }
    catch(e)
    {
        objPrefs.setCharPref("telekast.kioskeditor.forecolor", "#000000");
    }
    
    try
    {
        objPrefs.getCharPref("telekast.kioskeditor.bgcolor");
    }
    catch(e)
    {
        objPrefs.setCharPref("telekast.kioskeditor.bgcolor", "#ffffff");
    }
    
    try
    {
        objPrefs.getCharPref("telekast.folders.kefilepath");
    }
    catch(e)
    {
        objPrefs.setCharPref("telekast.folders.kefilepath", objDirUtils.getHomeDir() + objSystem.separator + strTeleKast);
    }

    // Web Editor
    try
    {
        objPrefs.getCharPref("telekast.webeditor.templatepath");
    }
    catch(e)
    {
        objPrefs.setCharPref("telekast.webeditor.templatepath", objDirUtils.getHomeDir() + objSystem.separator + strTeleKast + objSystem.separator + "web_editor_template.html");
        CreateDefaultWebEditorTemplate();
    }
    
    try
    {
        objPrefs.getCharPref("telekast.webeditor.imagespath");
    }
    catch(e)
    {
        objPrefs.setCharPref("telekast.webeditor.imagespath", objDirUtils.getHomeDir() + objSystem.separator + strTeleKast);
    }

    try
    {
        objPrefs.getCharPref("telekast.folders.wefilepath");
    }
    catch(e)
    {
        objPrefs.setCharPref("telekast.folders.wefilepath", objDirUtils.getHomeDir() + objSystem.separator + strTeleKast);
    }

    // Segment Clip
    try
    {
        objPrefs.getCharPref("telekast.folders.clippath");
    }
    catch(e)
    {
        objPrefs.setCharPref("telekast.folders.clippath", objDirUtils.getHomeDir() + objSystem.separator + strTeleKast);
    }
    
    try
    {
        objPrefs.getBoolPref("telekast.clip.autorefresh");
    }
    catch(e)
    {
        objPrefs.setBoolPref("telekast.clip.autorefresh", true);
    }
    
    try
    {
        objPrefs.getIntPref("telekast.clip.autorefresh.delay");
    }
    catch(e)
    {
        objPrefs.setIntPref("telekast.clip.autorefresh.delay", "15");
    }
    
    // Teleprompter
    try
    {
        objPrefs.getCharPref("telekast.teleprompter.bgcolor");
    }
    catch(e)
    {
        objPrefs.setCharPref("telekast.teleprompter.bgcolor", "#000000");
    }
    
    try
    {
        objPrefs.getCharPref("telekast.teleprompter.forecolor");
    }
    catch(e)
    {
        objPrefs.setCharPref("telekast.teleprompter.forecolor", "#ffffff");
    }
    
    try
    {
        objPrefs.getCharPref("telekast.teleprompter.segnumcolor");
    }
    catch(e)
    {
        objPrefs.setCharPref("telekast.teleprompter.segnumcolor", "#333333");
    }
    
    try
    {
        objPrefs.getIntPref("telekast.teleprompter.defaultspeed");
    }
    catch(e)
    {
        objPrefs.setIntPref("telekast.teleprompter.defaultspeed", 4);
    }
    
    try
    {
        objPrefs.getIntPref("telekast.teleprompter.textsize");
    }
    catch(e)
    {
        objPrefs.setIntPref("telekast.teleprompter.textsize", 120);
    }
}

// Creates .telekast in the user folder.
function CreateDefaultFolder()
{
    // User's .telekast Folder
    var objDir = new Dir(objDirUtils.getHomeDir() + objSystem.separator + strTeleKast);
    if (!objDir.exists())
    {
        objDir.create();
        
        CreateEmptySegmentClip();
        
        CreateDefaultWebEditorTemplate();
    }
}

// Creates the stylesheet for the segment preview.
function CreatePreviewStyleSheet()
{
    

    var f = new File(strStylesheetPath);
    if(f.exists())
    {
        f.remove();
    }

    // Create CSS for segment preview.
    var strCSS = "body {font-family: Arial; background-color: " + objPrefs.getCharPref("telekast.teleprompter.bgcolor") + "; color: " + objPrefs.getCharPref("telekast.teleprompter.forecolor") + ";}"
    
    // Create new file to put stylesheet in.
    f.open("w");
    f.write(strCSS);
    f.close();
}

// Creates the default blank segment preview page.
function CreateBlankPreview()
{
    var f = new File(strSegmentPreviewPath);
    if(f.exists())
    {
        f.remove();
    }

    // Create HTML document for default blank segment preview page.
    var strHTML = "<html>\r\n";
    strHTML += "  <head>\r\n";
    strHTML += "    <title>Blank</title>\r\n";
    strHTML += "    <link rel=\"stylesheet\" type=\"text/css\" href=\"segment_preview.css\" title=\"Default\" />\r\n";
    strHTML += "  </head>\r\n";
    strHTML += "  <body>\r\n";
    strHTML += "  </body>\r\n";
    strHTML += "</html>";
    
    // Create new file to put HTML in.
    f.open("w");
    f.write(strHTML);
    f.close();
}

// Creates the teleprompter file.
function CreateTeleprompterFile()
{
    var f = new File(strTeleprompterPath);
    if(f.exists())
    {
        f.remove();
    }
    // Create HTML document for the teleprompter.
    var strHTML = "<html>\r\n";
    strHTML += "  <head>\r\n";
    strHTML += "      <title>Teleprompter</title>\r\n";
    strHTML += "      <link rel=\"stylesheet\" type=\"text/css\" href=\"teleprompter.css\" title=\"Default\" />\r\n";
    strHTML += "      <script type=\"application/javascript\" src=\"teleprompter.js\" />\r\n";
    strHTML += "  </head>\r\n";
    strHTML += "  <body onload=\"Startup();\">\r\n";
    strHTML += "      <div id=\"ScriptContainer\" class=\"cssScriptContainer\">\r\n";
    strHTML += "          <div id=\"ScriptSegments\" class=\"cssScriptSegments\">\r\n";
    var segments = Element("lstScript");
    for(var i=0; i<segments.getRowCount(); i++)
    {
        segment = segments.getItemAtIndex(i).value.split("|");
        strHTML += "              <span class=\"cssSegmentNumbers\">" + (i + 1) + "</span><br />"
        strHTML += "              " + segment[1] + "<br />\r\n";
    }
    strHTML += "          </div>\r\n";
    strHTML += "      </div>\r\n";
    strHTML += "  </body>\r\n";
    strHTML += "</html>";
    
    // Create new file to put HTML in.
    f.open("w");
    f.write(strHTML);
    f.close();
}

// Creates the teleprompter stylesheet.
function CreateTeleprompterStylesheet()
{
    

    var f = new File(strTeleprompterStylesheetPath);
    if(f.exists())
    {
        f.remove();
    }

    // Create CSS for teleprompter.
    var strCSS = "body {background-color: " + objPrefs.getCharPref("telekast.teleprompter.bgcolor") + ";}\r\n"
    strCSS += ".cssScriptContainer {position: absolute; top: 0px; left: 0px; width: 100%; height: 100%; overflow: hidden;}\r\n";
    strCSS += ".cssScriptSegments {position: absolute; top: 0px; left: 0px; color: " + objPrefs.getCharPref("telekast.teleprompter.forecolor") + "; font-size: " + objPrefs.getIntPref("telekast.teleprompter.textsize") + "pt; font-weight: bold; font-family: Arial;}\r\n";
    strCSS += ".cssSegmentNumbers {color: " + objPrefs.getCharPref("telekast.teleprompter.segnumcolor") + "; font-size: " + objPrefs.getIntPref("telekast.teleprompter.textsize") + "pt;}";

    // Create new file to put stylesheet in.
    f.open("w");
    f.write(strCSS);
    f.close();
}

// Creates the teleprompter JavaScript
function CreateTeleprompterJS()
{
    

    var f = new File(strTeleprompterJSPath);
    if(f.exists())
    {
        f.remove();
    }

    var strJS = "var intCurrentTop = 0;\r\n";
    strJS += "var intInterval = " + objPrefs.getIntPref("telekast.teleprompter.defaultspeed") + ";\r\n";
    strJS += "var blnScrolling = false;\r\n";
    strJS += "function Element(id)\r\n";
    strJS += "{\r\n";
    strJS += "    return document.getElementById(id);\r\n";
    strJS += "}\r\n";
    strJS += "function Startup()\r\n";
    strJS += "{\r\n";
    strJS += "    this.onkeypress = OnKeyPress;\r\n";
    strJS += "    this.onkeyup = OnKeyUp;\r\n";
    strJS += "}\r\n";
    strJS += "function OnKeyPress(key)\r\n";
    strJS += "{\r\n";
    strJS += "    if (!key)\r\n";
    strJS += "    {\r\n";
    strJS += "        key = event;\r\n";
    strJS += "    }\r\n";
    strJS += "    // alert(key.keyCode);\r\n";
    strJS += "    switch (key.keyCode)\r\n";
    strJS += "    {\r\n";
    strJS += "        case 27: // escape\r\n";
    strJS += "            window.close();\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 13: // enter\r\n";
    strJS += "            if (blnScrolling)\r\n";
    strJS += "            {\r\n";
    strJS += "                blnScrolling = false;\r\n";
    strJS += "            }\r\n";
    strJS += "            else\r\n";
    strJS += "            {\r\n";
    strJS += "                blnScrolling = true;\r\n";
    strJS += "                DoScroll();\r\n";
    strJS += "            }\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 33: // page up\r\n";
    strJS += "            blnScrolling = false;\r\n";
    strJS += "            intCurrentTop -= 768;\r\n";
    strJS += "            Element(\"ScriptSegments\").style.top = intCurrentTop + \"px\";\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 34: // page down\r\n";
    strJS += "            blnScrolling = false;\r\n";
    strJS += "            intCurrentTop += 768;\r\n";
    strJS += "            Element(\"ScriptSegments\").style.top = intCurrentTop + \"px\";\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 37: // left arrow\r\n";
    strJS += "            if (intInterval > -9)\r\n";
    strJS += "                intInterval -= 1;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 38: // up arrow\r\n";
    strJS += "            blnScrolling = false;\r\n";
    strJS += "            intCurrentTop -= 50;\r\n";
    strJS += "            Element(\"ScriptSegments\").style.top = intCurrentTop + \"px\";\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 39: // right arrow\r\n";
    strJS += "            if (intInterval < 9)\r\n";
    strJS += "                intInterval += 1;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 40: // down arrow\r\n";
    strJS += "            blnScrolling = false;\r\n";
    strJS += "            intCurrentTop += 50;\r\n";
    strJS += "            Element(\"ScriptSegments\").style.top = intCurrentTop + \"px\";\r\n";
    strJS += "            break;\r\n";
    strJS += "    }\r\n";
    strJS += "}\r\n";
    strJS += "function OnKeyUp(key)\r\n";
    strJS += "{\r\n";
    strJS += "    if (!key)\r\n";
    strJS += "    {\r\n";
    strJS += "        key = event;\r\n";
    strJS += "    }\r\n";
    strJS += "    // alert(key.keyCode);\r\n";
    strJS += "    switch (key.keyCode)\r\n";
    strJS += "    {\r\n";
    strJS += "        case 32: // spacebar\r\n";
    strJS += "            if (blnScrolling)\r\n";
    strJS += "            {\r\n";
    strJS += "                blnScrolling = false;\r\n";
    strJS += "            }\r\n";
    strJS += "            else\r\n";
    strJS += "            {\r\n";
    strJS += "                blnScrolling = true;\r\n";
    strJS += "                DoScroll();\r\n";
    strJS += "            }\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 48: // 0\r\n";
    strJS += "        case 96: // 0\r\n";
    strJS += "            blnScrolling = false;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 49: // 1\r\n";
    strJS += "        case 97: // 1\r\n";
    strJS += "            intInterval = 1;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 50: // 2\r\n";
    strJS += "        case 98: // 2\r\n";
    strJS += "            intInterval = 2;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 51: // 3\r\n";
    strJS += "        case 99: // 3\r\n";
    strJS += "            intInterval = 3;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 52: // 4\r\n";
    strJS += "        case 100: // 4\r\n";
    strJS += "            intInterval = 4;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 53: // 5\r\n";
    strJS += "        case 101: // 5\r\n";
    strJS += "            intInterval = 5;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 54: // 6\r\n";
    strJS += "        case 102: // 6\r\n";
    strJS += "            intInterval = 6;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 55: // 7\r\n";
    strJS += "        case 103: // 7\r\n";
    strJS += "            intInterval = 7;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 56: // 8\r\n";
    strJS += "        case 104: // 8\r\n";
    strJS += "            intInterval = 8;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 57: // 9\r\n";
    strJS += "        case 105: // 9\r\n";
    strJS += "            intInterval = 9;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 61: // plus\r\n";
    strJS += "        case 107: // plus\r\n";
    strJS += "            if(intInterval < 0)\r\n";
    strJS += "              intInterval *= -1;\r\n";
    strJS += "            break;\r\n";
    strJS += "        case 109: // minus\r\n";
    strJS += "            if(intInterval > 0)\r\n";
    strJS += "              intInterval *= -1;\r\n";
    strJS += "            break;\r\n";
    strJS += "    }\r\n";
    strJS += "}\r\n";
    strJS += "function DoScroll()\r\n";
    strJS += "{\r\n";
    strJS += "    setTimeout(\"Scroll();\", 1);\r\n";
    strJS += "}\r\n";
    strJS += "function Scroll()\r\n";
    strJS += "{\r\n";
    strJS += "    intCurrentTop -= intInterval;\r\n";
    strJS += "    Element(\"ScriptSegments\").style.top = intCurrentTop + \"px\";\r\n";
    strJS += "    if (blnScrolling) DoScroll();\r\n";
    strJS += "}";
    
    // Create new file to put JavaScript in.
    f.open("w");
    f.write(strJS);
    f.close();
}

// Creates the default empty segment clip.
function CreateEmptySegmentClip()
{
    var f = new File(objDirUtils.getHomeDir() + objSystem.separator + strTeleKast + objSystem.separator + "segmentclip.xml");
    if(f.exists())
    {
        f.remove();
    }
 
    var clip = "﻿<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n";
    clip += "<segmentclip>\r\n";
    clip += "</segmentclip>";
    
    if(f.exists())
    {
        f.remove();
    }
    f.open("w");
    f.write(clip);
    f.close();
}

// Creates the default Web Editor template.
function CreateDefaultWebEditorTemplate()
{
    var f = new File(objPrefs.getCharPref("telekast.webeditor.templatepath"));
    if(f.exists())
    {
        f.remove();
    }
    
    // Create HTML document for the Web Editor default template.
    var strHTML = "<html>\r\n";
    strHTML += "<head>\r\n";
    strHTML += "<title></title>\r\n";
    strHTML += "</head>\r\n";
    strHTML += "<body>\r\n";
    strHTML += "<center><h1>[we-title]</h1></center>\r\n";
    strHTML += "[we-news]\r\n";
    strHTML += "</body>\r\n";
    strHTML += "</html>";
    
    // Create new file to put HTML in.
    f.open("w");
    f.write(strHTML);
    f.close();
}

// Creates the default Kiosk Editor template.
function CreateDefaultKioskEditorTemplate()
{
    var f = new File(objDirUtils.getHomeDir() + objSystem.separator + strTeleKast + objSystem.separator + "ketemp.html");
    if(f.exists())
    {
        f.remove();
    }
    
    // Create HTML document for the Web Editor default template.
    var strHTML = "<html>\r\n";
    strHTML += "<head>\r\n";
    strHTML += "<title></title>\r\n";
    strHTML += "</head>\r\n";
    strHTML += "<body>\r\n";
    strHTML += "<!-- Place any HTML in this file to build a custom Kiosk Template -->\r\n"
    strHTML += "<center><h1>[we-title]</h1></center>\r\n";
    strHTML += "[we-news]\r\n";
    strHTML += "</body>\r\n";
    strHTML += "</html>";
    
    // Create new file to put HTML in.
    f.open("w");
    f.write(strHTML);
    f.close();
}

// Initializes a "Save As" dialog and returns a file path.
function SaveScriptAsPrompt()
{
    var strDefaultFolder = objPrefs.getCharPref("telekast.folders.filepath");
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance();
    dir.QueryInterface(Components.interfaces.nsILocalFile);
    dir.initWithPath(strDefaultFolder);
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, Element("TeleKastProperties").getString("TELEKAST_SAVE_AS"), nsIFilePicker.modeSave);
    fp.appendFilters(nsIFilePicker.filterXML);
    fp.displayDirectory = dir;
    var r = fp.show();
    if (r == nsIFilePicker.returnOK || r == nsIFilePicker.returnReplace)
    {
        objPrefs.setCharPref("telekast.folders.filepath", fp.file.path.substring(0, fp.file.path.lastIndexOf(objSystem.separator)));
        path = fp.file.path;
        if(path.indexOf(".xml") == -1)
        {
            path += ".xml";
        }
        return path;
    }
    else
    {
        return null;
    }
}

// Initializes a "Save As" dialog and returns a file path.
function ExportWebDocAsPrompt()
{
    var strDefaultFolder = objPrefs.getCharPref("telekast.folders.wefilepath");
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance();
    dir.QueryInterface(Components.interfaces.nsILocalFile);
    dir.initWithPath(strDefaultFolder);
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, Element("TeleKastProperties").getString("TELEKAST_SAVE_AS"), nsIFilePicker.modeSave);
    fp.appendFilters(nsIFilePicker.filterHTML);
    fp.displayDirectory = dir;
    var r = fp.show();
    if (r == nsIFilePicker.returnOK || r == nsIFilePicker.returnReplace)
    {
        objPrefs.setCharPref("telekast.folders.wefilepath", fp.file.path.substring(0, fp.file.path.lastIndexOf(objSystem.separator)));
        path = fp.file.path;
        if(path.indexOf(".html") == -1)
        {
            path += ".html";
        }
        return path;
    }
    else
    {
        return null;
    }
}

// Initializes a "Open" dialog and returns a file path.
function OpenScriptPrompt()
{
    var strDefaultFolder = objPrefs.getCharPref("telekast.folders.filepath");
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance();
    dir.QueryInterface(Components.interfaces.nsILocalFile);
    dir.initWithPath(strDefaultFolder);
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, Element("TeleKastProperties").getString("TELEKAST_OPEN"), nsIFilePicker.modeOpen);
    fp.appendFilters(nsIFilePicker.filterXML);
    fp.displayDirectory = dir;
    var r = fp.show();
    if (r == nsIFilePicker.returnOK)
    {
        objPrefs.setCharPref("telekast.folders.filepath", fp.file.path.substring(0, fp.file.path.lastIndexOf(objSystem.separator)));
        return fp.file.path;
    }
    else
    {
        return null;
    }

}

// Initializes a "Open Folder" dialog and moves the clip to the new folder if there isn't a clip already.
function ClipFolderPrompt()
{
    var strDefaultFolder = objPrefs.getCharPref("telekast.folders.clippath");
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance();
    dir.QueryInterface(Components.interfaces.nsILocalFile);
    dir.initWithPath(strDefaultFolder);
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, Element("TeleKastProperties").getString("TELEKAST_SELECT_FOLDER"), nsIFilePicker.modeGetFolder);
    fp.displayDirectory = dir;
    var r = fp.show();
    if (r == nsIFilePicker.returnOK)
    {
        var strOldPath = objPrefs.getCharPref("telekast.folders.clippath");
        objPrefs.setCharPref("telekast.folders.clippath", fp.file.path);
        
        var f = new File(fp.file.path + objSystem.separator + "segmentclip.xml");
        if(!f.exists())
        {
            f = new File(strOldPath + objSystem.separator + "segmentclip.xml");
            f.move(fp.file.path + objSystem.separator + "segmentclip.xml");
        }
        else
        {
            f = new File(strOldPath + objSystem.separator + "segmentclip.xml");
            f.remove();
        }
        
        return fp.file.path;
    }
    else
    {
        return null;
    }
}

// Initializes a "Open Folder" dialog to set the Script file path.
function ScriptFilePathPrompt()
{
    var strDefaultFolder = ""
    
    try
    {
        strDefaultFolder = objPrefs.getCharPref("telekast.folders.filepath");
    }
    catch(e)
    {
        strDefaultFolder = objPrefs.getCharPref(objDirUtils.getHomeDir() + objSystem.separator + strTeleKast);
    }
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance();
    dir.QueryInterface(Components.interfaces.nsILocalFile);
    dir.initWithPath(strDefaultFolder);
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, Element("TeleKastProperties").getString("TELEKAST_SELECT_FOLDER"), nsIFilePicker.modeGetFolder);
    fp.displayDirectory = dir;
    var r = fp.show();
    if (r == nsIFilePicker.returnOK)
    {
        objPrefs.setCharPref("telekast.folders.filepath", fp.file.path);
    }
}

// Initializes a "Open Folder" dialog and moves the template to the new folder if there isn't a template already.
function KETempPrompt()
{
    
    var strDefaultFolder = objPrefs.getCharPref("telekast.kioskeditor.temppath");
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance();
    dir.QueryInterface(Components.interfaces.nsILocalFile);
    dir.initWithPath(strDefaultFolder);
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, Element("TeleKastProperties").getString("TELEKAST_SELECT_FOLDER"), nsIFilePicker.modeGetFolder);
    fp.displayDirectory = dir;
    var r = fp.show();
    if (r == nsIFilePicker.returnOK)
    {
        var strOldPath = objPrefs.getCharPref("telekast.webeditor.temppath");
        objPrefs.setCharPref("telekast.kioskeditor.temppath", fp.file.path);
        
        var f = new File(fp.file.path + objSystem.separator + "ketemp.html");
        if(!f.exists())
        {
            f = new File(strOldPath + objSystem.separator + "ketemp.html");
            f.move(fp.file.path + objSystem.separator + "ketemp.html");
        }
        else
        {
            f = new File(strOldPath + objSystem.separator + "ketemp.html");
            f.remove();
        }
        
        return fp.file.path;
    }
    else
    {
        return null;
    }
}

// Initializes a "Open Folder" dialog to set the Kiosk Editor file path.
function KEFilePathPrompt()
{
    var strDefaultFolder = "";
    
    try
    {
        strDefaultFolder = objPrefs.getCharPref("telekast.folders.kefilepath");
    }
    catch(e)
    {
        strDefaultFolder = objPrefs.getCharPref(objDirUtils.getHomeDir() + objSystem.separator + strTeleKast);
    }
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance();
    dir.QueryInterface(Components.interfaces.nsILocalFile);
    dir.initWithPath(strDefaultFolder);
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, Element("TeleKastProperties").getString("TELEKAST_SELECT_FOLDER"), nsIFilePicker.modeGetFolder);
    fp.displayDirectory = dir;
    var r = fp.show();
    if (r == nsIFilePicker.returnOK)
    {
        objPrefs.setCharPref("telekast.folders.kefilepath", fp.file.path);
    }
}

// Initializes a "Open" dialog and returns a file path.
function WETempPrompt()
{
    var strDefaultFolder = objPrefs.getCharPref("telekast.webeditor.templatepath").substring(0, objPrefs.getCharPref("telekast.webeditor.templatepath").lastIndexOf(objSystem.separator));
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance();
    dir.QueryInterface(Components.interfaces.nsILocalFile);
    dir.initWithPath(strDefaultFolder);
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, Element("TeleKastProperties").getString("TELEKAST_OPEN"), nsIFilePicker.modeOpen);
    fp.appendFilters(nsIFilePicker.filterHTML);
    fp.displayDirectory = dir;
    var r = fp.show();
    if (r == nsIFilePicker.returnOK)
    {
        objPrefs.setCharPref("telekast.webeditor.templatepath", fp.file.path);
    }
}

// Initializes a "Open Folder" dialog and moves the template to the new folder if there isn't a template already.
/*function WETempPrompt()
{
    
    var strDefaultFolder = objPrefs.getCharPref("telekast.webeditor.temppath");
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance();
    dir.QueryInterface(Components.interfaces.nsILocalFile);
    dir.initWithPath(strDefaultFolder);
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, Element("TeleKastProperties").getString("TELEKAST_SELECT_FOLDER"), nsIFilePicker.modeGetFolder);
    fp.displayDirectory = dir;
    var r = fp.show();
    if (r == nsIFilePicker.returnOK)
    {
        var strOldPath = objPrefs.getCharPref("telekast.webeditor.temppath");
        objPrefs.setCharPref("telekast.webeditor.temppath", fp.file.path);
        
        var f = new File(fp.file.path + objSystem.separator + "wetemp.html");
        if(!f.exists())
        {
            f = new File(strOldPath + objSystem.separator + "wetemp.html");
            f.move(fp.file.path + objSystem.separator + "wetemp.html");
        }
        else
        {
            f = new File(strOldPath + objSystem.separator + "wetemp.html");
            f.remove();
        }
        
        return fp.file.path;
    }
    else
    {
        return null;
    }
}*/

// Initializes a "Open Folder" dialog to set the Web Editor file path.
function WEFilePathPrompt()
{
    var strDefaultFolder = ""
    
    try
    {
        strDefaultFolder = objPrefs.getCharPref("telekast.folders.wefilepath");
    }
    catch(e)
    {
        strDefaultFolder = objPrefs.getCharPref(objDirUtils.getHomeDir() + objSystem.separator + strTeleKast);
    }
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance();
    dir.QueryInterface(Components.interfaces.nsILocalFile);
    dir.initWithPath(strDefaultFolder);
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, Element("TeleKastProperties").getString("TELEKAST_SELECT_FOLDER"), nsIFilePicker.modeGetFolder);
    fp.displayDirectory = dir;
    var r = fp.show();
    if (r == nsIFilePicker.returnOK)
    {
        objPrefs.setCharPref("telekast.folders.wefilepath", fp.file.path);
    }
}

// Initializes a "Open" dialog and returns a file path.
function WEInsertImagePrompt()
{

    
    var strDefaultFolder = objPrefs.getCharPref("telekast.webeditor.imagespath");
    var dir = Components.classes["@mozilla.org/file/local;1"].createInstance();
    dir.QueryInterface(Components.interfaces.nsILocalFile);
    dir.initWithPath(strDefaultFolder);
    
    var nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    fp.init(window, Element("TeleKastProperties").getString("TELEKAST_OPEN"), nsIFilePicker.modeOpen);
    fp.appendFilters(nsIFilePicker.filterImages);
    fp.displayDirectory = dir;
    var r = fp.show();
    if (r == nsIFilePicker.returnOK)
    {
        objPrefs.setCharPref("telekast.webeditor.imagespath", fp.file.path.substring(0, fp.file.path.lastIndexOf(objSystem.separator)));
        return fp.file.path;
    }
    else
    {
        return null;
    }

}

// Returns a DOM element by the given id.
function Element(id)
{
    return document.getElementById(id);
}

// Returns a newly created DOM element with the given tag name.
function CreateElement(tag)
{
    return document.createElement(tag);
}

// Returns a newly created DOM attribute with the given name and value.
function CreateAttribute(name, value)
{
    var objAttribute = document.createAttribute(name);
    objAttribute.nodeValue = value;
    return objAttribute;
}
