using System;
using System.IO;
using System.Text.RegularExpressions;

namespace htodef {
	class Class1 {
		[STAThread]
		static void Main(string[] args) {
			Console.WriteLine("LIBRARY tidylib");
			Console.WriteLine("EXPORTS");

			try {
				// Caveat: comments will not correctly parse  /* /* recursive */ c-style */ comments
				Regex comments=new Regex(@"(/\*.*?\*/)|(//.*?$)", RegexOptions.Compiled | RegexOptions.Singleline | RegexOptions.Multiline);
				Regex exports=new Regex(@"^TIDY_EXPORT\s+\S+\s+TIDY_CALL\s+([^\s\(]+)", RegexOptions.Compiled | RegexOptions.Multiline);

				uint pos=1;

				foreach(string s in args) {
					StreamReader sr=new StreamReader(s);
					string contents=sr.ReadToEnd();
					sr.Close();

					contents=comments.Replace(contents, "");

					MatchCollection matches=exports.Matches(contents);
					foreach(Match m in matches)
						Console.WriteLine("   {0,-30} @{1}", m.Groups[1].Value, pos++.ToString());
				}
			}
			catch(Exception ex) {
				Console.Error.WriteLine("Exception Occured: "+ex.ToString());
			}
		}
	}
}
