/*$Id: alert.js,v 1.13 2006/11/05 14:13:36 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

var sentence = null;
var rule = null;

function urltoreg(url)
{
	url = url.replace(/\\/g, '\\\\');
	url = url.replace(/\./g, '\\.');
	url = url.replace(/\*/g, '\\*');
	url = url.replace(/\+/g, '\\+');
	url = url.replace(/\?/g, '\\?');
	url = url.replace(/\{/g, '\\{');
	url = url.replace(/\}/g, '\\}');
	url = url.replace(/\(/g, '\\(');
	url = url.replace(/\)/g, '\\)');
	url = url.replace(/\^/g, '\\^');
	url = url.replace(/\$/g, '\\$');
	url = url.replace(/\|/g, '\\|');
	url = url.replace(/\[/g, '\\[');
	url = url.replace(/\]/g, '\\]');
	url = "/^" + url +"$/i";
	return url;
}

function createRule(url)
{
	var reg = urltoreg(url);
	var reason = "Broken rule. ";
	if (rule.msg)
		reason += rule.msg + " ";
	if (rule.fid)
		reason += "fid: " + rule.fid + " ";
	if (rule.rev)
		reason += "rev: " + rule.rev + " ";
        var option =  "msg:\"" + reason + "\"; " + 
		"url_content:\"" + url + "\"; " +
		"url_re:\"" + reg +"\"; ";
	return option;
}


function alertInit()
{	
	getServices();
	var url = window.arguments[0];
	rule = window.arguments[1];
	sentence = window.arguments[2];
	
	var urlLabel = document.getElementById('url-label');
	urlLabel.setAttribute('value', url);
	var ruleText = document.getElementById('rule-textbox');
	ruleText.setAttribute('value', createRule(url));

	if (rule.msg){
		var msgLabel = document.getElementById('msg-label');
		msgLabel.setAttribute('value', "*** " + rule.msg + " ***");
	}
	
	var count = {};
	var refnode = document.getElementById("references");	
	var references = rule.getReferences(count);

	if (count)
		refnode.setAttribute("hidden", "false");
	
	for(var i = 0; i < count.value; i++){
		var link = document.createElement("label");
		var refurl = ""; 
		if (references[i].system == "url"){
			refurl = references[i].refId;
			if (refurl.length < 8 || 
			    refurl.substring(0, 7) != "http://")
				refurl = "http://" + refurl;
		}
		else if (references[i].system == "bugtraq")
			refurl = "http://www.securityfocus.com/bid/" 
				+ references[i].refId;
		else if (references[i].system == "cve")
			refurl = "http://cve.mitre.org/cgi-bin/cvename.cgi?name=" 
				+ references[i].refId;
		else if (references[i].system == "nessus")
			refurl = "http://cgi.nessus.org/plugins/dump.php3?id=" 
				+ references[i].refId;
		else if (references[i].system == "mcafee")
			refurl = "http://vil.nai.com/vil/dispVirus.asp?virus_k=" 
				+ references[i].refId;
		
		link.setAttribute("class", "url");
		link.setAttribute("value", refurl);
		link.setAttribute("onclick", "viewURL('" + refurl + "');");
		refnode.appendChild(link);
	}	

}


function block()
{
	sentence.action = sentence.BLOCK; 
	close();
}

function allow()
{	
	sentence.action = sentence.AUDIT; 
	close();
}

function whitelist()
{
	var options = document.getElementById('rule-textbox').value;
	
	rulesLoader.whitelist(options);
	sentence.action = sentence.DONT_AUDIT; 
	close();
}

function blacklist()
{
	var options = document.getElementById('rule-textbox').value;
	
	rulesLoader.blacklist(options);
	sentence.action = sentence.BLOCK; 
	close();
}


