/*$Id: Rule.cpp,v 1.14 2007/09/05 21:48:54 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "Rule.h"
#include "Wrap.h"
#include "Error.h"

Rule::Rule()
{
	TRACE("constructor %08x", this);
	actionID = -1;
	action = NULL;
	msg = NULL;
	ruleraw = NULL;
	fid = 0; 
	rev = 0;	
	urlREs.clear();
	headersREs.clear();
	bodyREs.clear();	
	references.clear();	
	url_content.clear();
	headers_content.clear();
	body_content.clear();
}

Rule::~Rule()
{
	TRACE("destructor %08x", this);
}

void Rule::init()
{	
}

/*
  Free memory allocated for all dynamic structures allocated by this rule. 
  Not in destructor, because when Rule structure is copied it shares 
  dynamic structures with oryginal Rule and should not free them when it is
  destroyed.
 */
void Rule::reset()
{
	list<RE>::iterator it;
	list<reference>::iterator it2;
	list<PatternMatchData>::iterator it3;

	if (action)
		free(action);
	if (msg)
		free(msg);
	if (ruleraw)
		free(ruleraw);
	
	for(it = urlREs.begin(); it != urlREs.end(); ++it){
		free(it->re_compiled);
		free(it->pattern);
		if (it->re_extra)
			free(it->re_extra);
	}
	for(it = headersREs.begin(); it != headersREs.end(); ++it){
		free(it->re_compiled);
		free(it->pattern);
		if (it->re_extra)
			free(it->re_extra);
	}
	
	for(it = bodyREs.begin(); it != bodyREs.end(); ++it){
		free(it->re_compiled);
		free(it->pattern);
		if (it->re_extra)
			free(it->re_extra);
	}
	
	for(it2 = references.begin(); it2 != references.end(); ++it2){
		free(it2->system);
		free(it2->refId);
	}
	
	for(it3 = url_content.begin(); it3 != url_content.end(); ++it3){
		free(it3->pattern_buf);
	}

	for(it3 = headers_content.begin(); it3 != headers_content.end(); ++it3){
		free(it3->pattern_buf);
	}

	for(it3 = body_content.begin(); it3 != body_content.end(); ++it3){
		free(it3->pattern_buf);
	}

	urlREs.clear();
	headersREs.clear();
	bodyREs.clear();
	references.clear();
	url_content.clear();
	headers_content.clear();
	body_content.clear();
}


/*
  Does this rule have any options to check URL of a request?
 */
bool Rule::urlRule() const
{
	return (urlREs.size() || url_content.size());
}

/*
  Does this rule have any options to check headers of a response?
 */
bool Rule::headersRule() const
{
	return (headersREs.size() || headers_content.size());
}

/*
  Does this rule have any options to check body of a response?
 */
bool Rule::bodyRule() const
{
	return (bodyREs.size() || body_content.size());
}
