/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.RDFBuilder.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.mozdev.MacroTracker.toolkit.GridBagPanel;
import org.mozilla.RDFBuilder.general.RDFNode;
import org.mozilla.RDFBuilder.general.RDFSaveSet;
import org.mozilla.RDFBuilder.generator.RDFGenerator;
import org.mozilla.RDFBuilder.ui.frmLocaleModification;

public class frmRdfBuilder
extends JFrame
implements TreeSelectionListener,
ActionListener {
    private DefaultMutableTreeNode mRoot;
    private JTree mTree;
    private JMenuItem mnuFileNew;
    private JMenuItem mnuFileOpen;
    private JMenuItem mnuSave;
    private JMenuItem mnuSaveAs;
    private JMenuItem mnuSaveRDF;
    private JMenuItem mnuExit;
    private JMenuItem mnuLocaleModification;
    private JTextField txtName;
    private JTextField txtLink;
    private JTextField txtEnglishVersion;
    private JTextArea txtRDFoutput;
    private JButton btnAdd;
    private JButton btnApply;
    private RDFSaveSet rdfData;

    public frmRdfBuilder() {
        super("Mozilla RDF Builder");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        jMenuBar.add(jMenu);
        this.mnuFileNew = new JMenuItem("New");
        this.mnuFileNew.setMnemonic('N');
        this.mnuFileNew.addActionListener(this);
        jMenu.add(this.mnuFileNew);
        this.mnuFileOpen = new JMenuItem("Open");
        this.mnuFileOpen.setMnemonic('O');
        this.mnuFileOpen.addActionListener(this);
        jMenu.add(this.mnuFileOpen);
        jMenu.addSeparator();
        this.mnuSave = new JMenuItem("Save");
        this.mnuSave.setMnemonic('S');
        this.mnuSave.addActionListener(this);
        jMenu.add(this.mnuSave);
        this.mnuSaveAs = new JMenuItem("Save As...");
        this.mnuSaveAs.setMnemonic('A');
        this.mnuSaveAs.addActionListener(this);
        jMenu.add(this.mnuSaveAs);
        this.mnuSaveRDF = new JMenuItem("Save to RDF...");
        this.mnuSaveRDF.addActionListener(this);
        jMenu.add(this.mnuSaveRDF);
        jMenu.addSeparator();
        this.mnuExit = new JMenuItem("Exit");
        this.mnuExit.setMnemonic('x');
        this.mnuExit.addActionListener(this);
        jMenu.add(this.mnuExit);
        JMenu jMenu2 = new JMenu("Tools");
        jMenu2.setMnemonic('T');
        jMenuBar.add(jMenu2);
        this.mnuLocaleModification = new JMenuItem("Modify by Locale Node...");
        this.mnuLocaleModification.setMnemonic('M');
        this.mnuLocaleModification.addActionListener(this);
        jMenu2.add(this.mnuLocaleModification);
        this.setJMenuBar(jMenuBar);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(150);
        JSplitPane jSplitPane2 = new JSplitPane(0);
        jSplitPane2.setDividerLocation(75);
        this.mRoot = new DefaultMutableTreeNode("RDF file", true);
        this.mTree = new JTree(this.mRoot);
        this.mTree.addTreeSelectionListener(this);
        jSplitPane2.setTopComponent(new JScrollPane(this.mTree));
        this.rdfData = new RDFSaveSet(this.mRoot);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.txtRDFoutput = new JTextArea();
        this.txtRDFoutput.setEditable(false);
        jPanel.add((Component)new JLabel("RDF output:"), "North");
        jPanel.add((Component)new JScrollPane(this.txtRDFoutput), "Center");
        jSplitPane2.setBottomComponent(jPanel);
        GridBagPanel gridBagPanel = new GridBagPanel();
        this.txtName = new JTextField();
        gridBagPanel.add((Component)frmRdfBuilder.pnlGenerator("Name", this.txtName), 1, 1);
        this.txtLink = new JTextField();
        gridBagPanel.add((Component)frmRdfBuilder.pnlGenerator("Link", this.txtLink), 1, 2);
        JPanel jPanel2 = new JPanel();
        this.btnAdd = new JButton("Add");
        this.btnAdd.addActionListener(this);
        jPanel2.add(this.btnAdd);
        this.btnApply = new JButton("Apply");
        this.btnApply.addActionListener(this);
        jPanel2.add(this.btnApply);
        GridBagPanel gridBagPanel2 = new GridBagPanel();
        this.txtEnglishVersion = new JTextField();
        gridBagPanel2.add((Component)frmRdfBuilder.pnlGenerator("English version:", this.txtEnglishVersion), 1, 1);
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)gridBagPanel, "North");
        jTabbedPane.addTab("General", gridBagPanel);
        jTabbedPane.addTab("Localization", gridBagPanel2);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jTabbedPane, "Center");
        jPanel4.add((Component)jPanel2, "South");
        jSplitPane.setLeftComponent(jSplitPane2);
        jSplitPane.setRightComponent(jPanel4);
        container.add((Component)jSplitPane, "Center");
        this.setSize(400, 250);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private void addTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        RDFNode rDFNode = new RDFNode(this.txtName.getText(), this.txtLink.getText());
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(rDFNode, true));
        this.mTree.repaint();
        if (!this.txtEnglishVersion.getText().equals("")) {
            rDFNode.localName = this.txtEnglishVersion.getText();
            this.rdfData.mLocaleNodes.put(rDFNode.localName, rDFNode);
        }
        this.txtRDFoutput.setText(RDFGenerator.generateRDF(this.mRoot));
    }

    public void updateTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (!(defaultMutableTreeNode.getUserObject() instanceof RDFNode)) {
            return;
        }
        RDFNode rDFNode = (RDFNode)defaultMutableTreeNode.getUserObject();
        rDFNode.name = this.txtName.getText();
        rDFNode.location = this.txtLink.getText();
        if (!this.txtEnglishVersion.getText().equals(rDFNode.localName)) {
            this.rdfData.mLocaleNodes.remove(rDFNode.localName);
            rDFNode.localName = this.txtEnglishVersion.getText();
            if (!rDFNode.localName.equals("")) {
                this.rdfData.mLocaleNodes.put(rDFNode.localName, rDFNode);
            }
        }
        this.txtRDFoutput.setText(RDFGenerator.generateRDF(this.mRoot));
    }

    public static JPanel pnlGenerator(String string, JComponent jComponent) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(string), "West");
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getLastSelectedPathComponent();
        if (!(defaultMutableTreeNode.getUserObject() instanceof RDFNode)) {
            return;
        }
        RDFNode rDFNode = (RDFNode)defaultMutableTreeNode.getUserObject();
        this.txtName.setText(rDFNode.name);
        this.txtLink.setText(rDFNode.location);
        this.txtEnglishVersion.setText(rDFNode.localName);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnAdd) {
            this.addTreeNode();
        } else if (actionEvent.getSource() == this.btnApply) {
            this.updateTreeNode();
        } else if (actionEvent.getSource() == this.mnuExit) {
            System.exit(0);
        } else if (actionEvent.getSource() == this.mnuSaveRDF) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    bufferedWriter.write(RDFGenerator.generateRDF(this.mRoot));
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        } else if (actionEvent.getSource() == this.mnuLocaleModification) {
            frmLocaleModification frmLocaleModification2 = new frmLocaleModification(this.rdfData);
        } else if (actionEvent.getSource() == this.mnuSaveAs) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                RDFSaveSet.saveToFile(jFileChooser.getSelectedFile(), this.rdfData);
            }
        } else if (actionEvent.getSource() == this.mnuFileOpen) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                this.rdfData = RDFSaveSet.getFromFile(jFileChooser.getSelectedFile());
                this.mRoot.removeAllChildren();
                for (int i = 0; i < this.rdfData.getRdfNode().getChildCount(); ++i) {
                    this.mRoot.add((DefaultMutableTreeNode)this.rdfData.getRdfNode().getChildAt(i));
                }
                this.mTree.repaint();
            }
        }
    }

    public static void main(String[] stringArray) {
        frmRdfBuilder frmRdfBuilder2 = new frmRdfBuilder();
        frmRdfBuilder2.setDefaultCloseOperation(3);
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

