/** Copyright (c) 2007-2009 eMusic.com Inc.
 
This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.  The GNU Lesser General Public License can be viewed by clicking on the following link:  http://www.gnu.org/licenses/lgpl.html#SEC4.  
 
This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**/

function dlmlistener() {
}

dlmlistener.prototype = {
  name: null,
  uri: null,
  file: null,
  transfer: null,
  lastPercent: -1,
  dlType: null,
  request: null,
  canceled: false,
  
  init:  function(name,uri,file,transfer) {
    this.name      = name;
    this.uri       = uri;
  	this.file      = file;
  	this.transfer  = transfer;
  },

  onLocationChange: function(webProgress, request, location) {
  }, 
  
  onProgressChange: function(webProgress, request, curSelfProgress, maxSelfProgress, curTotalProgress, maxTotalProgress) {

    // Calculate percentage.
    var percent = 0;

    if (maxTotalProgress > 0) {
      percent = Math.ceil((curTotalProgress * 100.0) / maxTotalProgress);

      var emusicDatabase = Cc["@emusic.com/emusic/database;1"].getService(Ci.nsIEmusicDatabase);

      if (percent != this.lastPercent) {
        this.lastPercent = percent;
        
        if (percent >= 100) {
          var thisMediaSync = nsPreferences.copyUnicharPref("eMusic.defaultMediaSync");

          this.lastPercent = 100;
        } else {
          emusicDatabase.updateDownloadProgress(this.file.path, percent);
        }
      }

    }
  },
  
  onSecurityChange: function(webProgress, request, state) {
  },
  
  onStateChange:  function(webProgress, request, stateFlags, status) {
    const WPL = Components.interfaces.nsIWebProgressListener;
    const NS_BINDING_ABORTED = 0x804b0002;

    var mainWindow = dlm_base.mostRecentWindow("emusic:window");
    var emusicDatabase = Cc["@emusic.com/emusic/database;1"].getService(Ci.nsIEmusicDatabase);
    var thisMediaSync = nsPreferences.copyUnicharPref("eMusic.defaultMediaSync");
    var thisFile = this.file.path

    try {
      var httpChannel = request.QueryInterface(Ci.nsIHttpChannel);
      var thisRequestStatus = httpChannel.responseStatus;
      var thisRequestSucceeded = httpChannel.requestSucceeded;
      var thisResponseStatusText = httpChannel.responseStatusText;
      var thisRequestLength = httpChannel.getResponseHeader("Content-Length");
    } catch(ex) {
    }

    if (stateFlags & WPL.STATE_START) {
      this.request = request;
      eActiveDownloads[thisFile] = this;

      reselectTrack(thisFile);
      
      // edebug("responseStatus", thisRequestStatus, thisFile)
      // edebug("requestSucceeded", thisRequestSucceeded, thisFile)
      // edebug("responseStatusText", thisResponseStatusText, thisFile)
      // edebug("Content-Length", thisRequestLength, thisFile)

      //edebug("STATE_START", thisRequestStatus, thisRequestLength, status, "\n\n" + thisFile)
      switch (thisRequestStatus) {
        case "undefined":
          break;
        case 200:
          if (thisRequestLength && thisRequestLength == 0 || status == 2147500037) {
            gHadDownloadErrors = true;
            emusicDatabase.updateDownloadState(thisFile, 8);
            request.cancel(NS_BINDING_ABORTED);
            dlm_base.removeFile(thisFile);
            edebug(thisFile)
          } else {
          }

          break;
        default:
          gHadDownloadErrors = true;
          
          //if (thisRequestStatus == 403) {
          if (!thisRequestSucceeded) {
            emusicDatabase.updateDownloadState(thisFile, 8);
          }

          request.cancel(NS_BINDING_ABORTED);
          dlm_base.removeFile(thisFile);

          eMuNotifier("emusic-download-next", null);
      }

      toggleTotalProgress(false);

    } else if (stateFlags & WPL.STATE_STOP) {
      var thisDLType = this.dlType
      //edebug("STATE_STOP", this.lastPercent, thisRequestStatus, thisRequestLength, status, "\n\n" + thisFile)

      if (this.lastPercent != 100 || (eActiveDownloads[thisFile] && eActiveDownloads[thisFile].canceled) || status == 2152398850) {
        if (!eActiveDownloads[thisFile].canceled) {
          gHadDownloadErrors = true;
          if (thisRequestStatus == 403) {
            emusicDatabase.updateDownloadState(thisFile, 8);
          }
        }

        request.cancel(NS_BINDING_ABORTED);
        dlm_base.removeFile(thisFile);

        edebug("Error Downloading:", "\n\n" + thisFile);

        toggleTotalProgress(true)

        if (eActiveDownloadCount == 0) {
          reselectTrack(thisFile);
          setTimeout(function(){toggleTotalProgress(false);}, 500);
        } else{
          // eMuNotifier("emusic-download-next", null);
        }
      } else {
        emusicDatabase.updateDownloadProgress(thisFile, 100);

        if (thisMediaSync != "NoSync" && status == 0) {
          emusicDatabase.updateDownloadState(thisFile, 5);

          var tmpFile = new Array
          tmpFile.push(thisFile);

          if (nsPreferences.getBoolPref("eMusic.itunes.playlist.enabled") 
              && thisDLType != "Audiobooks" && thisMediaSync == "iTunes" 
              && eMusicPlatform.ident == "WINNT") {
            ePlaylistQueue.push(thisFile);
          }
    
          if (mainWindow) {
            setTimeout(function() {mainWindow.mediaManagers[mainWindow.eMediaSync].syncMedia(tmpFile, thisDLType);}, 0);
          } else {
            setTimeout(function() {mediaManagers[eMediaSync].syncMedia(tmpFile, thisDLType);}, 0);
          }
          //setTimeout(function() {mainWindow.mediaManagers[mainWindow.eMediaSync].syncMedia(tmpFile, thisDLType);}, 0);
        } else {
          emusicDatabase.updateDownloadState(thisFile, 1);

          toggleTotalProgress(true)

          if (eActiveDownloadCount == 0) {
            reselectTrack(thisFile);
            setTimeout(function(){toggleTotalProgress(false);}, 500);
          } else{
            eMuNotifier("emusic-download-next", null);
          }

          // update status again till we resolve some funky sqlite update issues
          setTimeout(function() {
            emusicDatabase.updateDownloadProgress(thisFile, 100);
            emusicDatabase.updateDownloadState(thisFile, 1);
            }, 250);
        }
      }

      delete eActiveDownloads[thisFile];

    }
  },
  
  onStatusChange:  function(webProgress, request, status, message) {
  }, 
  
  QueryInterface:  function(iid) {
  	if (iid.equals(Components.interfaces.nsIWebProgressListener)
  		|| iid.equals(Components.interfaces.nsIDownloadListener)
  		|| iid.equals(Components.interfaces.nsISupports))
  		return this;
  	else (iid.equals(Components.interfaces.nsIRDFRemoteDataSource))
  		throw Components.results.NS_ERROR_NO_INTERFACE;
  }
}

// implementation of nsIURIContentListener
// http://forums.mozillazine.org/viewtopic.php?p=2090958
const EMP_MIMETYPE = "application/vnd.emusic-emusic_package"
const EMX_MIMETYPE = "application/vnd.emusic-emusic_list"
const M3U_MIMETYPE = "audio/x-mpegurl"

var dlmContentListener = {
  thisTimer: null,
  thisFile: null,
  
  QueryInterface: function(iid) {
    if (iid.equals(Components.interfaces.nsIURIContentListener) ||
        iid.equals(Components.interfaces.nsISupportsWeakReference) ||
        iid.equals(Components.interfaces.nsISupports))
        return this;
    throw Components.results.NS_NOINTERFACE;
  },

  onStartURIOpen: function(uri) {
    return false;
  },

  doContent: function(contentType, isContentPreferred, request, contentHandler) {
    // We handle this type
    var channel = request.QueryInterface(Components.interfaces.nsIChannel);
    var myURL = nsIURIToString(channel.URI)

    switch (contentType) {
      case EMP_MIMETYPE:
      case EMX_MIMETYPE:

      	var urlObj = Components.classes['@mozilla.org/network/standard-url;1']
                       .createInstance(Components.interfaces.nsIURL);
      	urlObj.spec = myURL;
        var thisFileExtension = urlObj.fileExtension.toLowerCase()

        try {
          dlm_base.mostRecentWindow().processEM(myURL, urlObj.scheme, thisFileExtension);
          //edebug(ex);
        } catch (ex) {
          edebug("Parsing error (targetBrowser): Probably need to login, parsing error or has exceeded monthly download, redirecting");
          edebug(ex);
          dlm_base.mostRecentWindow().dlm_web.goThere(myURL)
        }

        return true;
        break;
      case M3U_MIMETYPE:
        //edebug(myURL)
        
        var urlObj = Components.classes['@mozilla.org/network/standard-url;1']
                       .createInstance(Components.interfaces.nsIURL);
      	urlObj.spec = myURL;

        if (urlObj.fileExtension.toLowerCase() == "m3u") {
          var tmpPath = dlm_base.getSpecialFolder("TmpD");
          
          tmpPath.append("emusic_m3us")
          var origTmpPath = tmpPath.clone()

          if (!tmpPath.exists()) {
            try {
              tmpPath.create(0x01,0777);
            } catch(ex) {
              edebug(ex);
              return false;
            }
          }

          tmpPath.append(urlObj.fileName);
          tmpPath.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0777);

          this.thisFile = tmpPath.path;

          silentFileDownload(myURL, tmpPath.path, true, this.myListener)

          var entries = origTmpPath.directoryEntries;

          clearTimeout(this.thisTimer)
  
          this.thisTimer = setTimeout(function() {
            var array = [];
            while(entries.hasMoreElements()) {
              var entry = entries.getNext();
              entry.QueryInterface(Components.interfaces.nsIFile);
              if (entry.path != tmpPath.path) {
                entry.remove(false);
              }
            }
          }, 10000);
        }
        return true;
        break;
    }
    return false;
  },

  isPreferred: function(contentType, desiredContentType) {
    // We handle these types
    switch (contentType) {
      case EMP_MIMETYPE:
      case EMX_MIMETYPE:
      case M3U_MIMETYPE:
        return true;
        break;
    }
    return false;
  },

  canHandleContent: function(contentType, isContentPreferred, desiredContentType) {
    // We handle these types
    switch (contentType) {
      case EMP_MIMETYPE:
      case EMX_MIMETYPE:
      case M3U_MIMETYPE:
        return true;
        break;
    }
    return false;
  },

  GetWeakReference: function() {
    return this;
  },

  myListener: {
    STATE_STOP: Components.interfaces.nsIWebProgressListener.STATE_STOP,
    STATE_START: Components.interfaces.nsIWebProgressListener.STATE_START,
    STATE_TRANSFERRING: Components.interfaces.nsIWebProgressListener.STATE_TRANSFERRING,

    QueryInterface : function(aIID) {
      if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
          aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
          aIID.equals(Components.interfaces.nsISupports))
        return this;
      throw Components.results.NS_NOINTERFACE;
    },
  
    onStateChange:function(aProgress, aRequest, aFlag, aStatus) {
      if (aFlag & this.STATE_START) {
      }
      if (aFlag & this.STATE_STOP) {
        try {
          //var channel = aRequest.QueryInterface(Components.interfaces.nsIChannel);
          //var thisLocalFile = nsIURIToString(channel.URI)

          dlm_base.mostRecentWindow().listenToTrack(dlmContentListener.thisFile);

        } catch(ex) {
          edebug(ex)
        }
      }
    },

    onLocationChange:function(a,b,c){},

    onProgressChange:function(a,b,c,d,e,f){

      if(this.STATE_TRANSFERRING) {
        try {
          /*document.getElementById("statusbar-display").label = 
            local_common.myListenerStartMsg + ": " + Math.ceil((e/f) * 100);*/

        } catch(ex) {
        }
      }
    },

    onStatusChange:function(a,b,c,d){},

    onSecurityChange:function(a,b,c){},

    onLinkIconAvailable:function(a){}
  }
}

function nsIURIToString(uri) {
    var result = uri.scheme + "://";
    result += uri.host;
    if (uri.port > 0)result += uri.port;
    result += uri.path;
    return result;
}

// Set up the content listener
var uriLoader = Components.classes["@mozilla.org/uriloader;1"].getService(Components.interfaces.nsIURILoader);
uriLoader.registerContentListener(dlmContentListener);
