definitions = new Array();
definitions["Sample"] = "This is an example of an explanatory tooltip.";
definitions["Anonymous Variables"] = "Anonymous variables do not have names, and are only usable as parameters when calling a javascript function.  Assign the variable a name to use it within script code.  (See the <span class=\"code\">Call</span> method of TJSObject.)";
definitions["Bridge Variables"] = "A bridge variable is one that can be modified by both Delphi/Kylix code and script code.  Any change made in one will be reflected in the other.";
definitions["JSNative"] = "A non-object function prototype whose definition is as follows:<br><br><span class=\"code\" style=\"width:690px\">function(cx: PJSContext; obj: PJSObject; argc: uintN; argv: pjsval; rval: pjsval): JSBool; cdecl;</span>";
definitions["JSFunctionSpec"] = "A record with a fairly simple structure:<br><br><span class=\"code\">&nbsp;&nbsp;JSFunctionSpec = record<br>&nbsp;&nbsp;&nbsp;&nbsp;name: PChar;<br>&nbsp;&nbsp;&nbsp;&nbsp;call: JSNative;&nbsp;// See AddMethod<br>&nbsp;&nbsp;&nbsp;&nbsp;nargs: uint8;&nbsp;&nbsp;&nbsp;// Byte<br>&nbsp;&nbsp;&nbsp;&nbsp;flags: uint8;&nbsp;&nbsp;&nbsp;// Byte<br>&nbsp;&nbsp;&nbsp;&nbsp;extra: uint16;&nbsp;&nbsp;// Word<br>&nbsp;&nbsp;end;</span><br><br>Where <span class=\"code\">nargs</span> is the number of arguments the function expects, <span class=\"code\">flags</span> is any of the <span class=\"code\">JSFUN_*</span> flag values, and <span class=\"code\">extra</span> can be ignored.";
definitions["JSPropertySpec"] = "A record with a fairly simple structure:<br><br><span class=\"code\">&nbsp;&nbsp;JSPropertySpec = record<br>&nbsp;&nbsp;&nbsp;&nbsp;name: PChar;<br>&nbsp;&nbsp;&nbsp;&nbsp;tinyid: int8;<br>&nbsp;&nbsp;&nbsp;&nbsp;flags: uint8;&nbsp;&nbsp;&nbsp;// Byte<br>&nbsp;&nbsp;&nbsp;&nbsp;getter: JSPropertyOp;<br>&nbsp;&nbsp;&nbsp;&nbsp;setter: JSPropertyOp;<br>&nbsp;&nbsp;end;</span><br><br>Where <span class=\"code\">tinyid</span> should not be used, and <span class=\"code\">flags</span> is any of the <span class=\"code\">JSPROP_*</span> flag values.  <span class=\"code\">getter</span> and <span class=\"code\">setter</span> are non-object procedure prototypes which can be declared (if the developer wishes to customize the getting & setting of the property) or simply <span class=\"code\">nil</span>.";
definitions["JSVAL"] = "Each of the <span class=\"code\">JSVAL_*</span> constants is shown below:<br><br><span class=\"code\">&nbsp;&nbsp;JSVAL_OBJECT &nbsp;= 0;<br>&nbsp;&nbsp;JSVAL_INT &nbsp;&nbsp;&nbsp;&nbsp;= 1;<br>&nbsp;&nbsp;JSVAL_DOUBLE &nbsp;= 2;<br>&nbsp;&nbsp;JSVAL_STRING &nbsp;= 4;<br>&nbsp;&nbsp;JSVAL_BOOLEAN = 6;<br>&nbsp;&nbsp;JSVAL_VOID &nbsp;&nbsp;&nbsp;= 0 - $40000000;</span><br><br>Each of them is fairly self-explanatory.  A <span class=\"code\">JSVAL_VOID</span> value means the property or method does not exist.";
definitions["JSType"] = "This is an enumerated type with the following possible values:<br><br><span class=\"code\">&nbsp;&nbsp;JSTYPE_VOID<br>&nbsp;&nbsp;JSTYPE_OBJECT<br>&nbsp;&nbsp;JSTYPE_FUNCTION<br>&nbsp;&nbsp;JSTYPE_STRING<br>&nbsp;&nbsp;JSTYPE_NUMBER<br>&nbsp;&nbsp;JSTYPE_BOOLEAN</span><br><br>A <span class=\"code\">JSTYPE_VOID</span> value means the property or method does not exist.  <span class=\"code\">JSTYPE_NUMBER</span> can indicate either an integer or a floating point value.  Use <span class=\"code\">TJSObject.IsInteger</span> to determine whether it is an integer or floating point value.";

function showTooltip(p_title)
{
	var obj = document.getElementById("tooltip");
	var title = document.getElementById("title");
	var msg = document.getElementById("message");
	var content = document.getElementById("content");

	title.innerHTML = p_title;
	msg.innerHTML = definitions[p_title];

	obj.style.pixelLeft = event.x;
	obj.style.pixelTop = event.y +content.offsetTop;
	obj.style.display = "block";

	ntop = obj.style.pixelTop +obj.offsetHeight;
	nbottom = document.body.offsetHeight +document.body.scrollTop;

	if (ntop > nbottom)
		obj.style.pixelTop = obj.style.pixelTop - obj.offsetHeight;
}

function hideTooltip()
{
	var obj = document.getElementById("tooltip");
	obj.style.display = "none";
}
